package com.yx.demo.center.xx.api.dto.request;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商家业务状态变更
 */
public class SellerBizStatusReqDto {

    @ApiModelProperty("code")
    @NotNull(
        message = "商家编码不能为空"
    )
    private String code;
    @ApiModelProperty("状态（启用 NORMAL、停用 BANNED）")
    @NotBlank(
        message = "状态不能为空"
    )
    private String status;

    public SellerBizStatusReqDto() {
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}