/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.shop.api.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdSellerAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdSellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.mapper.SellerAreaMapper;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.shop.api.dto.request.SellerImportDto;
import com.yx.tcbj.center.shop.api.dto.response.SellerExtExportRespDto;
import com.yx.tcbj.center.shop.api.service.ISellerExtService;
import com.yx.tcbj.center.shop.api.utils.AssertUtil;
import com.yx.tcbj.center.shop.api.utils.EasyPoiExportUtil;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerExtServiceImpl
implements ISellerExtService {
    private Logger logger = LoggerFactory.getLogger(SellerExtServiceImpl.class);
    @Resource
    private SellerAreaMapper sellerAreaMapper;
    @Resource
    private SellerToBDas sellerToBDas;
    @Resource
    private IDictApi dictApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSellerAreaBatch(List<SellerAreaDto> sellerAreaDtoList) {
        AssertUtil.assertNotEmpty(sellerAreaDtoList, "\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        List sellerAreaCodeList = sellerAreaDtoList.stream().map(SellerAreaDto::getAreaCode).distinct().collect(Collectors.toList());
        QueryWrapper sellerAreaQuery = new QueryWrapper();
        sellerAreaQuery.eq((Object)"seller_id", (Object)sellerAreaDtoList.get(0).getSellerId());
        sellerAreaQuery.in((Object)"area_code", sellerAreaCodeList);
        List sellerAreaEos = this.sellerAreaMapper.selectList((Wrapper)sellerAreaQuery);
        Map<Object, Object> sellerAreaEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)sellerAreaEos)) {
            sellerAreaEoMap = sellerAreaEos.stream().collect(Collectors.toMap(StdSellerAreaEo::getAreaCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList addEoList = Lists.newArrayList();
        for (SellerAreaDto sellerAreaDto : sellerAreaDtoList) {
            if (sellerAreaEoMap.isEmpty() || !sellerAreaEoMap.containsKey(sellerAreaDto.getAreaCode())) {
                SellerAreaEo addEo = new SellerAreaEo();
                addEo.setSellerId(sellerAreaDto.getSellerId());
                addEo.setAreaCode(sellerAreaDto.getAreaCode());
                addEo.setAreaLevel(sellerAreaDto.getAreaLevel());
                addEoList.add(addEo);
                continue;
            }
            SellerAreaEo editEo = (SellerAreaEo)sellerAreaEoMap.get(sellerAreaDto.getAreaCode());
            editEo.setAreaLevel(sellerAreaDto.getAreaLevel());
            this.sellerAreaMapper.updateById((BaseEo)editEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)addEoList)) {
            this.sellerAreaMapper.insertBatch((List)addEoList);
        }
    }

    @Override
    public SellerExtExportRespDto importSellerSwitchMasterData(String url) {
        List importDtos;
        SellerExtExportRespDto exportRespDto = new SellerExtExportRespDto();
        try {
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            InputStream is = conn.getInputStream();
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, SellerImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5546\u5bb6\u662f\u5426\u5207\u6362\u4e3b\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        List sellerCodeList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getSellerCode())).map(SellerImportDto::getSellerCode).distinct().collect(Collectors.toList());
        List customerAreaEos = ((ExtQueryChainWrapper)this.sellerToBDas.filter().in((Object)"code", sellerCodeList)).list();
        Map<Object, Object> sellerEoMap = Maps.newHashMap();
        if (CollUtil.isNotEmpty((Collection)customerAreaEos)) {
            sellerEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdSellerEo::getCode, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        for (SellerImportDto importDto : importDtos) {
            if (StringUtils.isEmpty((CharSequence)importDto.getSellerCode())) {
                importDto.setFailMsg("\u5546\u5bb6\u7f16\u7801\u4e3a\u7a7a");
                errorList.add(importDto);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getIsSwitchMasterDataStr())) {
                importDto.setFailMsg("\u662f\u5426\u5207\u6362\u4e3b\u6570\u636e\u4e3a\u7a7a");
                errorList.add(importDto);
                continue;
            }
            if (!sellerEoMap.containsKey(importDto.getSellerCode())) {
                importDto.setFailMsg("\u5546\u5bb6\u4e0d\u5b58\u5728");
                errorList.add(importDto);
                continue;
            }
            if (!Objects.equals(importDto.getIsSwitchMasterDataStr(), "\u662f") || !Objects.equals(importDto.getIsSwitchMasterDataStr(), "\u5426")) {
                importDto.setFailMsg("\u662f\u5426\u5207\u6362\u4e3b\u6570\u636e\u53ea\u80fd\u586b\u662f\u548c\u5426");
                errorList.add(importDto);
                continue;
            }
            if (Objects.equals(importDto.getIsSwitchMasterDataStr(), "\u662f")) {
                importDto.setIsSwitchMasterData(Integer.valueOf(1));
            } else {
                importDto.setIsSwitchMasterData(Integer.valueOf(0));
            }
            successList.add(importDto);
        }
        exportRespDto.setFailNum(Long.valueOf(errorList.size()));
        exportRespDto.setSuccessNum(Long.valueOf(successList.size()));
        exportRespDto.setTotal(Long.valueOf(importDtos.size()));
        if (CollectionUtil.isNotEmpty((Collection)successList)) {
            for (SellerImportDto importDto : successList) {
                SellerEo sellerEo = (SellerEo)sellerEoMap.get(importDto.getSellerCode());
                sellerEo.setIsSwitchMasterData(importDto.getIsSwitchMasterData());
                this.sellerToBDas.update((BaseEo)sellerEo);
                try {
                    if (!Objects.nonNull(importDto.getIsSwitchMasterData())) continue;
                    if (Objects.equals(sellerEo.getIsSwitchMasterData(), 1)) {
                        DictDto dictDto = new DictDto();
                        dictDto.setGroupCode("master_data_org");
                        dictDto.setCode(String.valueOf(sellerEo.getOrganizationId()));
                        dictDto.setValue(sellerEo.getCode());
                        dictDto.setStatement(sellerEo.getName());
                        dictDto.setStatus(Integer.valueOf(1));
                        dictDto.setType("sys");
                        RestResponseHelper.extractData((RestResponse)this.dictApi.saveDict(dictDto));
                        continue;
                    }
                    RestResponseHelper.extractData((RestResponse)this.dictApi.removeDict(Long.valueOf(1L), "master_data_org", String.valueOf(sellerEo.getOrganizationId())));
                }
                catch (Exception e) {
                    this.logger.info("\u5199\u5165\u6570\u636e\u5b57\u5178\u5931\u8d25:{}", (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            String title = "\u5bfc\u5165\u5546\u5bb6\u662f\u5426\u5207\u6362\u4e3b\u6570\u636e\u5931\u8d25\u6587\u4ef6";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, SellerImportDto.class, title, fileName, "xls");
                exportRespDto.setFailFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return exportRespDto;
    }
}

