package com.yx.tcbj.center.trade.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.response.OrderAuditDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 交易中心：订单审核记录服务
 *
 * @author 杰俊
 * @since 2021-10-12
 */
@Api(tags = {"交易中心：订单审核记录服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/orderAuditExt", url = "${yundt.cube.center.trade.api:}")
public interface IOrderAuditExtQueryApi {


    /**
     * 查询订单各阶段审核记录信息（会取最新的审核时间）
     * @param orderNos 订单集合
     * @return 结果
     */
    @PostMapping("/queryList")
    @ApiOperation(value = "查询订单各阶段审核记录信息", notes = "查询订单各阶段审核记录信息")
    RestResponse<List<OrderAuditDetailRespDto>> queryList (@RequestBody List<String> orderNos);
}
