/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.trade.api.dto.request.ExpressCompanyReqDto;
import com.yx.tcbj.center.trade.api.dto.response.ExpressCompanyRespDto;
import com.yx.tcbj.center.trade.biz.service.IExpressCompanyService;
import com.yx.tcbj.center.trade.dao.das.ExpressCompanyDas;
import com.yx.tcbj.center.trade.dao.eo.ExpressCompanyEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExpressCompanyServiceImpl
implements IExpressCompanyService {
    @Resource
    private ExpressCompanyDas expressCompanyDas;

    @Override
    public Long addExpressCompany(ExpressCompanyReqDto addReqDto) {
        ExpressCompanyEo expressCompanyEo = new ExpressCompanyEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)expressCompanyEo);
        this.expressCompanyDas.insert((BaseEo)expressCompanyEo);
        return expressCompanyEo.getId();
    }

    @Override
    public void modifyExpressCompany(ExpressCompanyReqDto modifyReqDto) {
        ExpressCompanyEo expressCompanyEo = new ExpressCompanyEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)expressCompanyEo);
        this.expressCompanyDas.updateSelective((BaseEo)expressCompanyEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeExpressCompany(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.expressCompanyDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ExpressCompanyRespDto queryById(Long id) {
        ExpressCompanyEo expressCompanyEo = (ExpressCompanyEo)this.expressCompanyDas.selectByPrimaryKey(id);
        ExpressCompanyRespDto expressCompanyRespDto = new ExpressCompanyRespDto();
        DtoHelper.eo2Dto((BaseEo)expressCompanyEo, (BaseVo)expressCompanyRespDto);
        return expressCompanyRespDto;
    }

    @Override
    public PageInfo<ExpressCompanyRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ExpressCompanyReqDto expressCompanyReqDto = (ExpressCompanyReqDto)JSON.parseObject((String)filter, ExpressCompanyReqDto.class);
        ExpressCompanyEo expressCompanyEo = new ExpressCompanyEo();
        DtoHelper.dto2Eo((BaseVo)expressCompanyReqDto, (BaseEo)expressCompanyEo);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{expressCompanyEo.getCompanyName()})) {
            expressCompanyEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"company_name", (Object)expressCompanyEo.getCompanyName())}));
            expressCompanyEo.setCompanyName(null);
        }
        PageInfo eoPageInfo = this.expressCompanyDas.selectPage((BaseEo)expressCompanyEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ExpressCompanyRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

