/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.trade.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderAuditTobReqDto;
import com.yx.tcbj.center.trade.api.dto.response.OrderAuditDetailRespDto;
import com.yx.tcbj.center.trade.biz.service.IOrderAuditExtService;
import com.yx.tcbj.center.trade.dao.das.OrderAuditExpandDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderAuditExtServiceImpl
implements IOrderAuditExtService {
    @Resource
    private OrderAuditExpandDas orderAuditExpandDas;

    @Override
    public List<OrderAuditDetailRespDto> queryList(List<String> orderNos) {
        ArrayList<OrderAuditDetailRespDto> orderList = new ArrayList<OrderAuditDetailRespDto>();
        if (CollectionUtil.isEmpty(orderNos)) {
            return orderList;
        }
        List orderAuditTobReqList = this.orderAuditExpandDas.queryList(orderNos);
        if (CollectionUtil.isNotEmpty((Collection)orderAuditTobReqList)) {
            orderNos.forEach(order -> {
                OrderAuditDetailRespDto respDto = new OrderAuditDetailRespDto();
                respDto.setTradeNo(order);
                for (OrderAuditTobReqDto audit : orderAuditTobReqList) {
                    if (!audit.getTradeNo().equals(respDto.getTradeNo())) continue;
                    if (ObjectUtils.isNotEmpty((Object)respDto.getBusinessAudit()) && ObjectUtils.isNotEmpty((Object)respDto.getFinanceAudit())) {
                        return;
                    }
                    if (audit.getAuditType().equals("1")) {
                        respDto.setBusinessAudit(audit);
                        continue;
                    }
                    if (!audit.getAuditType().equals("2")) continue;
                    respDto.setFinanceAudit(audit);
                }
                orderList.add(respDto);
            });
        }
        return orderList;
    }
}

