/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.trade.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.yx.tcbj.center.trade.api.dto.request.RefundDisposeConfigReqDto;
import com.yx.tcbj.center.trade.api.dto.response.RefundDisposeConfigRespDto;
import com.yx.tcbj.center.trade.biz.service.IRefundDisposeConfigService;
import com.yx.tcbj.center.trade.dao.das.RefundDisposeConfigDas;
import com.yx.tcbj.center.trade.dao.eo.RefundDisposeConfigEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RefundDisposeConfigServiceImpl
implements IRefundDisposeConfigService {
    @Resource
    private RefundDisposeConfigDas refundDisposeConfigDas;
    @Resource
    private RefundDas refundDas;

    @Override
    public Long addRefundDisposeConfig(RefundDisposeConfigReqDto addReqDto) {
        RefundDisposeConfigEo refundDisposeConfigEo = new RefundDisposeConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)refundDisposeConfigEo);
        this.refundDisposeConfigDas.insert((BaseEo)refundDisposeConfigEo);
        return refundDisposeConfigEo.getId();
    }

    @Override
    public void modifyRefundDisposeConfig(RefundDisposeConfigReqDto modifyReqDto) {
        if (ObjectUtil.isEmpty((Object)modifyReqDto.getId())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        RefundDisposeConfigEo refundDisposeConfigEo = new RefundDisposeConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)refundDisposeConfigEo);
        this.refundDisposeConfigDas.updateSelective((BaseEo)refundDisposeConfigEo);
    }

    @Override
    public RefundDisposeConfigRespDto queryByNo(String returnNo) {
        RefundDisposeConfigEo refundDisposeConfigEo = new RefundDisposeConfigEo();
        refundDisposeConfigEo.setOrderNo(returnNo);
        RefundDisposeConfigEo ConfigEo = (RefundDisposeConfigEo)this.refundDisposeConfigDas.selectOne((BaseEo)refundDisposeConfigEo);
        RefundDisposeConfigRespDto refundDisposeConfigRespDto = new RefundDisposeConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)ConfigEo, (BaseVo)refundDisposeConfigRespDto);
        return refundDisposeConfigRespDto;
    }

    @Override
    public RefundDisposeConfigRespDto queryByRefundNo(String refundNo) {
        RefundDisposeConfigRespDto refundDisposeConfigRespDto = new RefundDisposeConfigRespDto();
        RefundEo seaEo = new RefundEo();
        seaEo.setRefundNo(refundNo);
        RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)seaEo);
        if (ObjectUtil.isNotEmpty((Object)refundEo) && StringUtils.isNotBlank((CharSequence)refundEo.getReturnNo())) {
            RefundDisposeConfigEo refundDisposeConfigEo = new RefundDisposeConfigEo();
            refundDisposeConfigEo.setOrderNo(refundEo.getReturnNo());
            RefundDisposeConfigEo ConfigEo = (RefundDisposeConfigEo)this.refundDisposeConfigDas.selectOne((BaseEo)refundDisposeConfigEo);
            DtoHelper.eo2Dto((BaseEo)ConfigEo, (BaseVo)refundDisposeConfigRespDto);
        }
        return refundDisposeConfigRespDto;
    }

    @Override
    public List<String> queryByChannelType(Integer refundChannelType) {
        ArrayList<String> resList = new ArrayList<String>();
        RefundDisposeConfigEo searchEo = new RefundDisposeConfigEo();
        searchEo.setRefundChannelType(refundChannelType);
        List eoList = this.refundDisposeConfigDas.selectWithColumn((BaseEo)searchEo, new String[]{"order_no"});
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            eoList.forEach(e -> resList.add(e.getOrderNo()));
        }
        return resList;
    }

    @Override
    public List<RefundDisposeConfigRespDto> queryByRefundNoList(List<String> returnNoList) {
        ArrayList<RefundDisposeConfigRespDto> respDtoList = new ArrayList<RefundDisposeConfigRespDto>();
        if (CollectionUtils.isEmpty(returnNoList)) {
            return respDtoList;
        }
        returnNoList.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(returnNoList)) {
            return respDtoList;
        }
        RefundDisposeConfigEo configEo = new RefundDisposeConfigEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"order_no", returnNoList));
        configEo.setSqlFilters(sqlFilters);
        List refundConfigList = this.refundDisposeConfigDas.select((BaseEo)configEo);
        CubeBeanUtils.copyCollection(respDtoList, (Collection)refundConfigList, RefundDisposeConfigRespDto.class);
        return respDtoList;
    }
}

