/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.QueryOrgByCreditReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationThreeService;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationInfoMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationMapper;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class IOrganizationQueryThreeServiceImpl
implements IOrganizationThreeService {
    private static final Logger log = LoggerFactory.getLogger(IOrganizationQueryThreeServiceImpl.class);
    @Resource
    private OrganizationInfoDas organizationInfoDas;
    @Resource
    private OrganizationInfoMapper organizationInfoMapper;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private IContext context;

    @Override
    public List<OrgAdvInfoRespDto> queryOrgByCredit(QueryOrgByCreditReqDto queryOrgByCreditReqDto) {
        OrganizationInfoEo queryOrganizationInfoParam = new OrganizationInfoEo();
        queryOrganizationInfoParam.setCreditCode(queryOrgByCreditReqDto.getCredit());
        List organizationInfoEoList = this.organizationInfoDas.select((BaseEo)queryOrganizationInfoParam);
        if (Objects.isNull(organizationInfoEoList) || organizationInfoEoList.isEmpty()) {
            return new ArrayList<OrgAdvInfoRespDto>();
        }
        List orgCodeList = organizationInfoEoList.stream().map(StdOrganizationInfoEo::getOrgCode).collect(Collectors.toList());
        List organizationEoList = this.organizationMapper.selectList((Wrapper)new LambdaQueryWrapper().in(StdOrganizationEo::getCode, orgCodeList));
        Map<String, OrganizationEo> organizationEoMap = organizationEoList.stream().filter(organizationEo -> {
            for (OrganizationInfoEo organizationInfoEo : organizationInfoEoList) {
                if (!organizationEo.getCode().equals(organizationInfoEo.getOrgCode())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toMap(StdOrganizationEo::getCode, e -> e));
        ArrayList<OrgAdvInfoRespDto> result = new ArrayList<OrgAdvInfoRespDto>();
        for (OrganizationInfoEo organizationInfoEo : organizationInfoEoList) {
            OrgAdvInfoRespDto orgAdvInfoRespDto = new OrgAdvInfoRespDto();
            BeanUtils.copyProperties((Object)organizationInfoEo, (Object)orgAdvInfoRespDto);
            OrganizationEo organizationEo2 = organizationEoMap.get(organizationInfoEo.getOrgCode());
            if (organizationEo2 != null) {
                orgAdvInfoRespDto.setOrgId(organizationEo2.getId());
            }
            result.add(orgAdvInfoRespDto);
        }
        return result;
    }

    @Override
    public Integer modify(ModifyOrganizationReqDto reqDto) {
        OrganizationEo organizationEo = new OrganizationEo();
        organizationEo.setId(reqDto.getId());
        organizationEo.setName(reqDto.getName());
        organizationEo.setUpdatePerson(this.context.userName());
        organizationEo.setUpdateTime(new Date());
        return this.organizationDas.updateSelective((BaseEo)organizationEo);
    }

    @Override
    public Long saveOrUpdateOrgInfo(ModifyOrganizationInfoReqDto reqDto) {
        OrganizationEo organizationEo = (OrganizationEo)this.organizationMapper.selectById((Serializable)reqDto.getOrgId());
        if (ObjectUtils.isEmpty((Object)organizationEo) || ObjectUtils.isEmpty((Object)organizationEo.getCode())) {
            throw new BizException("-1", "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + reqDto.getOrgId());
        }
        List list = this.organizationInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(StdOrganizationInfoEo::getOrgCode, (Object)organizationEo.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            OrganizationInfoEo organizationInfoParam = new OrganizationInfoEo();
            organizationInfoParam.setId(((OrganizationInfoEo)list.get(0)).getId());
            organizationInfoParam.setOrgName(reqDto.getOrgName());
            organizationInfoParam.setCreditCode(reqDto.getCreditCode());
            organizationInfoParam.setLegalName(reqDto.getLegalName());
            this.organizationInfoMapper.updateById((BaseEo)organizationInfoParam);
        } else {
            OrganizationInfoEo organizationInfoParam = new OrganizationInfoEo();
            organizationInfoParam.setOrgCode(organizationEo.getCode());
            organizationInfoParam.setTenantId(organizationEo.getTenantId());
            organizationInfoParam.setOrgName(reqDto.getOrgName());
            organizationInfoParam.setCreditCode(reqDto.getCreditCode());
            organizationInfoParam.setLegalName(reqDto.getLegalName());
            this.organizationInfoMapper.insert((Object)organizationInfoParam);
        }
        return organizationEo.getId();
    }
}

