/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeOrgRelationExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeOrgRelationExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.EmployeeTaskEnum;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.scheduleds.EmployeeStatusTask;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeExpandService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleExtendService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.service.impl.AbstractEmployeeExpandServiceImpl;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeExpandDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeRoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.EmployeeExpandMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserOrganizationExtMapper;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeExpandEo;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeOrgizationQueryVo;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeRoleEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeExpandServiceImpl
extends AbstractEmployeeExpandServiceImpl
implements IEmployeeExpandService {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeExpandServiceImpl.class);
    @Resource
    private EmployeeExpandDas employeeExpandDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private EmployeeOrgDas employeeOrganizationRelationDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private UserDas userDas;
    @Resource
    private IUserService userService;
    @Resource
    private EmployeeRoleDas employeeRoleDas;
    @Resource
    private IOrgGroupService orgGroupService;
    @Resource
    private RoleDas roleDas;
    @Resource
    private UserOrganizationExtMapper userOrganizationExtMapper;
    @Resource
    private EmployeeStatusTask employeeStatusTask;
    @Resource
    private IRoleExtendService roleExtendService;
    @Resource
    private IRoleService roleService;
    @Resource
    private EmployeeExpandMapper employeeExpandMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addEmployee(Long instanceId, EmployeeExtReqDto employeeDto) {
        logger.info("\u65b0\u589e\u4eba\u5458\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeDto));
        super.checkBindUser(instanceId, employeeDto);
        EmployeeExpandEo employeeExpandEo = new EmployeeExpandEo();
        BeanUtils.copyProperties((Object)employeeDto, (Object)employeeExpandEo);
        logger.info("\u751f\u6210\u5168\u5c40\u552f\u4e00\u4eba\u5458ID:{}", (Object)10);
        employeeExpandEo.setStaffId(this.buildStaffId(this.generateId(10)));
        this.employeeExpandDas.insert((BaseEo)employeeExpandEo);
        employeeDto.setId(employeeExpandEo.getId());
        this.bindEmployeeOrganizationRelation(employeeExpandEo.getId(), employeeDto);
        this.bindEmployeeRoleRelation(employeeDto);
        this.employeeStatusTask.execTask(employeeDto, EmployeeTaskEnum.EXPIRED);
        return employeeExpandEo.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    protected List<EmployeeOrgEo> bindEmployeeOrganizationRelation(Long employeeId, EmployeeExtReqDto employeeDto) {
        EmployeeOrgEo deleteOldParam = new EmployeeOrgEo();
        deleteOldParam.setEmployeeId(employeeId);
        deleteOldParam.setOrganizationId(employeeDto.getOrganizationId());
        this.employeeOrganizationRelationDas.delete((BaseEo)deleteOldParam);
        ArrayList<EmployeeOrgEo> results = new ArrayList<EmployeeOrgEo>();
        if (Objects.nonNull(employeeDto.getOrganizationId())) {
            OrganizationEo orgSelectParam = new OrganizationEo();
            orgSelectParam.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)"id", (Object)employeeDto.getOrganizationId())));
            List organizationEoList = this.organizationDas.select((BaseEo)orgSelectParam);
            if (CollectionUtils.isNotEmpty((Collection)organizationEoList)) {
                Long orgGroupId = this.orgGroupService.queryDefaultHumanOrgGroup(employeeDto.getTenantId());
                if (orgGroupId == null) {
                    throw new BizException("500", "orgGroupId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List collect = organizationEoList.stream().map(organizationEo -> {
                    EmployeeOrgEo employeeOrganizationRelationEo = new EmployeeOrgEo();
                    employeeOrganizationRelationEo.setEmployeeId(employeeId);
                    employeeOrganizationRelationEo.setExtension("");
                    employeeOrganizationRelationEo.setOrgGroupId(orgGroupId);
                    employeeOrganizationRelationEo.setOrganizationId(organizationEo.getId());
                    employeeOrganizationRelationEo.setInstanceId(employeeDto.getInstanceId());
                    employeeOrganizationRelationEo.setTenantId(employeeDto.getTenantId());
                    employeeOrganizationRelationEo.setUserId(employeeDto.getUserId());
                    return employeeOrganizationRelationEo;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    results.addAll(collect);
                }
                if (CollectionUtils.isNotEmpty(results)) {
                    this.employeeOrganizationRelationDas.insertBatch(results);
                }
            }
        }
        String key = RedisKeyConstants.combineKey((String)"findByEmployeeId", (Object[])new Object[]{employeeId});
        this.cacheService.setCache(key, (Object)JSONObject.toJSONString(results));
        return results;
    }

    @Transactional(rollbackFor={Exception.class})
    protected void bindEmployeeRoleRelation(EmployeeExtReqDto employeeDto) {
        List roleReqDtos;
        logger.info("\u7ed1\u5b9a\u4eba\u5458\u89d2\u8272\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString((Object)employeeDto));
        EmployeeRoleEo roleEo = new EmployeeRoleEo();
        roleEo.setInstanceId(employeeDto.getInstanceId());
        roleEo.setTenantId(employeeDto.getTenantId());
        roleEo.setOrgId(employeeDto.getOrganizationId());
        roleEo.setEmployeeId(employeeDto.getId());
        List existsEmployeRoles = this.employeeRoleDas.select((BaseEo)roleEo);
        if (CollectionUtils.isNotEmpty((Collection)existsEmployeRoles)) {
            this.employeeRoleDas.logicDeleteByIds(existsEmployeRoles.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty((Collection)(roleReqDtos = employeeDto.getEmployeeRoleDtoList()))) {
            logger.info("\u65e0\u9700\u8981\u7ed1\u5b9a\u7684\u6570\u636e");
            return;
        }
        ArrayList<EmployeeRoleEo> insertEos = new ArrayList<EmployeeRoleEo>(16);
        for (EmployeeRoleReqDto reqDto : roleReqDtos) {
            EmployeeRoleEo eo = new EmployeeRoleEo();
            BeanUtils.copyProperties((Object)employeeDto, (Object)eo);
            eo.setId(null);
            eo.setEmployeeId(employeeDto.getId());
            eo.setUserId(employeeDto.getUserId());
            eo.setOrgId(employeeDto.getOrganizationId());
            eo.setRoleId(reqDto.getRoleId());
            eo.setRoleCode(reqDto.getRoleCode());
            eo.setSuperAdmin(Objects.isNull(reqDto.getSuperAdmin()) ? YesOrNoEnum.NO.getStatus() : reqDto.getSuperAdmin());
            eo.setDr(YesOrNoEnum.NO.getStatus());
            eo.setInstanceId(employeeDto.getInstanceId());
            eo.setTenantId(employeeDto.getTenantId());
            insertEos.add(eo);
        }
        if (CollectionUtils.isNotEmpty(insertEos)) {
            this.employeeRoleDas.insertBatch(insertEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEmployee(Long instanceId, EmployeeExtReqDto employeeDto) {
        logger.info("\u4fee\u6539\u4eba\u5458\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeDto));
        super.checkBindUser(instanceId, employeeDto);
        EmployeeExpandEo employeeExpandEo = (EmployeeExpandEo)this.employeeExpandDas.selectByPrimaryKey(employeeDto.getId());
        if (StringUtils.isEmpty((CharSequence)employeeExpandEo.getStaffId())) {
            logger.info("\u751f\u6210\u5168\u5c40\u552f\u4e00\u4eba\u5458ID:{}", (Object)10);
            employeeExpandEo.setStaffId(this.buildStaffId(this.generateId(10)));
        }
        BeanUtils.copyProperties((Object)employeeDto, (Object)employeeExpandEo, (String[])new String[]{"staffId"});
        employeeExpandEo.setInstanceId(instanceId);
        this.employeeExpandDas.update((BaseEo)employeeExpandEo);
        this.bindEmployeeOrganizationRelation(employeeExpandEo.getId(), employeeDto);
        this.bindEmployeeRoleRelation(employeeDto);
        this.employeeStatusTask.execTask(employeeDto, EmployeeTaskEnum.EXPIRED);
    }

    @Override
    public PageInfo<EmployeeExtRespDto> queryByPage(EmployeeExtQueryReqDto reqDto) {
        logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)reqDto.getOrganizationId());
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getEmployeeRoleDtoList())) {
            List roleIds = reqDto.getEmployeeRoleDtoList().stream().map(EmployeeRoleReqDto::getRoleId).filter(Objects::nonNull).collect(Collectors.toList());
            reqDto.setRoleIds(roleIds);
        }
        PageInfo eoPageInfo = this.employeeExpandDas.employeePage(reqDto);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<EmployeeExtRespDto> dtoList = new ArrayList<EmployeeExtRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmployeeExtRespDto.class);
        this.fillUserName(dtoList);
        this.fillRoleName(dtoList);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public EmployeeExtRespDto queryById(EmployeeExtReqDto reqDto) {
        logger.info("\u67e5\u8be2\u4eba\u5458\u8be6\u60c5queryById\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4eba\u5458\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        EmployeeExpandEo expandEo = (EmployeeExpandEo)this.employeeExpandDas.selectByPrimaryKey(reqDto.getId());
        ArrayList<EmployeeExtRespDto> respDtos = new ArrayList<EmployeeExtRespDto>(1);
        if (Objects.isNull(expandEo) || Objects.isNull(expandEo.getId())) {
            return null;
        }
        EmployeeExtRespDto respDto = new EmployeeExtRespDto();
        BeanUtils.copyProperties((Object)expandEo, (Object)respDto);
        respDto.setOrgId(reqDto.getOrganizationId());
        if (ObjectUtils.isEmpty((Object)respDto.getOrganizationId())) {
            respDto.setOrganizationId(reqDto.getOrganizationId());
        }
        respDtos.add(respDto);
        if (CollectionUtils.isNotEmpty(respDtos)) {
            this.fillUserName(respDtos);
            this.fillRoleName(respDtos);
            this.fillOrganizationInfo(respDtos);
            return (EmployeeExtRespDto)respDtos.get(0);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotEmpty((Collection)reqDto.getIds(), (String)"\u4eba\u5458\u4e3b\u952eID[\u5c5e\u6027\u540d\uff1aids]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getStatus(), (String)"\u72b6\u6001[\u5c5e\u6027\u540d\uff1astatus]\u4e0d\u80fd\u4e3a\u7a7a");
        EmployeeExpandEo eo = new EmployeeExpandEo();
        eo.setStatus(reqDto.getStatus());
        eo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", (Object)reqDto.getIds())));
        this.employeeExpandDas.updateSelectiveSqlFilter((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setSuperAdmin(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4eba\u5458\u4e3b\u952eID[\u5c5e\u6027\u540d\uff1aid]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getSuperAdmin(), (String)"\u662f\u5426\u8d85\u7ea7\u7ba1\u7406\u5458[0-\u5426\uff0c1-\u662f]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty((Collection)reqDto.getEmployeeRoleDtoList(), (String)"\u89d2\u8272\u4fe1\u606f[\u5c5e\u6027\u540d\uff1aemployeeRoleDtoList]\u4e0d\u80fd\u4e3a\u7a7a");
        RoleAccessDto roleAccessDto = this.roleService.queryById(((EmployeeRoleReqDto)reqDto.getEmployeeRoleDtoList().get(0)).getRoleId());
        AssertUtil.assertNotNull((Object)roleAccessDto, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272");
        AssertUtil.isFalse((boolean)roleAccessDto.getCode().equals("admin_code"), (String)"\u8bf7\u6c42\u89d2\u8272\u4e0d\u662f\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272");
        Long organizationId = reqDto.getOrganizationId();
        EmployeeRoleEo roleQueryEo = new EmployeeRoleEo();
        roleQueryEo.setSuperAdmin(YesOrNoEnum.YES.getStatus());
        roleQueryEo.setInstanceId(instanceId);
        roleQueryEo.setTenantId(reqDto.getTenantId());
        roleQueryEo.setOrgId(organizationId);
        List roleEos = this.employeeRoleDas.select((BaseEo)roleQueryEo);
        if (CollectionUtils.isNotEmpty((Collection)roleEos)) {
            for (EmployeeRoleEo eo : roleEos) {
                this.employeeRoleDas.deleteById(eo.getId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getEmployeeRoleDtoList())) {
            EmployeeRoleReqDto roleReqDto = (EmployeeRoleReqDto)reqDto.getEmployeeRoleDtoList().get(0);
            AssertUtil.assertNotNull((Object)roleReqDto.getRoleId(), (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.assertNotBlank((String)roleReqDto.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            EmployeeExpandEo employeeExpandEo = (EmployeeExpandEo)this.employeeExpandDas.selectByPrimaryKey(reqDto.getId());
            EmployeeRoleEo insertEo = new EmployeeRoleEo();
            insertEo.setEmployeeId(reqDto.getId());
            insertEo.setOrgId(organizationId);
            insertEo.setSuperAdmin(reqDto.getSuperAdmin());
            insertEo.setInstanceId(instanceId);
            insertEo.setTenantId(reqDto.getTenantId());
            insertEo.setRoleId(roleReqDto.getRoleId());
            insertEo.setRoleCode(roleReqDto.getRoleCode());
            if (Objects.nonNull(employeeExpandEo.getUserId())) {
                insertEo.setUserId(employeeExpandEo.getUserId());
            }
            this.employeeRoleDas.insert((BaseEo)insertEo);
        }
    }

    private EmployeeExpandEo buildQueryEo(EmployeeExtQueryReqDto reqDto) {
        EmployeeExpandEo eo = new EmployeeExpandEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>(32);
        if (Objects.nonNull(reqDto.getOrganizationId())) {
            filters.add(SqlFilter.eq((String)"organization_id", (Object)reqDto.getOrganizationId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            filters.add(SqlFilter.like((String)"name", (Object)("%" + reqDto.getName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getStation())) {
            filters.add(SqlFilter.like((String)"station", (Object)("%" + reqDto.getStation() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPosition())) {
            filters.add(SqlFilter.like((String)"position", (Object)("%" + reqDto.getPosition() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getEmployeeNo())) {
            filters.add(SqlFilter.like((String)"employee_no", (Object)("%" + reqDto.getEmployeeNo() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPhoneNum())) {
            filters.add(SqlFilter.like((String)"phone_num", (Object)("%" + reqDto.getPhoneNum() + "%")));
        }
        if (Objects.nonNull(reqDto.getStatus())) {
            filters.add(SqlFilter.eq((String)"status", (Object)reqDto.getStatus()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getUserIds())) {
            filters.add(SqlFilter.in((String)"user_id", (Object)reqDto.getUserIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getIds())) {
            filters.add(SqlFilter.in((String)"id", (Object)reqDto.getIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            filters.add(SqlFilter.in((String)"organization_id", (Object)StringUtils.join((Iterable)reqDto.getOrganizationIdList(), (String)",")));
        }
        eo.setSqlFilters(filters);
        return eo;
    }

    private void fillUserName(List<EmployeeExtRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List collect = dtoList.stream().filter(Objects::nonNull).filter(o -> Objects.nonNull(o.getUserId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        String userIdListStr = collect.stream().map(o -> String.valueOf(o.getUserId())).collect(Collectors.joining(","));
        List userDtos = this.userService.queryByIdList(userIdListStr);
        if (CollectionUtils.isNotEmpty((Collection)userDtos)) {
            for (EmployeeExtRespDto respDto : dtoList) {
                for (UserDto userDto : userDtos) {
                    if (!Objects.nonNull(respDto) || !Objects.nonNull(respDto.getUserId()) || !Objects.nonNull(userDto) || !Objects.nonNull(userDto.getId()) || respDto.getUserId().longValue() != userDto.getId().longValue()) continue;
                    respDto.setUserName(userDto.getUserName());
                }
            }
        }
    }

    private void fillRoleName(List<EmployeeExtRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (EmployeeExtRespDto respDto : dtoList) {
            EmployeeRoleEo employeeRoleEo = new EmployeeRoleEo();
            employeeRoleEo.setEmployeeId(respDto.getId());
            employeeRoleEo.setOrgId(respDto.getOrganizationId());
            employeeRoleEo.setInstanceId(respDto.getInstanceId());
            List roleEos = this.employeeRoleDas.select((BaseEo)employeeRoleEo);
            ArrayList roleRespDtos = new ArrayList(16);
            CubeBeanUtils.copyCollection(roleRespDtos, (Collection)roleEos, EmployeeRoleRespDto.class);
            if (CollectionUtils.isNotEmpty(roleRespDtos)) {
                RoleEo roleEo = new RoleEo();
                roleEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", roleRespDtos.stream().map(EmployeeRoleRespDto::getRoleId).collect(Collectors.toList()))));
                List roleEoList = this.roleDas.select((BaseEo)roleEo);
                if (CollectionUtils.isNotEmpty((Collection)roleEoList)) {
                    for (EmployeeRoleRespDto resp : roleRespDtos) {
                        for (RoleEo eo : roleEoList) {
                            if (!Objects.nonNull(resp) || !Objects.nonNull(resp.getRoleId()) || !Objects.nonNull(eo) || !Objects.nonNull(eo.getId()) || resp.getRoleId().longValue() != eo.getId().longValue()) continue;
                            resp.setRoleName(eo.getName());
                        }
                    }
                }
                respDto.setEmployeeRoleDtoList(roleRespDtos);
            }
            if (!CollectionUtils.isNotEmpty(roleRespDtos)) continue;
            respDto.setOrganizationNames(roleRespDtos.stream().map(EmployeeRoleRespDto::getRoleName).collect(Collectors.joining(";")));
        }
    }

    private void fillOrganizationInfo(List<EmployeeExtRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<Long> orgIdList = dtoList.stream().filter(dto -> YesOrNoEnum.isYes((Integer)dto.getOrganizationStatus())).map(EmployeeExtRespDto::getOrgId).collect(Collectors.toList());
        Map<String, OrganizationEo> orgByIdMap = this.getOrgByIdMap(orgIdList);
        for (EmployeeExtRespDto respDto : dtoList) {
            if (orgByIdMap.isEmpty() || !orgByIdMap.containsKey(respDto.getOrgId())) continue;
            OrganizationEo organizationEo = orgByIdMap.get(respDto.getOrgId());
            respDto.setOrganizationCode(organizationEo.getCode());
            respDto.setOrganizationName(organizationEo.getName());
        }
    }

    @Override
    public PageInfo<EmployeeExtRespDto> queryPageByOrg(Long organizationId, Integer pageNum, Integer pageSize) {
        EmployeeExtQueryReqDto queryReqDto = new EmployeeExtQueryReqDto();
        queryReqDto.setPageNum(pageNum);
        queryReqDto.setPageSize(pageSize);
        queryReqDto.setOrganizationId(organizationId);
        return this.queryByPage(queryReqDto);
    }

    @Override
    public List<Long> getEmployeeOrgIdByUserId(Long userId) {
        EmployeeOrgizationQueryVo vo = new EmployeeOrgizationQueryVo();
        vo.setUserId(userId);
        Date today = DateUtil.getToday();
        vo.setToDay(DateUtil.getDateFormat((Date)today, (String)"yyyy-MM-dd"));
        return this.employeeExpandDas.getEmployeeOrgIdByUserId(vo);
    }

    @Override
    public List<EmployeeExtRespDto> queryByRole(Long roleId, Long instanceId, String organizationId) {
        if (StringUtils.isEmpty((CharSequence)organizationId)) {
            organizationId = super.headerOrgId();
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        return this.employeeExpandDas.queryByRole(roleId, instanceId, organizationId);
    }

    @Override
    public List<OrganizationDto> getOrgInfoByUserId(Long userId) {
        List<Long> orgIdList = this.getEmployeeOrgIdByUserId(userId);
        if (CollectionUtils.isEmpty(orgIdList)) {
            logger.info("\u7528\u6237id[{}]\u67e5\u8be2\u7ec4\u7ec7id\u4e3a\u7a7a", (Object)userId);
            return Lists.newArrayList();
        }
        ArrayList orgList = Lists.newArrayList();
        List orgEoList = this.organizationDas.findByIds(orgIdList);
        if (CollectionUtils.isEmpty((Collection)orgEoList)) {
            return orgList;
        }
        CubeBeanUtils.copyCollection((Collection)orgList, (Collection)orgEoList, OrganizationDto.class);
        return orgList;
    }

    @Override
    public List<EmployeeExtRespDto> getEmployeeByUserOrgList(EmployeeExtQueryReqDto reqDto) {
        AssertUtil.assertNotEmpty((Collection)reqDto.getUserIds(), (String)"\u5fc5\u4f20\u53c2\u6570\u7528\u6237ID\u4e3a\u7a7a");
        List employeeExpandEos = this.employeeExpandMapper.employeeList(reqDto);
        if (CollectionUtils.isEmpty((Collection)employeeExpandEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)employeeExpandEos, EmployeeExtRespDto.class);
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<EmployeeExtReqDto> batchSynSaveEmployee(List<EmployeeExtReqDto> addList) {
        logger.info("\u4e3b\u6570\u636e\u540c\u6b65\u6279\u91cf\u66f4\u65b0\u4eba\u5458\u4fe1\u606f==>{}", (Object)JSON.toJSONString(addList));
        List staffIdList = addList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getStaffId())).map(EmployeeExtReqDto::getStaffId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(staffIdList)) {
            logger.info("\u4e3b\u6570\u636e\u540c\u6b65\u6279\u91cf\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u4eba\u5458ID\u4fe1\u606f\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        QueryWrapper empQuery = new QueryWrapper();
        empQuery.eq((Object)"dr", (Object)0);
        empQuery.in((Object)"staff_id", staffIdList);
        List employeeExpandEos = this.employeeExpandMapper.selectList((Wrapper)empQuery);
        Map<Object, Object> empInfoMap = new HashMap(employeeExpandEos.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty((Collection)employeeExpandEos)) {
            empInfoMap = employeeExpandEos.stream().collect(Collectors.toMap(EmployeeExpandEo::getStaffId, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList addEoList = Lists.newArrayList();
        ArrayList updateEoList = Lists.newArrayList();
        ArrayList addEmpOrgList = Lists.newArrayList();
        for (EmployeeExtReqDto employeeExtReqDto : addList) {
            String key = employeeExtReqDto.getStaffId();
            if (StringUtils.isEmpty((CharSequence)key)) {
                logger.info("\u4e3b\u6570\u636e\u540c\u6b65\u6279\u91cf\u66f4\u65b0\u4eba\u5458StaffId\u4e3a\u7a7a,\u4e0d\u505a\u5904\u7406");
                continue;
            }
            if (empInfoMap.containsKey(key)) {
                EmployeeExpandEo updateEo = (EmployeeExpandEo)empInfoMap.get(key);
                DtoHelper.dto2Eo((BaseVo)employeeExtReqDto, (BaseEo)updateEo, (String[])new String[]{"id", "staffId"});
                updateEoList.add(updateEo);
                continue;
            }
            EmployeeExpandEo employeeExpandEo = new EmployeeExpandEo();
            long id = IdGenrator.nextId((long)IdGenrator.getWorkerId(), (long)ServiceContext.getContext().getRequestTenantCode());
            employeeExtReqDto.setId(Long.valueOf(id));
            DtoHelper.dto2Eo((BaseVo)employeeExtReqDto, (BaseEo)employeeExpandEo);
            addEoList.add(employeeExpandEo);
            EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
            employeeOrgEo.setInstanceId(employeeExpandEo.getInstanceId());
            employeeOrgEo.setTenantId(employeeExpandEo.getTenantId());
            employeeOrgEo.setEmployeeId(employeeExpandEo.getId());
            employeeOrgEo.setOrganizationId(employeeExpandEo.getOrganizationId());
            employeeOrgEo.setUserId(employeeExpandEo.getUserId());
            addEmpOrgList.add(employeeOrgEo);
        }
        logger.info("\u65b0\u589e\u5458\u5de5\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)addEoList));
        if (CollectionUtils.isNotEmpty((Collection)addEoList)) {
            this.employeeExpandDas.insertBatch((List)addEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addEmpOrgList)) {
            this.employeeOrganizationRelationDas.insertBatch((List)addEmpOrgList);
        }
        logger.info("\u66f4\u65b0\u5458\u5de5\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)updateEoList));
        if (CollectionUtils.isNotEmpty((Collection)updateEoList)) {
            this.employeeExpandDas.updateBatch((List)updateEoList);
        }
        Date today = DateUtil.getToday();
        for (EmployeeExtReqDto employeeDto : addList) {
            if (StringUtils.isEmpty((CharSequence)employeeDto.getStaffId())) continue;
            if (Objects.isNull(employeeDto.getEndTime())) {
                logger.info("\u4eba\u5458\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
                continue;
            }
            Date endTime = employeeDto.getEndTime();
            String dateFormat = DateUtil.getDateFormat((Date)endTime, (String)"yyyy-MM-dd");
            if ((endTime = DateUtil.parseDate((String)dateFormat, (String)"yyyy-MM-dd")).compareTo(today) < 0) {
                logger.info("\u4eba\u5458\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\u671f");
                continue;
            }
            this.employeeStatusTask.execTask(employeeDto, EmployeeTaskEnum.EXPIRED);
        }
        return addList;
    }

    @Override
    public List<EmployeeOrgRelationExtRespDto> queryEmployeeOrgParam(EmployeeOrgRelationExtReqDto employeeOrgRelationReqDto) {
        EmployeeOrgEo employeeOrgEo = new EmployeeOrgEo();
        CubeBeanUtils.copyProperties((Object)employeeOrgEo, (Object)employeeOrgRelationReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)employeeOrgEo);
        if (CollectionUtils.isNotEmpty((Collection)employeeOrgRelationReqDto.getEmployeeIdList())) {
            queryWrapper.in(StdEmployeeOrgEo::getEmployeeId, (Collection)employeeOrgRelationReqDto.getEmployeeIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)employeeOrgRelationReqDto.getOrganizationIdList())) {
            queryWrapper.in(StdEmployeeOrgEo::getOrganizationId, (Collection)employeeOrgRelationReqDto.getOrganizationIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)employeeOrgRelationReqDto.getUserIdList())) {
            queryWrapper.in(StdEmployeeOrgEo::getUserId, (Collection)employeeOrgRelationReqDto.getUserIdList());
        }
        List employeeOrgEos = this.employeeOrganizationRelationDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)employeeOrgEos, EmployeeOrgRelationExtRespDto.class);
        return respDtos;
    }
}

