/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.UserDtoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.tcbj.UserRespExtDto;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserExpandService;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserExtDas2;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserOrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserExtMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserOrganizationExtMapper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserExpandServiceImpl
implements IUserExpandService {
    private static final Logger log = LoggerFactory.getLogger(UserExpandServiceImpl.class);
    @Resource
    private UserExtMapper userExtMapper;
    @Resource
    private UserOrganizationExtMapper userOrganizationExtMapper;
    @Resource
    private IContext context;
    @Resource
    private UserOrganizationDas userOrganizationDas;
    @Resource
    private UserExtDas2 userExtDas2;

    @Override
    public List<UserRespDto> queryUserByOrgIdList(Long orgId, String userName) {
        AssertUtil.assertNotNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e3a\u7a7a");
        QueryWrapper userOrgQuery = new QueryWrapper();
        userOrgQuery.eq((Object)"dr", (Object)0);
        userOrgQuery.eq((Object)"organization_id", (Object)orgId);
        List userOrganizationEos = this.userOrganizationExtMapper.selectList((Wrapper)userOrgQuery);
        if (CollectionUtils.isEmpty((Collection)userOrganizationEos)) {
            return Lists.newArrayList();
        }
        List userIdList = userOrganizationEos.stream().map(UserOrganizationEo::getUserId).distinct().collect(Collectors.toList());
        QueryWrapper userQuery = new QueryWrapper();
        userQuery.eq((Object)"dr", (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            userQuery.like((Object)"user_name", (Object)userName);
        }
        userQuery.in((Object)"id", userIdList);
        List userEos = this.userExtMapper.selectList((Wrapper)userQuery);
        if (CollectionUtils.isEmpty((Collection)userEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)userEos, (Collection)respDtos, UserRespDto.class);
        return respDtos;
    }

    @Override
    public List<UserOrgizationRespDto> queryUserOrgByUserName(List<String> userNameList) {
        if (CollectionUtils.isEmpty(userNameList)) {
            return Lists.newArrayList();
        }
        List userOrgizationVos = this.userOrganizationExtMapper.queryUserOrgByUserName(userNameList);
        if (CollectionUtils.isEmpty((Collection)userOrgizationVos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)userOrgizationVos, UserOrgizationRespDto.class);
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateUserOrgInfo(UserOrgRelationReqDto userOrgRelationReqDto) {
        log.info("\u65b0\u589e\u6216\u66f4\u65b0\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f-{}", (Object)JSON.toJSONString((Object)userOrgRelationReqDto));
        AssertUtil.assertNotNull((Object)userOrgRelationReqDto.getUserId(), (String)"\u7528\u6237id\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty((Collection)userOrgRelationReqDto.getOrgIds(), (String)"\u7ec4\u7ec7id\u4e3a\u7a7a");
        List list = this.userOrganizationDas.selectListByUserIdAndOrgIdList(userOrgRelationReqDto.getUserId(), userOrgRelationReqDto.getOrgIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List delIdList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.userOrganizationDas.logicDeleteByIds(delIdList);
        }
        ArrayList eoList = Lists.newArrayList();
        for (Long orgId : userOrgRelationReqDto.getOrgIds()) {
            UserOrganizationEo userOrganizationEo = this.buildUserOrganizationEo(userOrgRelationReqDto, orgId);
            eoList.add(userOrganizationEo);
        }
        log.info("\u65b0\u589e\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f-{}", (Object)JSON.toJSONString((Object)eoList));
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            this.userOrganizationDas.insertBatch((List)eoList);
        }
    }

    @Override
    public PageInfo<UserRespExtDto> queryUserPage(UserDtoExtDto userDto) {
        log.info("\u767b\u9646\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)userDto));
        return this.userExtDas2.queryUserPage(userDto);
    }

    private UserOrganizationEo buildUserOrganizationEo(UserOrgRelationReqDto userOrgRelationReqDto, Long orgId) {
        UserOrganizationEo eo = new UserOrganizationEo();
        eo.setUserId(userOrgRelationReqDto.getUserId());
        eo.setOrganizationId(orgId);
        eo.setTenantId(userOrgRelationReqDto.getTenantId() != null ? userOrgRelationReqDto.getTenantId() : this.context.tenantId());
        eo.setInstanceId(userOrgRelationReqDto.getInstanceId() != null ? userOrgRelationReqDto.getInstanceId() : this.context.instanceId());
        eo.setExtension(StringUtils.isNotBlank((CharSequence)userOrgRelationReqDto.getExtension()) ? userOrgRelationReqDto.getExtension() : "");
        return eo;
    }
}

