/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeExpandService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EmployeeExpandQueryApiImpl
implements IEmployeeExpandQueryApi {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeExpandQueryApiImpl.class);
    @Resource
    private IEmployeeExpandService employeeExpandService;
    @Resource
    private IUserService userService;

    public RestResponse<PageInfo<EmployeeExtRespDto>> queryByPage(EmployeeExtQueryReqDto reqDto) {
        logger.info("\u8fdb\u5165\u5206\u9875\u67e5\u8be2\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse(this.employeeExpandService.queryByPage(reqDto));
    }

    public RestResponse<List<UserDto>> queryByIdList(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return new RestResponse();
        }
        return new RestResponse((Object)this.userService.queryByIdList(userIds.stream().map(String::valueOf).collect(Collectors.joining(","))));
    }

    public RestResponse<EmployeeExtRespDto> queryById(EmployeeExtReqDto reqDto) {
        return new RestResponse((Object)this.employeeExpandService.queryById(reqDto));
    }

    public RestResponse<PageInfo<EmployeeExtRespDto>> queryPageByOrg(Long organizationId, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.employeeExpandService.queryPageByOrg(organizationId, pageNum, pageSize));
    }

    public RestResponse<List<Long>> getEmployeeOrgIdByUserId(Long userId) {
        return new RestResponse(this.employeeExpandService.getEmployeeOrgIdByUserId(userId));
    }

    public RestResponse<List<EmployeeExtRespDto>> queryByRole(Long roleId, Long instanceId, String organizationId) {
        return new RestResponse(this.employeeExpandService.queryByRole(roleId, instanceId, organizationId));
    }

    public RestResponse<List<OrganizationDto>> getOrgInfoByUserId(Long userId) {
        return new RestResponse(this.employeeExpandService.getOrgInfoByUserId(userId));
    }

    public RestResponse<List<EmployeeExtRespDto>> getEmployeeByUserOrgList(EmployeeExtQueryReqDto reqDto) {
        return new RestResponse(this.employeeExpandService.getEmployeeByUserOrgList(reqDto));
    }
}

