/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.scheduleds;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.EmployeeTaskEnum;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EmployeeStatusTask {
    private final Logger logger = LoggerFactory.getLogger(EmployeeStatusTask.class);
    @Resource
    private ITaskApi iTaskApi;
    @Value(value="${employee.scheduler.status.appBizCode:}")
    private String appBizCode4Status;
    @Value(value="${employee.scheduler.disable.appBizCode:}")
    private String appBizCode4Disable;
    @Value(value="${employee.scheduler.appCode:}")
    private String appCode;

    public Long execTask(EmployeeExtReqDto reqDto, EmployeeTaskEnum taskEnum) {
        String reqJson = JSON.toJSONString((Object)reqDto);
        this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011" + taskEnum.getValue() + "\u3002\u5165\u53c2\uff1a{}", (Object)reqJson);
        if (Objects.isNull(reqDto)) {
            this.logger.info("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u9000\u51fa\u65b9\u6cd5...");
            return null;
        }
        if (Objects.isNull(reqDto.getEndTime())) {
            this.logger.info("\u4eba\u5458\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08\u5373\u6c38\u4e45\u6709\u6548\uff09\uff0c\u9000\u51fa\u65b9\u6cd5...");
            return null;
        }
        TaskAndBizCreateReqDto task = this.buildTaskAndBiz(reqDto, reqJson, taskEnum);
        this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u5f00\u59cb\u521b\u5efa\u4efb\u52a1(" + taskEnum.getValue() + ")\uff0c\u521b\u5efa\u4efb\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)task));
        try {
            RestResponse restResponse = this.iTaskApi.addWithBiz(task);
            this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u521b\u5efa\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)restResponse));
            if (Objects.nonNull(restResponse) && String.valueOf(0).equals(restResponse.getResultCode())) {
                RequestDto requestDto = new RequestDto();
                requestDto.setInstanceId(Long.valueOf(-1L));
                requestDto.setTenantId(Long.valueOf(-1L));
                this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
            }
            return (Long)restResponse.getData();
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa\u4efb\u52a1(" + taskEnum.getValue() + ")\u5931\u8d25", (Object)ex.getMessage());
            return null;
        }
    }

    private TaskAndBizCreateReqDto buildTaskAndBiz(EmployeeExtReqDto reqDto, String reqJson, EmployeeTaskEnum taskEnum) {
        TaskAndBizCreateReqDto task = new TaskAndBizCreateReqDto();
        task.setBizName(taskEnum.getValue());
        task.setAppCode(this.appCode);
        task.setBizCode("1".equals(String.valueOf(taskEnum.getKey())) ? this.appBizCode4Status : this.appBizCode4Disable);
        task.setInstanceId(Long.valueOf(-1L));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("00 00 00 dd MM ? yyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        task.setScheduleExpression(simpleDateFormat.format(reqDto.getEndTime()));
        task.setShardType("SINGLE");
        task.setTenantId(Long.valueOf(-1L));
        task.setTaskName(taskEnum.getValue() + "_" + System.currentTimeMillis());
        task.setParams(reqJson);
        task.setTaskCode(String.valueOf(System.currentTimeMillis()));
        return task;
    }
}

