/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.UserDtoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.tcbj.UserRespExtDto;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.constant.IdentityConstants;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPasswordService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserExpandService;
import com.dtyunxi.yundt.cube.center.user.dao.das.LoginConfigDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserExtDas2;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserOrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.LoginConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserExtMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserOrganizationExtMapper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserExpandServiceImpl
implements IUserExpandService {
    private static final Logger log = LoggerFactory.getLogger(UserExpandServiceImpl.class);
    @Resource
    private UserExtMapper userExtMapper;
    @Resource
    private UserOrganizationExtMapper userOrganizationExtMapper;
    @Resource
    private IContext context;
    @Resource
    private UserOrganizationDas userOrganizationDas;
    @Resource
    private UserExtDas2 userExtDas2;
    @Resource
    private HttpServletRequest request;
    @Autowired
    private LoginConfigDas loginConfigDas;
    @Value(value="${user.empty.salt.generate.enabled:true}")
    private boolean emptySaltGenerate;
    @Resource
    private IPasswordService passwordService;

    @Override
    public List<UserRespDto> queryUserByOrgIdList(Long orgId, String userName) {
        AssertUtil.assertNotNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e3a\u7a7a");
        QueryWrapper userOrgQuery = new QueryWrapper();
        userOrgQuery.eq((Object)"dr", (Object)0);
        userOrgQuery.eq((Object)"organization_id", (Object)orgId);
        List userOrganizationEos = this.userOrganizationExtMapper.selectList((Wrapper)userOrgQuery);
        if (CollectionUtils.isEmpty((Collection)userOrganizationEos)) {
            return Lists.newArrayList();
        }
        List userIdList = userOrganizationEos.stream().map(UserOrganizationEo::getUserId).distinct().collect(Collectors.toList());
        QueryWrapper userQuery = new QueryWrapper();
        userQuery.eq((Object)"dr", (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            userQuery.like((Object)"user_name", (Object)userName);
        }
        userQuery.in((Object)"id", userIdList);
        List userEos = this.userExtMapper.selectList((Wrapper)userQuery);
        if (CollectionUtils.isEmpty((Collection)userEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)userEos, (Collection)respDtos, UserRespDto.class);
        return respDtos;
    }

    @Override
    public List<UserOrgizationRespDto> queryUserOrgByUserName(List<String> userNameList) {
        if (CollectionUtils.isEmpty(userNameList)) {
            return Lists.newArrayList();
        }
        List userOrgizationVos = this.userOrganizationExtMapper.queryUserOrgByUserName(userNameList);
        if (CollectionUtils.isEmpty((Collection)userOrgizationVos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)userOrgizationVos, UserOrgizationRespDto.class);
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateUserOrgInfo(UserOrgRelationReqDto userOrgRelationReqDto) {
        log.info("\u65b0\u589e\u6216\u66f4\u65b0\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f-{}", (Object)JSON.toJSONString((Object)userOrgRelationReqDto));
        AssertUtil.assertNotNull((Object)userOrgRelationReqDto.getUserId(), (String)"\u7528\u6237id\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty((Collection)userOrgRelationReqDto.getOrgIds(), (String)"\u7ec4\u7ec7id\u4e3a\u7a7a");
        List list = this.userOrganizationDas.selectListByUserIdAndOrgIdList(userOrgRelationReqDto.getUserId(), userOrgRelationReqDto.getOrgIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List delIdList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.userOrganizationDas.logicDeleteByIds(delIdList);
        }
        ArrayList eoList = Lists.newArrayList();
        for (Long orgId : userOrgRelationReqDto.getOrgIds()) {
            UserOrganizationEo userOrganizationEo = this.buildUserOrganizationEo(userOrgRelationReqDto, orgId);
            eoList.add(userOrganizationEo);
        }
        log.info("\u65b0\u589e\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f-{}", (Object)JSON.toJSONString((Object)eoList));
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            this.userOrganizationDas.insertBatch((List)eoList);
        }
    }

    @Override
    public PageInfo<UserRespExtDto> queryUserPage(UserDtoExtDto userDto) {
        String attachment = ServiceContext.getContext().getAttachment("big-b-request-flag");
        String orgId = ServiceContext.getContext().getAttachment("yes-req-cus-b2b-organizationid");
        log.info("\u767b\u9646\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2\uff1a{},\u8bf7\u6c42\u5934id\uff1a{},orgId:{}", new Object[]{JSON.toJSONString((Object)userDto), attachment, orgId});
        if (attachment != null && Boolean.valueOf(attachment).booleanValue()) {
            userDto.setBigBRequestFlag("1");
            userDto.setOrganizationId(orgId);
        }
        return this.userExtDas2.queryUserPage(userDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addUser(UserDto userDto) {
        log.info("\u65b0\u589e\u7528\u6237\u4fe1\u606faddUser\uff1a{}", (Object)JSON.toJSONString((Object)userDto));
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)userDto.getUserName()), (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        ServiceContext serviceContext = ServiceContext.getContext();
        userDto.setTenantId(serviceContext.getRequestTenantId());
        List eoList = ((ExtQueryChainWrapper)this.userExtDas2.filter().eq((Object)"user_name", (Object)userDto.getUserName())).list();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            String organizationId;
            if (CollectionUtils.isEmpty((Collection)userDto.getBelongOrgIds()) && StringUtils.isNotBlank((CharSequence)(organizationId = this.request.getHeader("yes.req.cus.b2b.organizationId")))) {
                ArrayList orgIds = Lists.newArrayList((Object[])new Long[]{Long.valueOf(organizationId)});
                userDto.setBelongOrgIds((List)orgIds);
            }
            UserEo userEo = (UserEo)eoList.get(0);
            this.bindOrg(userDto, userEo);
            return userEo.getId();
        }
        AssertUtil.isFalse((boolean)CollectionUtils.isNotEmpty((Collection)eoList), (String)"\u7528\u6237\u540d\u5df2\u5b58\u5728");
        UserEo userEo = (UserEo)BeanUtil.copyProperties((Object)userDto, UserEo.class, (String[])new String[]{"id", "create_person", "create_time", "update_person", "update_time"});
        if (null != userDto.getPassword()) {
            if (StringUtils.isBlank((CharSequence)userEo.getSalt()) && this.emptySaltGenerate) {
                userEo.setSalt(UUID.randomUUID().toString());
            }
            String md5Password = this.passwordService.encryptPassword(userEo.getPassword(), userEo.getSalt(), serviceContext.getRequestTenantId(), serviceContext.getRequestTenantId());
            userEo.setPassword(md5Password);
        }
        this.userExtDas2.insert((BaseEo)userEo);
        this.bindOrg(userDto, userEo);
        this.addLoginConfig(userDto, userEo);
        return userEo.getId();
    }

    private void bindOrg(UserDto userDto, UserEo userEo) {
        String organizationId;
        if (CollectionUtils.isEmpty((Collection)userDto.getBelongOrgIds()) && StringUtils.isNotBlank((CharSequence)(organizationId = this.request.getHeader("yes.req.cus.b2b.organizationId")))) {
            ArrayList orgIds = Lists.newArrayList((Object[])new Long[]{Long.valueOf(organizationId)});
            userDto.setBelongOrgIds((List)orgIds);
        }
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)userDto.getBelongOrgIds()), (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        List userOrganizationEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.userOrganizationDas.filter().in((Object)"organization_id", (Collection)userDto.getBelongOrgIds())).eq((Object)"user_id", (Object)userEo.getId())).list();
        Set hasOrg = userOrganizationEos.stream().map(UserOrganizationEo::getOrganizationId).collect(Collectors.toSet());
        userDto.getBelongOrgIds().stream().filter(r -> !hasOrg.contains(r)).forEach(orgId -> {
            UserOrganizationEo eo = new UserOrganizationEo();
            eo.setUserId(userEo.getId());
            eo.setOrganizationId(orgId);
            eo.setTenantId(userEo.getTenantId());
            eo.setInstanceId(userEo.getInstanceId());
            this.userOrganizationDas.insert((BaseEo)eo);
        });
    }

    private void addLoginConfig(UserDto userDto, UserEo userEo) {
        ArrayList eoList = Lists.newArrayList();
        LoginConfigEo loginConfig = this.getLoginConfigEo(userEo);
        loginConfig.setLoginType(IdentityConstants.LoginType.name.getCode());
        loginConfig.setLoginKey(userDto.getUserName());
        eoList.add(loginConfig);
        if (null != userDto.getAccount()) {
            loginConfig = this.getLoginConfigEo(userEo);
            loginConfig.setLoginType(IdentityConstants.LoginType.account.getCode());
            loginConfig.setLoginKey(userDto.getAccount());
            eoList.add(loginConfig);
        }
        if (null != userDto.getRegisterType()) {
            switch (userDto.getRegisterType()) {
                case 1: 
                case 2: {
                    loginConfig = this.getLoginConfigEo(userEo);
                    loginConfig.setLoginType(IdentityConstants.LoginType.phone.getCode());
                    loginConfig.setLoginKey(userDto.getPhone());
                    eoList.add(loginConfig);
                    break;
                }
                case 3: {
                    loginConfig = this.getLoginConfigEo(userEo);
                    loginConfig.setLoginType(IdentityConstants.LoginType.email.getCode());
                    loginConfig.setLoginKey(userDto.getEmail());
                    eoList.add(loginConfig);
                    break;
                }
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)userDto.getPhone())) {
                loginConfig = this.getLoginConfigEo(userEo);
                loginConfig.setLoginType(IdentityConstants.LoginType.phone.getCode());
                loginConfig.setLoginKey(userDto.getPhone());
                eoList.add(loginConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)userDto.getEmail())) {
                loginConfig = this.getLoginConfigEo(userEo);
                loginConfig.setLoginType(IdentityConstants.LoginType.email.getCode());
                loginConfig.setLoginKey(userDto.getEmail());
                eoList.add(loginConfig);
            }
        }
        this.loginConfigDas.insertBatch((List)eoList);
    }

    private LoginConfigEo getLoginConfigEo(UserEo userEo) {
        LoginConfigEo loginConfig = new LoginConfigEo();
        loginConfig.setStatus(Integer.valueOf(1));
        loginConfig.setOwnerId(userEo.getId());
        loginConfig.setTenantId(userEo.getTenantId());
        loginConfig.setInstanceId(userEo.getInstanceId());
        loginConfig.setExtension("");
        loginConfig.setDomain(userEo.getDomain());
        return loginConfig;
    }

    @Override
    public void modUser(UserDto userDto) {
        log.info("\u65b0\u589e\u7528\u6237\u4fe1\u606faddUser\uff1a{}", (Object)JSON.toJSONString((Object)userDto));
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)userDto.getId()), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userExtDas2.selectByPrimaryKey(userDto.getId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)userEo), (String)"\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        UserEo updEo = (UserEo)BeanUtil.copyProperties((Object)userDto, UserEo.class, (String[])new String[0]);
        updEo.setId(userEo.getId());
        this.userExtDas2.updateSelective((BaseEo)updEo);
    }

    @Override
    public List<UserRespExtDto> queryUserByCodeOrPhone(UserDtoExtDto userDtoExtDto) {
        log.info("\u6839\u636e\u767b\u9646\u8d26\u53f7\u6216\u624b\u673a\u53f7\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userDtoExtDto));
        AssertUtil.isFalse((CollectionUtils.isEmpty((Collection)userDtoExtDto.getUserNameList()) && CollectionUtils.isEmpty((Collection)userDtoExtDto.getPhoneList()) ? 1 : 0) != 0, (String)"\u7528\u6237\u540d\u96c6\u5408\u6216\u624b\u673a\u53f7\u96c6\u5408\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        return this.userExtDas2.queryUserByCodeOrPhone(userDtoExtDto);
    }

    private UserOrganizationEo buildUserOrganizationEo(UserOrgRelationReqDto userOrgRelationReqDto, Long orgId) {
        UserOrganizationEo eo = new UserOrganizationEo();
        eo.setUserId(userOrgRelationReqDto.getUserId());
        eo.setOrganizationId(orgId);
        eo.setTenantId(userOrgRelationReqDto.getTenantId() != null ? userOrgRelationReqDto.getTenantId() : this.context.tenantId());
        eo.setInstanceId(userOrgRelationReqDto.getInstanceId() != null ? userOrgRelationReqDto.getInstanceId() : this.context.instanceId());
        eo.setExtension(StringUtils.isNotBlank((CharSequence)userOrgRelationReqDto.getExtension()) ? userOrgRelationReqDto.getExtension() : "");
        return eo;
    }
}

