/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessExtService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.impl.AbstractEmployeeExpandServiceImpl;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeExpandDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeRoleDas;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeExpandEo;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeRoleEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IAccessExtServiceImpl
extends AbstractEmployeeExpandServiceImpl
implements IAccessExtService {
    private static final Logger logger = LoggerFactory.getLogger(IAccessExtServiceImpl.class);
    @Resource
    private IAccessService accessService;
    @Resource
    private EmployeeExpandDas employeeExpandDas;
    @Resource
    private EmployeeRoleDas employeeRoleDas;
    @Resource
    private IRoleService roleService;

    @Override
    public UserAccessRespDto queryUserAccess(Long userId, String organizationId, Long instanceId) {
        UserAccessRespDto respDto = new UserAccessRespDto();
        respDto.setUserId(userId);
        respDto.setMenus(new ArrayList());
        if (StringUtils.isEmpty((CharSequence)organizationId)) {
            organizationId = super.headerOrgId();
        }
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            logger.error("\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID");
            return respDto;
        }
        EmployeeExpandEo employeeExpandEoParams = new EmployeeExpandEo();
        employeeExpandEoParams.setUserId(userId);
        employeeExpandEoParams.setOrganizationId(Long.valueOf(organizationId));
        List employeeExpandEoList = this.employeeExpandDas.select((BaseEo)employeeExpandEoParams);
        if (CollectionUtils.isEmpty((Collection)employeeExpandEoList)) {
            logger.error("\u627e\u4e0d\u5230\u8be5\u4eba\u5458\u4fe1\u606f\uff1a{}=={}", (Object)userId, (Object)organizationId);
            return respDto;
        }
        EmployeeRoleEo employeeRoleEoParams = new EmployeeRoleEo();
        employeeRoleEoParams.setUserId(userId);
        employeeRoleEoParams.setOrgId(Long.valueOf(organizationId));
        employeeRoleEoParams.setEmployeeId(((EmployeeExpandEo)employeeExpandEoList.get(0)).getId());
        List employeeRoleEoList = this.employeeRoleDas.select((BaseEo)employeeRoleEoParams);
        if (CollectionUtils.isEmpty((Collection)employeeRoleEoList)) {
            logger.error("\u8be5\u4eba\u5458\u65e0\u6743\u9650\uff1a{}", (Object)JSON.toJSONString((Object)employeeRoleEoParams));
            return respDto;
        }
        Set roleIds = employeeRoleEoList.stream().map(EmployeeRoleEo::getRoleId).collect(Collectors.toSet());
        List roleEos = this.roleService.queryByIds(roleIds);
        if (CollectionUtils.isEmpty((Collection)roleEos)) {
            logger.error("\u89d2\u8272\u6743\u9650\u5df2\u5220\u9664\uff1a{}", (Object)JSON.toJSONString(roleIds));
            return respDto;
        }
        HashSet roleSet = new HashSet(roleEos);
        HashMap<String, Integer> filter = new HashMap<String, Integer>();
        filter.put("withNoFirstNode", 1);
        respDto = this.accessService.queryUserAccessResources(respDto, roleSet, JSON.toJSONString(filter), instanceId);
        if (ObjectUtils.isEmpty((Object)respDto)) {
            respDto = new UserAccessRespDto();
            respDto.setUserId(userId);
            respDto.setMenus(new ArrayList());
        }
        if (CollectionUtils.isEmpty((Collection)respDto.getMenus())) {
            respDto.setMenus(new ArrayList());
        }
        return respDto;
    }
}

