/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.scheduleds.biz;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.EmployeeStatusEnum;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeExpandDas;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeExpandEo;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="employeeStatusScheduled")
@Scope(value="prototype")
public class EmployeeStatusScheduled
extends SingleTupleScheduleEvent {
    private final Logger logger = LoggerFactory.getLogger(EmployeeStatusScheduled.class);
    @Resource
    private EmployeeExpandDas employeeExpandDas;

    public void doUpdateStatus(String param) {
        Date nowDate = Calendar.getInstance().getTime();
        this.logger.info("\u5f00\u59cb\u6267\u884c\u4eba\u5458\u72b6\u6001\u66f4\u65b0\u903b\u8f91\uff08\u4eba\u5458\u5230\u671f\u8c03\u6574\u72b6\u6001\u4e3a\u7981\u7528\u4efb\u52a1\uff09\uff0c\u5165\u53c2:{}", (Object)param);
        if (StringUtils.isBlank((CharSequence)param)) {
            this.logger.info("\u5165\u53c2\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406\u5e76\u9000\u51fa\u65b9\u6cd5...");
            return;
        }
        EmployeeExtReqDto reqDto = (EmployeeExtReqDto)JSON.parseObject((String)param, EmployeeExtReqDto.class);
        if (Objects.isNull(reqDto.getEndTime())) {
            this.logger.info("\u4eba\u5458\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406\u5e76\u9000\u51fa\u65b9\u6cd5...");
            return;
        }
        if (Objects.isNull(reqDto.getId())) {
            this.logger.error("\u4eba\u5458ID\u4e3a\u7a7a\uff0c\u4e2d\u65ad\u903b\u8f91\u5e76\u9000\u51fa\u65b9\u6cd5...");
            return;
        }
        int compare = DateUtil.compare((Date)reqDto.getEndTime(), (Date)nowDate);
        if (compare >= 0) {
            EmployeeExpandEo eo = new EmployeeExpandEo();
            eo.setId(reqDto.getId());
            eo.setStatus(EmployeeStatusEnum.DISABLED.getKey());
            this.employeeExpandDas.updateSelective((BaseEo)eo);
        }
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            this.doUpdateStatus(taskMsg.getContent());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8c03\u5ea6\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    public void before(TaskMsg taskMsg) {
    }

    public void after(TaskMsg taskMsg) {
    }
}

