/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeExpandDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.UserExtMapper;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeExpandEo;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.Assert;

public abstract class AbstractEmployeeExpandServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEmployeeExpandServiceImpl.class);
    public static final int STAFFID_LENGTH = 10;
    @Resource
    private EmployeeExpandDas employeeExpandDas;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private UserExtMapper userExtMapper;
    @Resource
    private EmployeeOrgDas employeeOrganizationRelationDas;

    public void checkEmployeeNoUnique(Long instanceId, String employeeNo) {
        if (StringUtils.isNotBlank((CharSequence)employeeNo)) {
            Assert.notNull((Object)instanceId, (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
            EmployeeExpandEo select = new EmployeeExpandEo();
            select.setEmployeeNo(employeeNo);
            select.setInstanceId(instanceId);
            List employeeEoList = this.employeeExpandDas.select((BaseEo)select);
            if (CollectionUtils.isNotEmpty((Collection)employeeEoList)) {
                throw new BizException(UserExceptionCode.EMPLOYEE_NO_EXIST_FAIL.getCode(), UserExceptionCode.EMPLOYEE_NO_EXIST_FAIL.getMsg());
            }
        }
    }

    public String generateId(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        logger.info("\u751f\u6210\u4eba\u5458ID:{}", (Object)val);
        return val;
    }

    public String buildStaffId(String staffId) {
        logger.info("\u751f\u6210\u4eba\u5458ID\u5e76\u6821\u9a8c\u6570\u636e\u662f\u5426\u5168\u5c40\u552f\u4e00:{}", (Object)staffId);
        if (StringUtils.isBlank((CharSequence)staffId)) {
            return null;
        }
        logger.info("\u751f\u6210\u5168\u5c40\u552f\u4e00\u7684\u4eba\u5458ID\uff1a{}", (Object)staffId);
        EmployeeExpandEo eo = new EmployeeExpandEo();
        eo.setStaffId(staffId);
        List employeeExpandEos = this.employeeExpandDas.selectList((BaseEo)eo);
        if (CollectionUtils.isNotEmpty((Collection)employeeExpandEos)) {
            String generateStaffId = this.generateId(10);
            logger.info("\u4eba\u5458ID[{}]\u5df2\u5b58\u5728\uff0c\u751f\u6210\u4fe1\u606f\u65b0\u7684\u4eba\u5458ID\uff1a[{}].", (Object)staffId, (Object)generateStaffId);
            this.buildStaffId(generateStaffId);
        }
        logger.info("\u4eba\u5458ID[{}]\u67e5\u65e0\u6570\u636e\uff0c\u53ef\u4ee5\u4f7f\u7528...", (Object)staffId);
        return staffId;
    }

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isEmpty((CharSequence)organizationId)) {
            organizationId = MDC.get((String)"yes-req-cus-b2b-organizationId");
        }
        return organizationId;
    }

    public Long tenantId(Long instanceId) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        logger.info("tenantId >>> {}", (Object)tenantId);
        return tenantId;
    }

    public void checkBindUser(Long instanceId, EmployeeExtReqDto employeeDto) {
        if (Objects.isNull(employeeDto.getUserId())) {
            if (StringUtils.isEmpty((CharSequence)employeeDto.getUserName())) {
                throw new BizException("\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a");
            }
            LambdaQueryWrapper userQuery = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)userQuery.eq(BaseEo::getDr, (Object)0)).eq(StdUserEo::getUserName, (Object)employeeDto.getUserName());
            List userEos = this.userExtMapper.selectList((Wrapper)userQuery);
            if (CollectionUtils.isEmpty((Collection)userEos)) {
                throw new BizException("\u767b\u5f55\u8d26\u53f7[" + employeeDto.getUserName() + "]\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            employeeDto.setUserId(((UserEo)userEos.get(0)).getId());
        }
        EmployeeOrgEo employeeExpandEo = new EmployeeOrgEo();
        employeeExpandEo.setInstanceId(instanceId);
        employeeExpandEo.setOrganizationId(employeeDto.getOrganizationId());
        employeeExpandEo.setUserId(employeeDto.getUserId());
        if (Objects.isNull(employeeDto.getId())) {
            List expandEos = this.employeeOrganizationRelationDas.select((BaseEo)employeeExpandEo);
            if (CollectionUtils.isNotEmpty((Collection)expandEos)) {
                throw new BizException("\u767b\u5f55\u7528\u6237\u5df2\u88ab\u7ed1\u5b9a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7528\u6237");
            }
        } else {
            employeeExpandEo.setUserId(null);
            employeeExpandEo.setEmployeeId(employeeDto.getId());
            EmployeeOrgEo existEo = (EmployeeOrgEo)this.employeeOrganizationRelationDas.selectOne((BaseEo)employeeExpandEo);
            if (Objects.nonNull(existEo) && Objects.nonNull(existEo.getId()) && Objects.nonNull(existEo.getUserId()) && existEo.getUserId().longValue() != employeeDto.getUserId().longValue()) {
                employeeExpandEo.setUserId(employeeDto.getUserId());
                employeeExpandEo.setEmployeeId(null);
                List expandEos = this.employeeOrganizationRelationDas.select((BaseEo)employeeExpandEo);
                if (CollectionUtils.isNotEmpty((Collection)expandEos)) {
                    throw new BizException("\u767b\u5f55\u7528\u6237\u5df2\u88ab\u7ed1\u5b9a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7528\u6237");
                }
            }
        }
    }

    public InputStream getInputStream(String fileUrl) throws IOException {
        logger.info("\u6839\u636eurl\u83b7\u53d6\u6587\u4ef6\u6d41==>{}", (Object)JSON.toJSONString((Object)fileUrl));
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    public Map<String, OrganizationEo> getOrgByIdMap(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return new HashMap<String, OrganizationEo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", orgIdList);
        wrapper.eq((Object)"dr", (Object)0);
        List organizationEos = this.organizationMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)organizationEos)) {
            return new HashMap<String, OrganizationEo>();
        }
        Map<String, OrganizationEo> organizationEoMap = organizationEos.stream().collect(Collectors.toMap(StdOrganizationEo::getName, Function.identity(), (k1, k2) -> k1));
        return organizationEoMap;
    }
}

