/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.collector.executor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.collector.executor.TrackDataDistributeExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.event.AfterTrackDataEvent;
import com.dtyunxi.cube.component.track.client.collector.executor.event.BeforeTrackDataEvent;
import com.dtyunxi.cube.component.track.client.collector.executor.event.TrackDataEvent;
import com.dtyunxi.cube.component.track.client.collector.executor.receive.TrackDataReceiveExecutor;
import com.dtyunxi.cube.component.track.commons.constant.CollectExecutorMethodType;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.cube.component.track.commons.exception.TransactionAssert;
import com.dtyunxi.cube.component.track.commons.exception.TransactionExceptionCode;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionBaseVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeRecordVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import com.dtyunxi.cube.component.track.commons.vo.collect.TrackCollectResultVo;
import com.dtyunxi.cube.component.track.commons.vo.collect.TrackReceiveVo;
import com.dtyunxi.cube.component.track.commons.vo.collect.TransactionCollectBaseVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CommitTrackDataDistributeExecutor
implements TrackDataDistributeExecutor {
    private static Logger logger = LoggerFactory.getLogger(CommitTrackDataDistributeExecutor.class);
    @Autowired
    private ApplicationEventPublisher publisher;
    @Resource
    private List<TrackDataReceiveExecutor> trackDataReceiveExecutorList;
    @Value(value="${transaction.track.distribute.commit.assemble.model:node}")
    private String assembleModel;
    @Value(value="${transaction.track.distribute.commit.before.enable:true}")
    private boolean beforeCommitEnable;
    @Value(value="${transaction.track.distribute.commit.after.enable:false}")
    private boolean afterCommitEnable;

    @Override
    public <T extends TransactionCollectBaseVo> TrackCollectResultVo distributeData(T data) {
        TrackDataEvent trackDataEvent = (TrackDataEvent)((Object)ServerContextUtils.get((String)"transaction.track.commit.event"));
        if (trackDataEvent == null) {
            trackDataEvent = new TrackDataEvent();
            ServerContextUtils.set((String)"transaction.track.commit.event", (Object)((Object)trackDataEvent));
        }
        List transactionCollectBaseVoList = Optional.ofNullable(trackDataEvent.getCollectBaseVoConsumerList()).orElse(new LinkedList());
        if (trackDataEvent.getCollectBaseVoConsumerList() == null) {
            trackDataEvent.setCollectBaseVoConsumerList(transactionCollectBaseVoList);
        }
        transactionCollectBaseVoList.add(data);
        if (data.getCollectExecutorMethodType().equals((Object)CollectExecutorMethodType.TNR_MODIFY_API)) {
            try {
                TrackDataEvent receiveEvent = this.assemblyTrackDataEvent(trackDataEvent, data);
                TransactionAssert.notNull((Object)((Object)receiveEvent), (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u7ec4\u88c5\u6570\u636e\u5931\u8d25"});
                if (TransactionSynchronizationManager.isActualTransactionActive()) {
                    if (this.checkFailOrErrorData(data)) {
                        this.publisher.publishEvent((Object)this.buildAfterTrackDataEvent(receiveEvent));
                    } else {
                        this.publisher.publishEvent((Object)this.buildBeforeTrackDataEvent(receiveEvent));
                    }
                } else {
                    this.handleMethodEndTrackDataEvent(receiveEvent);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        TrackCollectResultVo trackCollectResultVo = new TrackCollectResultVo();
        trackCollectResultVo.setData(data);
        return trackCollectResultVo;
    }

    public void handleMethodEndTrackDataEvent(TrackDataEvent trackDataEvent) {
        try {
            logger.info("\u3010\u63a5\u6536\u5230\u65b9\u6cd5\u7ed3\u675f\u540e\u7684\u6536\u96c6\u4e8b\u4ef6\u3011beforeTrackDataEvent={}", (Object)JSON.toJSONString((Object)((Object)trackDataEvent)));
            TransactionAssert.notEmpty(this.trackDataReceiveExecutorList, (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u672a\u6ce8\u5165\u6570\u636e\u63a5\u6536\u6267\u884c\u5668"});
            TrackReceiveVo trackReceiveVo = this.buildTrackReceiveVo(trackDataEvent);
            this.trackDataReceiveExecutorList.forEach(trackDataReceiveExecutor -> trackDataReceiveExecutor.receiveData(trackReceiveVo));
        }
        catch (Exception var3) {
            logger.error(var3.getMessage(), (Throwable)var3);
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT, classes={BeforeTrackDataEvent.class})
    public void handleBeforeCommitTrackDataEvent(BeforeTrackDataEvent beforeTrackDataEvent) {
        try {
            logger.info("\u3010\u63a5\u6536\u5230\u63d0\u4ea4\u4e8b\u52a1\u524d\u6536\u96c6\u4e8b\u4ef6\u3011beforeTrackDataEvent={}", (Object)JSON.toJSONString((Object)((Object)beforeTrackDataEvent)));
            TransactionAssert.notEmpty(this.trackDataReceiveExecutorList, (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u672a\u6ce8\u5165\u6570\u636e\u63a5\u6536\u6267\u884c\u5668"});
            TrackReceiveVo trackReceiveVo = this.buildTrackReceiveVo(beforeTrackDataEvent);
            this.trackDataReceiveExecutorList.forEach(trackDataReceiveExecutor -> trackDataReceiveExecutor.receiveData(trackReceiveVo));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={AfterTrackDataEvent.class})
    public void handleAfterCompletionTrackDataEvent(AfterTrackDataEvent afterTrackDataEvent) {
        try {
            logger.info("\u3010\u63a5\u6536\u5230\u4e8b\u52a1\u7ed3\u675f\u540e\u6536\u96c6\u4e8b\u4ef6\u3011afterTrackDataEvent={}", (Object)JSON.toJSONString((Object)((Object)afterTrackDataEvent)));
            TransactionAssert.notEmpty(this.trackDataReceiveExecutorList, (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u672a\u6ce8\u5165\u6570\u636e\u63a5\u6536\u6267\u884c\u5668"});
            TrackReceiveVo trackReceiveVo = this.buildTrackReceiveVo(afterTrackDataEvent);
            this.trackDataReceiveExecutorList.forEach(trackDataReceiveExecutor -> trackDataReceiveExecutor.receiveData(trackReceiveVo));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private BeforeTrackDataEvent buildBeforeTrackDataEvent(TrackDataEvent trackDataEvent) {
        BeforeTrackDataEvent beforeTrackDataEvent = new BeforeTrackDataEvent();
        beforeTrackDataEvent.setNowData(trackDataEvent.getNowData());
        beforeTrackDataEvent.setCollectBaseVoConsumerList(trackDataEvent.getCollectBaseVoConsumerList());
        return beforeTrackDataEvent;
    }

    private AfterTrackDataEvent buildAfterTrackDataEvent(TrackDataEvent trackDataEvent) {
        AfterTrackDataEvent afterTrackDataEvent = new AfterTrackDataEvent();
        afterTrackDataEvent.setNowData(trackDataEvent.getNowData());
        afterTrackDataEvent.setCollectBaseVoConsumerList(trackDataEvent.getCollectBaseVoConsumerList());
        return afterTrackDataEvent;
    }

    private TrackDataEvent assemblyTrackDataEvent(TrackDataEvent trackDataEvent, TransactionCollectBaseVo nowData) {
        TrackDataEvent resultEvent = null;
        switch (nowData.getCollectExecutorMethodType()) {
            case TT_SAVE_API: 
            case TN_SAVE_API: 
            case TN_MODIFY_API: 
            case TNR_SAVE_API: 
            case ZIPKIN_POST_API: {
                logger.error("\u3010\u9519\u8bef\u89e6\u53d1\u7c7b\u578b\u3011nowData={}", (Object)JSON.toJSONString((Object)nowData));
                throw TransactionExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9519\u8bef\u89e6\u53d1\u7c7b\u578b"});
            }
            case TT_MODIFY_API: {
                if (!"transaction".equals(this.assembleModel)) break;
                resultEvent = this.assemblyTransactionModifyTrackDataEvent(trackDataEvent, nowData);
                break;
            }
            case TNR_MODIFY_API: {
                if (!"node".equals(this.assembleModel)) break;
                resultEvent = this.assemblyTransactionNodeRecordModifyTrackDataEvent(trackDataEvent, nowData);
                break;
            }
            default: {
                logger.error("\u3010\u9519\u8bef\u7c7b\u578b\u3011nowData={}", (Object)JSON.toJSONString((Object)nowData));
                throw TransactionExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9519\u8bef\u7c7b\u578b"});
            }
        }
        return resultEvent;
    }

    private TrackDataEvent assemblyTransactionModifyTrackDataEvent(TrackDataEvent trackDataEvent, TransactionCollectBaseVo nowData) {
        return trackDataEvent;
    }

    private TrackDataEvent assemblyTransactionNodeRecordModifyTrackDataEvent(TrackDataEvent trackDataEvent, TransactionCollectBaseVo nowData) {
        Map<Long, List<TransactionCollectBaseVo>> trackDataVoTypeMap = trackDataEvent.getCollectBaseVoConsumerList().stream().collect(Collectors.groupingBy(vo -> vo.getData().getId()));
        LinkedList<TransactionCollectBaseVo> resultLst = new LinkedList<TransactionCollectBaseVo>();
        List<TransactionCollectBaseVo> nodeRecordVoList = trackDataVoTypeMap.get(nowData.getData().getId());
        TransactionAssert.notEmpty(nodeRecordVoList, (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u4e8b\u4ef6\u7ec4\u88c5-\u8282\u70b9\u8c03\u7528vo\u4e3a\u7a7a"});
        resultLst.addAll(nodeRecordVoList);
        List<TransactionCollectBaseVo> nodeVoList = trackDataVoTypeMap.get(((TransactionNodeRecordVo)nodeRecordVoList.get(0).getData()).getNodeId());
        TransactionAssert.notEmpty(nodeVoList, (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u4e8b\u4ef6\u7ec4\u88c5-\u8282\u70b9vo\u4e3a\u7a7a"});
        resultLst.addAll(nodeVoList);
        List<TransactionCollectBaseVo> transactionVoList = trackDataVoTypeMap.get(((TransactionNodeVo)nodeVoList.get(0).getData()).getTransactionId());
        TransactionAssert.notEmpty(transactionVoList, (TransactionExceptionCode)TransactionExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u4e8b\u4ef6\u7ec4\u88c5-\u4e8b\u52a1vo\u4e3a\u7a7a"});
        resultLst.addAll(transactionVoList);
        TrackDataEvent resultTrackDataEvent = new TrackDataEvent();
        resultTrackDataEvent.setNowData(nowData);
        resultTrackDataEvent.setCollectBaseVoConsumerList(resultLst);
        trackDataEvent.getCollectBaseVoConsumerList().removeAll(nodeRecordVoList);
        trackDataEvent.getCollectBaseVoConsumerList().removeAll(nodeVoList);
        return resultTrackDataEvent;
    }

    private boolean checkFailOrErrorData(TransactionCollectBaseVo nowData) {
        if (CollectExecutorMethodType.TT_MODIFY_API.equals((Object)nowData.getCollectExecutorMethodType())) {
            return Objects.equals(((TransactionVo)nowData.getData()).getTransactionStatus(), TransactionStatusEnum.T_ERROR.getCode());
        }
        if (CollectExecutorMethodType.TNR_MODIFY_API.equals((Object)nowData.getCollectExecutorMethodType())) {
            return Objects.equals(((TransactionNodeRecordVo)nowData.getData()).getNodeStatus(), TransactionStatusEnum.T_ERROR.getCode());
        }
        return false;
    }

    private TrackReceiveVo buildTrackReceiveVo(TrackDataEvent trackDataEvent) {
        Map<Long, List<TransactionCollectBaseVo>> trackDataVoTypeMap = trackDataEvent.getCollectBaseVoConsumerList().stream().collect(Collectors.groupingBy(vo -> vo.getData().getId()));
        ArrayList voList = new ArrayList();
        HashMap transactionBaseVoMap = new HashMap();
        trackDataVoTypeMap.forEach((k, v) -> {
            TransactionVo transactionBaseVo = null;
            if (((TransactionCollectBaseVo)v.get(0)).getData() instanceof TransactionVo) {
                transactionBaseVo = new TransactionVo();
            } else if (((TransactionCollectBaseVo)v.get(0)).getData() instanceof TransactionNodeVo) {
                transactionBaseVo = new TransactionNodeVo();
            } else if (((TransactionCollectBaseVo)v.get(0)).getData() instanceof TransactionNodeRecordVo) {
                transactionBaseVo = new TransactionNodeRecordVo();
            } else {
                if (!(((TransactionCollectBaseVo)v.get(0)).getData() instanceof TransactionNodeRecordVo)) {
                    throw TransactionExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9519\u8bef\u6570\u636e\u7c7b\u578b"});
                }
                transactionBaseVo = new TransactionNodeRecordVo();
            }
            for (TransactionCollectBaseVo vo : v) {
                this.mergeTransactionBaseVo((TransactionBaseVo)transactionBaseVo, vo.getData());
            }
            voList.add(transactionBaseVo);
            transactionBaseVoMap.put(transactionBaseVo.getId(), transactionBaseVo);
        });
        TrackReceiveVo trackReceiveVo = new TrackReceiveVo();
        trackReceiveVo.setCollectExecutorMethodType(trackDataEvent.getNowData().getCollectExecutorMethodType());
        trackReceiveVo.setTrackLinkTransactionNodeRecordVoList(new ArrayList());
        trackReceiveVo.setTrackLinkTransactionNodeVoList(new ArrayList());
        voList.forEach(vo -> {
            if (vo instanceof TransactionVo) {
                if (Objects.equals(trackDataEvent.getNowData().getData().getId(), vo.getId())) {
                    trackReceiveVo.setCurrentTransactionVo((TransactionVo)vo);
                }
            } else if (vo instanceof TransactionNodeVo) {
                trackReceiveVo.getTrackLinkTransactionNodeVoList().add((TransactionNodeVo)vo);
            } else if (vo instanceof TransactionNodeRecordVo) {
                if (Objects.equals(trackDataEvent.getNowData().getData().getId(), vo.getId())) {
                    trackReceiveVo.setCurrentTransactionNodeRecordVo((TransactionNodeRecordVo)vo);
                    trackReceiveVo.setCurrentTransactionNodeVo((TransactionNodeVo)transactionBaseVoMap.get(trackReceiveVo.getCurrentTransactionNodeRecordVo().getNodeId()));
                    trackReceiveVo.setCurrentTransactionVo((TransactionVo)transactionBaseVoMap.get(trackReceiveVo.getCurrentTransactionNodeVo().getTransactionId()));
                }
                trackReceiveVo.getTrackLinkTransactionNodeRecordVoList().add((TransactionNodeRecordVo)vo);
            }
        });
        return trackReceiveVo;
    }

    private TransactionBaseVo mergeTransactionBaseVo(TransactionBaseVo newVo, TransactionBaseVo mergeVo) {
        if (newVo instanceof TransactionVo) {
            ((TransactionVo)newVo).setTransactionStatus(this.chooseVoStatus(((TransactionVo)newVo).getTransactionStatus(), ((TransactionVo)mergeVo).getTransactionStatus()));
            Integer nodeStatus = this.chooseVoStatus(((TransactionVo)newVo).getTransactionStatus(), ((TransactionVo)mergeVo).getTransactionStatus());
            CubeBeanUtils.copyProperties((Object)newVo, (Object)mergeVo, (String[])new String[0]);
            ((TransactionVo)newVo).setTransactionStatus(nodeStatus);
        } else if (newVo instanceof TransactionNodeVo) {
            Integer nodeStatus = this.chooseVoStatus(((TransactionNodeVo)newVo).getNodeStatus(), ((TransactionNodeVo)mergeVo).getNodeStatus());
            CubeBeanUtils.copyProperties((Object)newVo, (Object)mergeVo, (String[])new String[0]);
            ((TransactionNodeVo)newVo).setNodeStatus(nodeStatus);
        } else if (newVo instanceof TransactionNodeRecordVo) {
            Integer nodeStatus = this.chooseVoStatus(((TransactionNodeRecordVo)newVo).getNodeStatus(), ((TransactionNodeRecordVo)mergeVo).getNodeStatus());
            String nodeApiResponse = this.chooseVoNodeApiResponse(((TransactionNodeRecordVo)newVo).getNodeApiResponse(), ((TransactionNodeRecordVo)mergeVo).getNodeApiResponse());
            Map oldBizParams = ((TransactionNodeRecordVo)newVo).getBizParams();
            Map oldBizResult = ((TransactionNodeRecordVo)newVo).getBizResult();
            CubeBeanUtils.copyProperties((Object)newVo, (Object)mergeVo, (String[])new String[]{"bizErrorException"});
            ((TransactionNodeRecordVo)newVo).setNodeStatus(nodeStatus);
            ((TransactionNodeRecordVo)newVo).setNodeApiResponse(nodeApiResponse);
            Map newBizParams = ((TransactionNodeRecordVo)newVo).getBizParams();
            if (newBizParams == null) {
                ((TransactionNodeRecordVo)newVo).setBizParams(oldBizParams);
            } else if (oldBizParams != null) {
                newBizParams.putAll(oldBizParams);
            }
            Map newBizResult = ((TransactionNodeRecordVo)newVo).getBizResult();
            if (newBizResult == null) {
                ((TransactionNodeRecordVo)newVo).setBizResult(oldBizResult);
            } else if (oldBizResult != null) {
                newBizResult.putAll(oldBizResult);
            }
            Throwable errorException = ((TransactionNodeRecordVo)newVo).getBizErrorException();
            if (errorException == null) {
                ((TransactionNodeRecordVo)newVo).setBizErrorException(((TransactionNodeRecordVo)mergeVo).getBizErrorException());
            }
        }
        return newVo;
    }

    private Integer chooseVoStatus(Integer s1, Integer s2) {
        if (!Objects.equals(s1, TransactionStatusEnum.T_ERROR.getCode()) && !Objects.equals(s2, TransactionStatusEnum.T_ERROR.getCode())) {
            return s1 == null ? s2 : s1;
        }
        return TransactionStatusEnum.T_ERROR.getCode();
    }

    private String chooseVoNodeApiResponse(String n1, String n2) {
        return StringUtils.isNotBlank((CharSequence)n2) ? n2 : n1;
    }

    private Date chooseVoEndTime(Date d1, Date d2) {
        return d2 == null ? d1 : d2;
    }
}

