/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.collector.zipkin.module;

import com.dtyunxi.cube.component.track.client.collector.zipkin.module.Annotation;
import com.dtyunxi.cube.component.track.client.collector.zipkin.module.Endpoint;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A span is a single-host view of an operation. A trace is a series of spans (often RPC calls) which nest to form a latency tree. Spans are in the same trace when they share the same trace ID. The parent_id field establishes the position of one span in the tree.  The root span is where parent_id is Absent and usually has the longest duration in the trace. However, nested asynchronous work can materialize as child spans whose duration exceed the root span.  Spans usually represent remote activity such as RPC calls, or messaging producers and consumers. However, they can also represent in-process activity in any position of the trace. For example, a root span could represent a server receiving an initial client request. A root span could also represent a scheduled job that has no remote context. ")
@JsonPropertyOrder(value={"traceId", "name", "parentId", "id", "kind", "timestamp", "duration", "debug", "shared", "localEndpoint", "remoteEndpoint", "annotations", "tags"})
public class Span {
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PARENT_ID = "parentId";
    private String parentId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_KIND = "kind";
    private KindEnum kind;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Long duration;
    public static final String JSON_PROPERTY_DEBUG = "debug";
    private Boolean debug;
    public static final String JSON_PROPERTY_SHARED = "shared";
    private Boolean shared;
    public static final String JSON_PROPERTY_LOCAL_ENDPOINT = "localEndpoint";
    private Endpoint localEndpoint;
    public static final String JSON_PROPERTY_REMOTE_ENDPOINT = "remoteEndpoint";
    private Endpoint remoteEndpoint;
    public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
    private List<Annotation> annotations = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = null;

    public Span traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @ApiModelProperty(required=true, value="Randomly generated, unique identifier for a trace, set on all spans within it.  Encoded as 16 or 32 lowercase hex characters corresponding to 64 or 128 bits. For example, a 128bit trace ID looks like 4e441824ec2b6a44ffdc9bb9a6453df3 ")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Span name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The logical operation this span represents in lowercase (e.g. rpc method). Leave absent if unknown.  As these are lookup labels, take care to ensure names are low cardinality. For example, do not embed variables into the name. ")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Span parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The parent span ID or absent if this the root span in a trace.")
    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Span id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique 64bit identifier for this operation within the trace.  Encoded as 16 lowercase hex characters. For example ffdc9bb9a6453df3 ")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Span kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When present, kind clarifies timestamp, duration and remoteEndpoint. When absent, the span is local or incomplete. Unlike client and server, there is no direct critical path latency relationship between producer and consumer spans.  * `CLIENT`   * timestamp is the moment a request was sent to the server. (in v1 \"cs\")   * duration is the delay until a response or an error was received. (in v1 \"cr\"-\"cs\")   * remoteEndpoint is the server. (in v1 \"sa\") * `SERVER`   * timestamp is the moment a client request was received. (in v1 \"sr\")   * duration is the delay until a response was sent or an error. (in v1 \"ss\"-\"sr\")   * remoteEndpoint is the client. (in v1 \"ca\") * `PRODUCER`   * timestamp is the moment a message was sent to a destination. (in v1  \"ms\")   * duration is the delay sending the message, such as batching.   * remoteEndpoint is the broker. * `CONSUMER`   * timestamp is the moment a message was received from an origin. (in v1 \"mr\")   * duration is the delay consuming the message, such as from backlog.   * remoteEndpoint - Represents the broker. Leave serviceName absent if unknown. ")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public Span timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Epoch microseconds of the start of this span, possibly absent if incomplete.  For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC  This value should be set directly by instrumentation, using the most precise value possible. For example, gettimeofday or multiplying epoch millis by 1000.  There are three known edge-cases where this could be reported absent.  * A span was allocated but never started (ex not yet received a timestamp)  * The span's start event was lost  * Data about a completed span (ex tags) were sent after the fact ")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Span duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Duration in **microseconds** of the critical path, if known. Durations of less than one are rounded up. Duration of children can be longer than their parents due to asynchronous operations.  For example 150 milliseconds is 150000 microseconds. ")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Span debug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True is a request to store this span even if it overrides sampling policy.  This is true when the `X-B3-Flags` header has a value of 1. ")
    @JsonProperty(value="debug")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public Span shared(Boolean shared) {
        this.shared = shared;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if we are contributing to a span started by another tracer (ex on a different host).")
    @JsonProperty(value="shared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public Span localEndpoint(Endpoint localEndpoint) {
        this.localEndpoint = localEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="localEndpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Endpoint getLocalEndpoint() {
        return this.localEndpoint;
    }

    public void setLocalEndpoint(Endpoint localEndpoint) {
        this.localEndpoint = localEndpoint;
    }

    public Span remoteEndpoint(Endpoint remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="remoteEndpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Endpoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public void setRemoteEndpoint(Endpoint remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public Span annotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Span addAnnotationsItem(Annotation annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<Annotation>();
        }
        this.annotations.add(annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Associates events that explain latency with the time they happened.")
    @JsonProperty(value="annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public Span tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Span putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Adds context to a span, for search, viewing and analysis.  For example, a key \"your_app.version\" would let you lookup traces by version. A tag \"sql.query\" isn't searchable, but it can help in debugging when viewing a trace. ")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Span span = (Span)o;
        return Objects.equals(this.traceId, span.traceId) && Objects.equals(this.name, span.name) && Objects.equals(this.parentId, span.parentId) && Objects.equals(this.id, span.id) && Objects.equals((Object)this.kind, (Object)span.kind) && Objects.equals(this.timestamp, span.timestamp) && Objects.equals(this.duration, span.duration) && Objects.equals(this.debug, span.debug) && Objects.equals(this.shared, span.shared) && Objects.equals(this.localEndpoint, span.localEndpoint) && Objects.equals(this.remoteEndpoint, span.remoteEndpoint) && Objects.equals(this.annotations, span.annotations) && Objects.equals(this.tags, span.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.traceId, this.name, this.parentId, this.id, this.kind, this.timestamp, this.duration, this.debug, this.shared, this.localEndpoint, this.remoteEndpoint, this.annotations, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Span {\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    debug: ").append(this.toIndentedString(this.debug)).append("\n");
        sb.append("    shared: ").append(this.toIndentedString(this.shared)).append("\n");
        sb.append("    localEndpoint: ").append(this.toIndentedString(this.localEndpoint)).append("\n");
        sb.append("    remoteEndpoint: ").append(this.toIndentedString(this.remoteEndpoint)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KindEnum {
        CLIENT("CLIENT"),
        SERVER("SERVER"),
        PRODUCER("PRODUCER"),
        CONSUMER("CONSUMER");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

