/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.build;

import com.dtyunxi.cube.component.track.commons.aspect.annotation.TransactionNodeAction;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeApiTypeEnum;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeStatusEnum;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeTypeEnum;
import com.dtyunxi.cube.component.track.commons.utils.PointUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionNodeVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import feign.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignClient;

public class TransactionNodeVoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionNodeVoBuilder.class);
    private static final String NODE_CODE_SPLIT = "_";

    public TransactionNodeVo build(ProceedingJoinPoint point, TransactionVo overallTransaction, TransactionVo processTransaction, TransactionNodeTypeEnum transactionNodeTypeEnum, String env, String appName) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        MethodSignature ms = (MethodSignature)point.getSignature();
        TransactionNodeAction transactionAction = ms.getClass().getAnnotation(TransactionNodeAction.class);
        TransactionNodeAction methodTransactionAction = this.getMethodTransactionNodeAction(point, ms);
        TransactionNodeVo transactionNodeVo = new TransactionNodeVo();
        transactionNodeVo.setEnv(System.getProperty(env));
        transactionNodeVo.setTransactionId(Long.valueOf(processTransaction != null ? processTransaction.getId() : (overallTransaction != null ? overallTransaction.getId() : 0L)));
        transactionNodeVo.setOverTransactionId(overallTransaction != null ? overallTransaction.getId() : null);
        transactionNodeVo.setAccessTime(new Date());
        transactionNodeVo.setNodeStatus(Integer.valueOf(TransactionNodeStatusEnum.N_ACCEPT.code));
        transactionNodeVo.setNodeParentSort(Long.valueOf(processTransaction != null ? processTransaction.getTransactionSort() + 1L : (overallTransaction != null ? overallTransaction.getTransactionSort() + 1L : 1L)));
        transactionNodeVo.setNodeSort(Long.valueOf(processTransaction != null ? processTransaction.getTransactionSort() + 1L : (overallTransaction != null ? overallTransaction.getTransactionSort() + 1L : 1L)));
        transactionNodeVo.setNodeType(Integer.valueOf(transactionNodeTypeEnum.getCode()));
        if (transactionAction == null && methodTransactionAction == null) {
            this.repackageByAnnotation(transactionNodeVo, ms, appName, point);
        } else if (methodTransactionAction == null) {
            this.repackageByAnnotation(transactionNodeVo, transactionAction, ms, appName);
        } else {
            this.repackageByAnnotation(transactionNodeVo, methodTransactionAction, ms, appName);
        }
        transactionNodeVo.setNodeCode(transactionNodeVo.getNodeApiApplication() + NODE_CODE_SPLIT + transactionNodeVo.getNodeApiClass() + NODE_CODE_SPLIT + transactionNodeVo.getNodeApiMethod() + NODE_CODE_SPLIT + transactionNodeVo.getNodeApiVersion());
        return transactionNodeVo;
    }

    public void repackageByAnnotation(TransactionNodeVo transactionNodeVo, MethodSignature ms, String appName, ProceedingJoinPoint point) throws IllegalAccessException, NoSuchFieldException {
        transactionNodeVo.setNodeApiName(PointUtils.getPointClassSimpleName((MethodSignature)ms));
        transactionNodeVo.setNodeApiClass(PointUtils.getPointClassName((MethodSignature)ms));
        transactionNodeVo.setNodeApiMethod(PointUtils.getPointMethodName((MethodSignature)ms));
        transactionNodeVo.setNodeApiVersion("1.0.0");
        transactionNodeVo.setNodeApiType(Integer.valueOf(TransactionNodeApiTypeEnum.REST.getCode()));
        FeignClient feignClient = point.getSignature().getDeclaringType().getAnnotation(FeignClient.class);
        if (feignClient != null) {
            InvocationHandler targetObj = Proxy.getInvocationHandler(point.getTarget());
            Field field = targetObj.getClass().getDeclaredField("target");
            field.setAccessible(true);
            Object targetFieldObj = field.get(targetObj);
            if (targetFieldObj instanceof Target.HardCodedTarget) {
                transactionNodeVo.setNodeApiApplication(((Target.HardCodedTarget)targetFieldObj).name());
                transactionNodeVo.setServerAddress(((Target.HardCodedTarget)targetFieldObj).url());
            } else {
                transactionNodeVo.setNodeApiApplication(appName);
            }
        } else {
            transactionNodeVo.setNodeApiApplication(appName);
        }
    }

    public void repackageByAnnotation(TransactionNodeVo transactionNodeVo, TransactionNodeAction transactionAction, MethodSignature ms, String appName) {
        transactionNodeVo.setNodeApiName(this.compareAndGet(transactionAction.nodeApiName(), e -> PointUtils.getPointClassSimpleName((MethodSignature)ms)));
        transactionNodeVo.setNodeApiClass(this.compareAndGet(transactionAction.nodeApiClass(), e -> PointUtils.getPointClassName((MethodSignature)ms)));
        transactionNodeVo.setNodeApiMethod(this.compareAndGet(transactionAction.nodeApiMethod(), e -> PointUtils.getPointMethodName((MethodSignature)ms)));
        transactionNodeVo.setNodeApiVersion(this.compareAndGet(transactionAction.nodeApiVersion(), e -> "1.0.0"));
        transactionNodeVo.setNodeApiType(Integer.valueOf(transactionAction.nodeApiType() == null ? TransactionNodeApiTypeEnum.REST.getCode() : transactionAction.nodeApiType().code));
        transactionNodeVo.setNodeApiApplication(transactionAction.nodeApiApplication());
        if (StringUtils.isBlank((CharSequence)transactionNodeVo.getNodeApiApplication())) {
            FeignClient feignClient = ms.getClass().getAnnotation(FeignClient.class);
            if (feignClient != null) {
                transactionNodeVo.setNodeApiApplication(feignClient.name());
            } else {
                transactionNodeVo.setNodeApiApplication(appName);
            }
        }
    }

    public String compareAndGet(String a, Function<String, String> b) {
        return StringUtils.isNotBlank((CharSequence)a) ? a : b.apply(null);
    }

    public TransactionNodeAction getMethodTransactionNodeAction(ProceedingJoinPoint point, MethodSignature ms) {
        try {
            Method method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), ms.getParameterTypes());
            return method.getAnnotation(TransactionNodeAction.class);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

