/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.commons.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TransactionControlTypeEnum {
    T_OPEN(1, "\u5f00\u653e\u63a7\u5236\u4e0d\u7ea6\u675f"),
    T_CODE(2, "\u4e8b\u52a1\u7f16\u7801\u63a7\u5236"),
    T_GROUP(3, "\u4e8b\u52a1\u7ec4\u63a7\u5236");

    public final int code;
    public final String desc;
    public static final Map<Integer, TransactionControlTypeEnum> CODE_LOOKUP;
    public static final Map<Integer, String> CODE_DESC_MAP;

    private TransactionControlTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransactionControlTypeEnum forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(TransactionControlTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(TransactionControlTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

