/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.commons.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TransactionNodeApiTypeEnum {
    REST(1, "rest\u8c03\u7528"),
    MQ(2, "mq\u961f\u5217"),
    SCHEDULE(3, "\u5b9a\u65f6\u4efb\u52a1"),
    HTTP(4, "http/https\u8bf7\u6c42"),
    SQL(5, "sql\u6267\u884c"),
    REDIS(6, "redis\u8c03\u7528");

    public final int code;
    public final String desc;
    public static final Map<Integer, TransactionNodeApiTypeEnum> CODE_LOOKUP;
    public static final Map<Integer, String> CODE_DESC_MAP;

    private TransactionNodeApiTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransactionNodeApiTypeEnum forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(TransactionNodeApiTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(TransactionNodeApiTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

