/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.retry.scheduled;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.track.api.ITransactionRetryLogApi;
import com.dtyunxi.cube.center.track.api.dto.request.TransactionRetryLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionRetryLogRespDto;
import com.dtyunxi.cube.center.track.api.query.ITransactionRetryLogQueryApi;
import com.dtyunxi.cube.component.track.commons.constant.TransactionRetryLogStatusEnum;
import com.dtyunxi.cube.component.track.commons.utils.CommonUtils;
import com.dtyunxi.cube.component.track.retry.executor.TrackRetryExecutor;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

public class TrackRetrySignalScheduled {
    private static Logger logger = LoggerFactory.getLogger(TrackRetrySignalScheduled.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private TrackRetryExecutor trackRetryExecutor;
    @Resource
    private ITransactionRetryLogQueryApi transactionRetryLogQueryApiImpl;
    @Resource
    private ITransactionRetryLogApi transactionRetryLogApiImpl;
    @Value(value="${dtyunxi.env.module:my-app}")
    private String moduleName;

    @Scheduled(cron="${track.client.cron.retry:0/10 * * * * ?}")
    public void trackRetrySignal() {
        logger.debug("\u3010retrySignal\u3011\u4e8b\u52a1\u8282\u70b9\u91cd\u8bd5\u8bf7\u6c42\u4fe1\u53f7-\u5f00\u59cb\u6267\u884c");
        try {
            List<TransactionRetryLogRespDto> retryLogRespDtos = this.queryApplicationRetryLog(this.moduleName);
            Optional.ofNullable(retryLogRespDtos).ifPresent(dtos -> dtos.forEach(dto -> {
                if (this.retry((TransactionRetryLogRespDto)dto)) {
                    TransactionRetryLogReqDto retryLogReqDto = new TransactionRetryLogReqDto();
                    retryLogReqDto.setId(dto.getId());
                    retryLogReqDto.setRetryStatus(Integer.valueOf(TransactionRetryLogStatusEnum.RT_FINNISH.code));
                    retryLogReqDto.setRetryFinnishTime(new Date());
                    this.transactionRetryLogApiImpl.modifyTransactionRetryLog(retryLogReqDto);
                }
            }));
        }
        catch (Exception e) {
            logger.error("\u3010retrySignal\u3011\u4e8b\u52a1\u8282\u70b9\u91cd\u8bd5\u8bf7\u6c42\u4fe1\u53f7-\u6267\u884c\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        finally {
            logger.debug("\u3010retrySignal\u3011\u4e8b\u52a1\u8282\u70b9\u91cd\u8bd5\u8bf7\u6c42\u4fe1\u53f7-\u65b9\u6cd5\u7ed3\u675f");
        }
    }

    private String buildLocalKey() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress() + Thread.currentThread().getId();
    }

    private List<TransactionRetryLogRespDto> queryApplicationRetryLog(String applicationName) {
        return (List)CommonUtils.checkResponse((RestResponse)this.transactionRetryLogQueryApiImpl.queryByApplicationName(applicationName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retry(TransactionRetryLogRespDto retryLogRespDto) {
        boolean retryResult;
        block8: {
            if (retryLogRespDto == null || retryLogRespDto.getNodeRecordId() == null) {
                logger.debug("\u3010retry\u3011\u5173\u952e\u6570\u636e\u7f3a\u5931\uff0cretryLogRespDto={}", (Object)JSON.toJSONString((Object)retryLogRespDto));
                return false;
            }
            retryResult = false;
            try {
                String lockKey = "TRACK_RETRY_SIGNAL_LOCK" + retryLogRespDto.getNodeRecordId();
                String lockValue = this.buildLocalKey();
                Long lockFlag = this.cacheService.setnx(lockKey, lockValue);
                if (lockFlag == 1L) {
                    TransactionRetryLogReqDto retryLogReqDto = new TransactionRetryLogReqDto();
                    retryLogReqDto.setId(retryLogRespDto.getId());
                    retryLogReqDto.setRetryStatus(Integer.valueOf(TransactionRetryLogStatusEnum.RT_EXECUTING.code));
                    retryLogReqDto.setRetryExecuteTime(new Date());
                    this.transactionRetryLogApiImpl.modifyTransactionRetryLog(retryLogReqDto);
                    try {
                        this.trackRetryExecutor.executeRetry(retryLogRespDto.getNodeRecordId());
                        retryResult = true;
                        break block8;
                    }
                    finally {
                        String value = (String)this.cacheService.getCache(lockKey, String.class);
                        if (lockValue.equals(value)) {
                            this.cacheService.delCache(lockKey);
                        }
                    }
                }
                logger.debug("\u3010retry\u3011{}\u5176\u4ed6\u8282\u70b9\u5904\u7406\u4e2d\uff0c\u7b49\u5f85\u4e0b\u6b21\u89e6\u53d1\u4efb\u52a1", (Object)retryLogRespDto.getId());
            }
            catch (Exception e) {
                logger.error("\u3010retry\u3011" + retryLogRespDto.getId() + "\u6267\u884c\u91cd\u8bd5\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        return retryResult;
    }
}

