/*
 * @(#)InventoryException.java 1.0 2018-08-22
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 目录和商品eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "it_r_dir_item")
public class StdDirItemRelationEo extends CubeBaseEo {
    /**
     * skuId
     */
    @Column(name = "sku_id")
    private Long skuId;

    /**
     * 商品别名
     */
    @Column(name = "alias_name")
    private String aliasName;
    /**
     * 附加信息
     */
    @Column(name = "ext_info")
    private String extInfo;
    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 目录id
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 可允许下单时间范围
     */
    @Column(name = "allow_order_time")
    private String allowOrderTime;
    /**
     * 状态 1 上架 2 下架
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 类目类型
     */
    @Column(name = "dir_type")
    private String dirType;

    /**
     * 商品业务类型，与商品上架表bus_type保持一致
     */
    @Column(name = "bus_type")
    private Integer busType;

    public static StdDirItemRelationEo newInstance() {
        return (StdDirItemRelationEo) BaseEo.newInstance(StdDirItemRelationEo.class);
    }

    public static StdDirItemRelationEo newInstance(Map<String, Object> extFields) {
        return (StdDirItemRelationEo) BaseEo.newInstance(StdDirItemRelationEo.class, extFields);
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getAliasName() {
        return aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getAllowOrderTime() {
        return allowOrderTime;
    }

    public void setAllowOrderTime(String allowOrderTime) {
        this.allowOrderTime = allowOrderTime;
    }

    public String getDirType() {
        return dirType;
    }

    public void setDirType(String dirType) {
        this.dirType = dirType;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }
}
