package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * 上架信息
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_shelf")
public class StdShelfEo extends CubeBaseEo {
    /**
     *
     */
    @Column(name = "channel_id")
    private Long channelId;
    /**
     *
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     *
     */
    @Column(name = "version_id")
    private Long versionId;
    /**
     *
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     *
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 0 待上架 1已上架 2已下架
     */
    @Column(name = "status")
    private Integer status;
    /**
     *
     */
    @Column(name = "shelf_time")
    private Date shelfTime;
    /**
     * 所属人ID
     */
    @Column(name = "owner_id")
    private Long ownerId;

    /**
     * 价格
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 商户id
     */
    @Column(name = "seller_id")
    private Long sellerId;
    @Column(name = "type")
    private Integer type;
    @Column(name = "item_type")
    private Integer itemType;
    @Column(name = "bus_type")
    private Integer busType;
    @Column(name = "freight_template_id")
    private Long freightTemplateId;

    /**
     * 是否分销：1是0否
     */
    @Column(name = "distribution")
    private Integer distribution;

    /**
     * 组织Id
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 是否积分抵扣： 1 是 0 否
     */
    @Column(name = "points_deduction")
    private Integer pointsDeduction;

    /**
     * 库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存
     */
    @Column(name = "stock_display")
    private Integer stockDisplay;

    /**
     * 起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数
     */
    @Column(name = "limit_min")
    private Integer limitMin;

    /**
     * 起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)
     */
    @Column(name = "limit_min_mode")
    private Integer limitMinMode;

    /**
     * 订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)
     */
    @Column(name = "multiple_status")
    private Integer multipleStatus;

    /**
     * 商品sku是否已取消店铺授权：0否 1是
     */
    @Column(name = "shop_auth")
    private Integer shopAuth;
    /**
     * 首页推荐 0 H5商城 1 Web商城(多选用","分割)
     */
    @Column(name = "home_page_display")
    private String homePageDisplay;

    public Integer getShopAuth() {
        return shopAuth;
    }

    public void setShopAuth(Integer shopAuth) {
        this.shopAuth = shopAuth;
    }

    public Integer getStockDisplay() {
        return stockDisplay;
    }

    public void setStockDisplay(Integer stockDisplay) {
        this.stockDisplay = stockDisplay;
    }

    public Integer getLimitMin() {
        return limitMin;
    }

    public void setLimitMin(Integer limitMin) {
        this.limitMin = limitMin;
    }

    public Integer getLimitMinMode() {
        return limitMinMode;
    }

    public void setLimitMinMode(Integer limitMinMode) {
        this.limitMinMode = limitMinMode;
    }

    public Integer getMultipleStatus() {
        return multipleStatus;
    }

    public void setMultipleStatus(Integer multipleStatus) {
        this.multipleStatus = multipleStatus;
    }

    public Integer getPointsDeduction() {
        return pointsDeduction;
    }

    public void setPointsDeduction(Integer pointsDeduction) {
        this.pointsDeduction = pointsDeduction;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public static StdShelfEo newInstance() {
        return (StdShelfEo) BaseEo.newInstance(StdShelfEo.class);
    }

    public static StdShelfEo newInstance(Map<String, Object> extFields) {
        return (StdShelfEo) BaseEo.newInstance(StdShelfEo.class, extFields);
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public Date getShelfTime() {
        return this.shelfTime;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public String getHomePageDisplay() {
        return homePageDisplay;
    }

    public void setHomePageDisplay(String homePageDisplay) {
        this.homePageDisplay = homePageDisplay;
    }
}