package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;
import java.util.Map;

/**
 * 上架任务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_shelf_task")
public class StdShelfTaskEo extends CubeBaseEo {

    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 目录ID
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 任务ID
     */
    @Column(name = "task_id")
    private Long taskId;
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 规格ID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 商品快照ID
     */
    @Column(name = "snapshot_id")
    private Long snapshotId;
    /**
     * 上架时间
     */
    @Column(name = "shelf_time")
    private Date shelfTime;
    /**
     * 可允许下单时间范围
     */
    @Column(name = "allow_order_time")
    private String allowOrderTime;
    /**
     * on：上架 off：下架
     */
    @Column(name = "type")
    private String type;
    /**
     * 0未处理 1处理中 2处理成功 3处理失败 4取消
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 所属人ID
     */
    @Column(name = "owner_id")
    private Long ownerId;

    public static StdShelfTaskEo newInstance() {
        return (StdShelfTaskEo) BaseEo.newInstance(StdShelfTaskEo.class);
    }

    public static StdShelfTaskEo newInstance(Map<String, Object> extFields) {
        return (StdShelfTaskEo) BaseEo.newInstance(StdShelfTaskEo.class, extFields);
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public Long getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public Date getShelfTime() {
        return this.shelfTime;
    }

    public String getAllowOrderTime() {
        return allowOrderTime;
    }

    public void setAllowOrderTime(String allowOrderTime) {
        this.allowOrderTime = allowOrderTime;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }
}