/*
 * @(#)ItemSku.java 1.0 2018-08-22
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Map;

/**
 * 商品规格model
 *
 * @author 诺克
 * @since 2.0.0
 */
@Table(name = "it_item_sku")
public class StdItemSkuEo extends CubeBaseEo {

    @Column(name = "code")
    private String code;

    @Column(name = "item_id")
    private Long itemId;

    @Column(name = "name")
    private String name;

    @Column(name = "cspuid")
    private Long cspuid;

    @Column(name = "attr")
    private String attr;

    @Column(name = "status")
    private Integer status;

    @Column(name = "unit")
    private String unit;

    /**
     * 货品id
     */
    @Column(name = "outter_code")
    private String outterCode;

    /**
     * 货品编码
     */
    @Column(name = "cargo_code")
    private String cargoCode;

    @Column(name = "bar_code")
    private String barCode;

    @Column(name = "bundles")
    private String bundles;
    /**
     * 有效的起始时间（例12:00）,有效日期上架当天
     */
    @Column(name = "effective_start_time")
    private String effectiveStartTime;
    /**
     * 有效的结束时间（例13:00）,有效日期上架当天
     */
    @Column(name = "effective_end_time")
    private String effectiveEndTime;
    /**
     * 库存数量
     */
    @Column(name = "inventory_quantity")
    private Long inventoryQuantity;
    /**
     * 是否预售(1是 2否)
     */
    @Column(name = "advance_sale")
    private Integer advanceSale;
    /**
     * 停售日期
     */
    @Column(name = "discontinuation_date")
    private String discontinuationDate;

    @Column(name = "shelf_amount")
    private Long shelfAmount;

    /**
     * 安全库存数
     */
    @Column(name = "safety_stock")
    private Integer safetyStock;

    /**
     * 是否线下可售，0-否，1-是
     */
    @Column(name = "if_available_offline")
    private Integer ifAvailableOffline;

    /**
     * 毛重
     */
    @Column(name="gross_weight")
    private BigDecimal grossWeight;

    /**
     * 毛重单位
     */
    @Column(name="gross_weight_unit")
    private String grossWeightUnit;

    /**
     * 净重
     */
    @Column(name="net_weight")
    private BigDecimal netWeight;

    /**
     * 净重单位
     */
    @Column(name="net_weight_unit")
    private String netWeightUnit;
    /**
     * 体积
     */
    @Column(name="volume")
    private BigDecimal volume;
    /**
     * 体积单位 体积单位
     */
    @Column(name="volume_unit")
    private String volumeUnit;
    /**
     * "0:关闭加价限制;1:开启加价限制"
     */
    @Column(name = "add_price_status" )
    private Integer addPriceStatus;
    /**
     * 加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)
     */
    @Column(name = "add_price_mode")
    private Integer addPriceMode;

    /**
     * 限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)
     * @return
     */
    @Column(name = "add_price_min")
    private String addPriceMin;

    @Column(name = "add_price_max")
    private String addPriceMax;
    /**
     * 成本价
     */
    @Column(name = "cost_price")
    private BigDecimal costPrice;

    /**
     * 最小包装数
     */
    @Column(name = "min_package")
    private Integer minPackage;

    public Integer getMinPackage() {
        return minPackage;
    }

    public void setMinPackage(Integer minPackage) {
        this.minPackage = minPackage;
    }

    public Integer getAddPriceStatus() {
        return addPriceStatus;
    }

    public void setAddPriceStatus(Integer addPriceStatus) {
        this.addPriceStatus = addPriceStatus;
    }

    public Integer getAddPriceMode() {
        return addPriceMode;
    }

    public void setAddPriceMode(Integer addPriceMode) {
        this.addPriceMode = addPriceMode;
    }

    public String getAddPriceMin() {
        return addPriceMin;
    }

    public void setAddPriceMin(String addPriceMin) {
        this.addPriceMin = addPriceMin;
    }

    public String getAddPriceMax() {
        return addPriceMax;
    }

    public void setAddPriceMax(String addPriceMax) {
        this.addPriceMax = addPriceMax;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getVolumeUnit() {
        return volumeUnit;
    }

    public void setVolumeUnit(String volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public static StdItemSkuEo newInstance() {
        return (StdItemSkuEo) BaseEo.newInstance(StdItemSkuEo.class);
    }

    public static StdItemSkuEo newInstance(Map<String, Object> extFields) {
        return (StdItemSkuEo) BaseEo.newInstance(StdItemSkuEo.class, extFields);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCspuid() {
        return cspuid;
    }

    public void setCspuid(Long cspuid) {
        this.cspuid = cspuid;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getOutterCode() {
        return outterCode;
    }

    public void setOutterCode(String outterCode) {
        this.outterCode = outterCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getBundles() {
        return bundles;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public String getEffectiveStartTime() {
        return effectiveStartTime;
    }

    public void setEffectiveStartTime(String effectiveStartTime) {
        this.effectiveStartTime = effectiveStartTime;
    }

    public String getEffectiveEndTime() {
        return effectiveEndTime;
    }

    public void setEffectiveEndTime(String effectiveEndTime) {
        this.effectiveEndTime = effectiveEndTime;
    }

    public Long getInventoryQuantity() {
        return inventoryQuantity;
    }

    public void setInventoryQuantity(Long inventoryQuantity) {
        this.inventoryQuantity = inventoryQuantity;
    }

    public Integer getAdvanceSale() {
        return advanceSale;
    }

    public void setAdvanceSale(Integer advanceSale) {
        this.advanceSale = advanceSale;
    }

    public String getDiscontinuationDate() {
        return discontinuationDate;
    }

    public void setDiscontinuationDate(String discontinuationDate) {
        this.discontinuationDate = discontinuationDate;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Integer getSafetyStock() {
        return safetyStock;
    }

    public void setSafetyStock(Integer safetyStock) {
        this.safetyStock = safetyStock;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }
}
