package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

@Table(name = "it_dir_index")
public class StdDirIndexEo extends CubeBaseEo {
    /**
     * 分组ID
     */
    @Column(name = "group_id")
    private Long groupId;
    /**
     * id
     */
    @Column(name = "root_id")
    private Long rootId;
    /**
     * 目录名
     */
    @Column(name = "name")
    private String name;
    /**
     * 用途
     */
    @Column(name = "dir_usage")
    private String dirUsage;
    /**
     * 创建人ID
     */
    @Column(name = "owner_id")
    private Long ownerId;
    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;

    public static StdDirIndexEo newInstance() {
        return (StdDirIndexEo) BaseEo.newInstance(StdDirIndexEo.class);
    }

    public static StdDirIndexEo newInstance(Map<String, Object> extFields) {
        return (StdDirIndexEo) BaseEo.newInstance(StdDirIndexEo.class, extFields);
    }

    public Long getRootId() {
        return rootId;
    }

    public void setRootId(Long rootId) {
        this.rootId = rootId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDirUsage() {
        return dirUsage;
    }

    public void setDirUsage(String dirUsage) {
        this.dirUsage = dirUsage;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
