/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.context;

import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.SapTransmittableServiceContextProvider;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapContextExecutorWrapper
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(SapContextExecutorWrapper.class);
    private final Executor delegate;
    private final SapServiceContextProvider serviceContextProvider;

    public SapContextExecutorWrapper(Executor delegate, SapServiceContextProvider serviceContextProvider) {
        this.delegate = delegate;
        this.serviceContextProvider = serviceContextProvider;
    }

    @Override
    public void execute(Runnable command) {
        Map<String, Object> currentContext = this.serviceContextProvider.getAttachments();
        this.delegate.execute(() -> {
            if (currentContext != null && !currentContext.isEmpty()) {
                this.serviceContextProvider.setAttachments(currentContext);
                logger.debug("\u5728\u65b0\u7ebf\u7a0b\u4e2d\u6062\u590dSAP\u4e0a\u4e0b\u6587: {}", (Object)currentContext);
            }
            try {
                command.run();
            }
            finally {
                this.serviceContextProvider.clear();
                if (this.serviceContextProvider instanceof SapTransmittableServiceContextProvider) {
                    SapTransmittableServiceContextProvider.remove();
                }
            }
        });
    }

    public static SapContextExecutorWrapper wrap(Executor executor, SapServiceContextProvider serviceContextProvider) {
        if (executor instanceof SapContextExecutorWrapper) {
            return (SapContextExecutorWrapper)executor;
        }
        return new SapContextExecutorWrapper(executor, serviceContextProvider);
    }
}

