/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.elasticsearch;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.enums.EsOperator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@RefreshScope
public class SapEsInterceptor
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(SapEsInterceptor.class);
    private final SapConfigProperties sapConfigProperties;
    private final SapServiceContextProvider serviceContextProvider;
    private final SapGlobalConfigProvider globalConfigProvider;
    private final Map<String, SapConfigProperties.IndexMapping> indexMappingCache = new ConcurrentHashMap<String, SapConfigProperties.IndexMapping>();

    public SapEsInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider globalConfigProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
        this.globalConfigProvider = globalConfigProvider;
        this.refreshIndexMappingCache();
    }

    public Object interceptEsQuery(String indexName, Object originalQuery) {
        if (!this.isEsEnabled()) {
            logger.debug("SAP ES\u62e6\u622a\u5668\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7ES\u67e5\u8be2\u62e6\u622a\u5904\u7406");
            return originalQuery;
        }
        if (!this.isGloballyEnabled()) {
            logger.debug("SAP\u5168\u5c40\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7ES\u67e5\u8be2\u62e6\u622a\u5904\u7406");
            return originalQuery;
        }
        String sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag");
        if (StringUtils.isEmpty((Object)sapFlag)) {
            logger.debug("\u672a\u68c0\u6d4b\u5230sap-flag\uff0c\u8df3\u8fc7ES\u67e5\u8be2\u62e6\u622a\u5904\u7406");
            return originalQuery;
        }
        logger.debug("\u68c0\u6d4b\u5230sap-flag: {}\uff0c\u5f00\u59cb\u5904\u7406ES\u67e5\u8be2\u62e6\u622a", (Object)sapFlag);
        String[] parts = sapFlag.split("\\.");
        if (parts.length == 2) {
            String targetIndex = parts[0];
            String fieldName = parts[1];
            if (this.matchesTargetIndex(indexName, targetIndex)) {
                return this.processEsQueryIntercept(indexName, fieldName, originalQuery);
            }
            logger.debug("\u7d22\u5f15 {} \u4e0d\u5339\u914d\u76ee\u6807\u7d22\u5f15 {}\uff0c\u8df3\u8fc7\u5904\u7406", (Object)indexName, (Object)targetIndex);
        } else {
            logger.warn("sap-flag\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3aindex.field\u683c\u5f0f: {}", (Object)sapFlag);
        }
        return originalQuery;
    }

    public Object interceptSearchRequest(Object searchRequest) {
        logger.debug("\u62e6\u622aES SearchRequest: {}", searchRequest);
        return searchRequest;
    }

    private boolean isEsEnabled() {
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig == null) {
            logger.debug("ES\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = esConfig.isEnabled();
        logger.debug("SAP ES\u62e6\u622a\u5668\u5f00\u5173\u72b6\u6001: {}", (Object)enabled);
        return enabled;
    }

    private boolean isGloballyEnabled() {
        return this.globalConfigProvider.isGlobalEnabled();
    }

    private boolean matchesTargetIndex(String indexName, String targetIndex) {
        if (indexName == null || targetIndex == null) {
            return false;
        }
        if (targetIndex.contains("*")) {
            String regex = targetIndex.replace("*", ".*");
            return indexName.matches(regex);
        }
        return indexName.equals(targetIndex);
    }

    private Object processEsQueryIntercept(String indexName, String fieldName, Object originalQuery) {
        logger.debug("\u5904\u7406ES\u67e5\u8be2\u62e6\u622a: index={}, field={}", (Object)indexName, (Object)fieldName);
        SapConfigProperties.IndexMapping indexMapping = this.findIndexMappingByPattern(indexName);
        String conditionJson = this.buildEsCondition(indexName, fieldName, indexMapping);
        if (StringUtils.isEmpty((Object)conditionJson)) {
            logger.debug("ES\u6761\u4ef6\u4e3a\u7a7a\uff0c\u8fd4\u56de\u539f\u67e5\u8be2");
            return originalQuery;
        }
        Object enhancedQuery = this.mergeEsQuery(originalQuery, conditionJson, fieldName);
        logger.info("ES\u67e5\u8be2\u6539\u5199: index={}, field={}, condition={}", new Object[]{indexName, fieldName, conditionJson});
        return enhancedQuery;
    }

    private SapConfigProperties.IndexMapping findIndexMappingByPattern(String indexName) {
        SapConfigProperties.IndexMapping cached = this.indexMappingCache.get(indexName);
        if (cached != null) {
            return cached;
        }
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig == null) {
            return null;
        }
        List<SapConfigProperties.IndexMapping> indexMappings = esConfig.getIndexMapping();
        if (CollectionUtils.isEmpty(indexMappings)) {
            return null;
        }
        for (SapConfigProperties.IndexMapping mapping : indexMappings) {
            if (!mapping.matchesIndex(indexName) || !mapping.isEffective(this.sapConfigProperties.getGlobal(), this.globalConfigProvider)) continue;
            this.indexMappingCache.put(indexName, mapping);
            return mapping;
        }
        return null;
    }

    private String buildEsCondition(String indexName, String fieldName, SapConfigProperties.IndexMapping indexMapping) {
        String conditionValue;
        EsOperator operator;
        if (indexMapping != null) {
            if (!StringUtils.isEmpty((Object)indexMapping.getOperator())) {
                operator = EsOperator.fromName(indexMapping.getOperator());
                logger.debug("\u4f7f\u7528\u7d22\u5f15\u6620\u5c04\u64cd\u4f5c\u7b26\uff1a\u7d22\u5f15 {}, \u64cd\u4f5c\u7b26 {}", (Object)indexName, (Object)operator);
            } else {
                operator = this.getDefaultEsOperator();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u64cd\u4f5c\u7b26\uff1a\u7d22\u5f15 {}, \u64cd\u4f5c\u7b26 {}", (Object)indexName, (Object)operator);
            }
            if (!StringUtils.isEmpty((Object)indexMapping.getConditionValue())) {
                conditionValue = indexMapping.getConditionValue();
                logger.debug("\u4f7f\u7528\u7d22\u5f15\u6620\u5c04\u6761\u4ef6\u503c\uff1a\u7d22\u5f15 {}, \u6761\u4ef6\u503c {}", (Object)indexName, (Object)conditionValue);
            } else {
                conditionValue = this.getDefaultConditionValue();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u6761\u4ef6\u503c\uff1a\u7d22\u5f15 {}, \u6761\u4ef6\u503c {}", (Object)indexName, (Object)conditionValue);
            }
            if (!StringUtils.isEmpty((Object)indexMapping.getField())) {
                fieldName = indexMapping.getField();
                logger.debug("\u4f7f\u7528\u7d22\u5f15\u6620\u5c04\u5b57\u6bb5\u540d: {}", (Object)fieldName);
            }
        } else {
            operator = this.getDefaultEsOperator();
            conditionValue = this.getDefaultConditionValue();
            logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\uff1a\u7d22\u5f15 {}, \u64cd\u4f5c\u7b26 {}, \u6761\u4ef6\u503c {}", new Object[]{indexName, operator, conditionValue});
        }
        if (StringUtils.isEmpty((Object)conditionValue)) {
            logger.debug("\u6761\u4ef6\u503c\u4e3a\u7a7a\uff0c\u8df3\u8fc7ES\u6761\u4ef6\u6784\u5efa");
            return null;
        }
        String condition = this.buildEsConditionJson(operator, fieldName, conditionValue);
        logger.debug("\u6784\u5efa\u7684ES\u6761\u4ef6\uff1a{}", (Object)condition);
        return condition;
    }

    private String buildEsConditionJson(EsOperator operator, String fieldName, String conditionValue) {
        switch (operator) {
            case GTE: {
                return String.format("{\"range\":{\"%s\":{\"gte\":\"%s\"}}}", fieldName, conditionValue);
            }
            case LTE: {
                return String.format("{\"range\":{\"%s\":{\"lte\":\"%s\"}}}", fieldName, conditionValue);
            }
            case GT: {
                return String.format("{\"range\":{\"%s\":{\"gt\":\"%s\"}}}", fieldName, conditionValue);
            }
            case LT: {
                return String.format("{\"range\":{\"%s\":{\"lt\":\"%s\"}}}", fieldName, conditionValue);
            }
            case EQ: {
                return String.format("{\"term\":{\"%s\":\"%s\"}}", fieldName, conditionValue);
            }
            case NE: {
                return String.format("{\"bool\":{\"must_not\":{\"term\":{\"%s\":\"%s\"}}}}", fieldName, conditionValue);
            }
            case RANGE: {
                String[] parts = conditionValue.split(",");
                if (parts.length != 2) break;
                return String.format("{\"range\":{\"%s\":{\"gte\":\"%s\",\"lte\":\"%s\"}}}", fieldName, parts[0].trim(), parts[1].trim());
            }
            case EXISTS: {
                return String.format("{\"exists\":{\"field\":\"%s\"}}", fieldName);
            }
            case MATCH: {
                return String.format("{\"match\":{\"%s\":\"%s\"}}", fieldName, conditionValue);
            }
        }
        return null;
    }

    private Object mergeEsQuery(Object originalQuery, String conditionJson, String fieldName) {
        if (originalQuery == null) {
            logger.debug("\u539f\u67e5\u8be2\u4e3a\u7a7a\uff0c\u76f4\u63a5\u4f7f\u7528\u65b0\u6761\u4ef6");
            return conditionJson;
        }
        String mergedQuery = String.format("{\"bool\":{\"must\":[%s,%s]}}", originalQuery.toString(), conditionJson);
        logger.debug("\u5408\u5e76\u540e\u7684ES\u67e5\u8be2: {}", (Object)mergedQuery);
        return mergedQuery;
    }

    private EsOperator getDefaultEsOperator() {
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig != null && !StringUtils.isEmpty((Object)esConfig.getDefaultOperator())) {
            return EsOperator.fromName(esConfig.getDefaultOperator());
        }
        return EsOperator.GTE;
    }

    private String getDefaultConditionValue() {
        SapConfigProperties.ElasticsearchConfig esConfig = this.sapConfigProperties.getElasticsearch();
        if (esConfig != null && !StringUtils.isEmpty((Object)esConfig.getDefaultConditionValue())) {
            return esConfig.getDefaultConditionValue();
        }
        String sapLimitTime = this.sapConfigProperties.getLimitTime();
        if (!StringUtils.isEmpty((Object)sapLimitTime)) {
            return sapLimitTime;
        }
        return null;
    }

    public void refreshIndexMappingCache() {
        this.indexMappingCache.clear();
        logger.debug("\u7d22\u5f15\u6620\u5c04\u7f13\u5b58\u5df2\u6e05\u7a7a");
    }

    public static Object interceptQuery(String indexName, Object originalQuery, SapConfigProperties config, SapServiceContextProvider contextProvider, SapGlobalConfigProvider globalProvider) {
        SapEsInterceptor interceptor = new SapEsInterceptor(config, contextProvider, globalProvider);
        return interceptor.interceptEsQuery(indexName, originalQuery);
    }

    public int getOrder() {
        return 2147483547;
    }
}

