/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.elasticsearch;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.elasticsearch.SapEsInterceptor;
import com.dtyunxi.sap.interceptor.enums.EsOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SapEsQueryHelper
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SapEsQueryHelper.class);
    private static ApplicationContext applicationContext;
    private static SapEsInterceptor esInterceptor;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SapEsQueryHelper.applicationContext = applicationContext;
        SapEsQueryHelper.initializeEsInterceptor();
    }

    private static void initializeEsInterceptor() {
        try {
            SapConfigProperties configProperties = (SapConfigProperties)applicationContext.getBean(SapConfigProperties.class);
            SapServiceContextProvider contextProvider = (SapServiceContextProvider)applicationContext.getBean(SapServiceContextProvider.class);
            SapGlobalConfigProvider globalProvider = (SapGlobalConfigProvider)applicationContext.getBean(SapGlobalConfigProvider.class);
            esInterceptor = new SapEsInterceptor(configProperties, contextProvider, globalProvider);
            logger.info("SAP ES\u62e6\u622a\u5668\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.warn("SAP ES\u62e6\u622a\u5668\u521d\u59cb\u5316\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    public static Object interceptQuery(String indexName, Object originalQuery) {
        if (esInterceptor == null) {
            logger.debug("ES\u62e6\u622a\u5668\u672a\u521d\u59cb\u5316\uff0c\u8fd4\u56de\u539f\u67e5\u8be2");
            return originalQuery;
        }
        return esInterceptor.interceptEsQuery(indexName, originalQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object interceptQuery(String indexName, String fieldName, Object originalQuery) {
        String originalSapFlag = null;
        try {
            SapServiceContextProvider contextProvider;
            if (esInterceptor != null && (contextProvider = SapEsQueryHelper.getContextProvider()) != null) {
                originalSapFlag = (String)contextProvider.getAttachment("sap-flag");
                contextProvider.setAttachment("sap-flag", indexName + "." + fieldName);
            }
            Object object = SapEsQueryHelper.interceptQuery(indexName, originalQuery);
            return object;
        }
        finally {
            SapServiceContextProvider contextProvider;
            if (esInterceptor != null && (contextProvider = SapEsQueryHelper.getContextProvider()) != null) {
                if (originalSapFlag != null) {
                    contextProvider.setAttachment("sap-flag", originalSapFlag);
                } else {
                    contextProvider.removeAttachment("sap-flag");
                }
            }
        }
    }

    public static String buildEsConditionJson(String fieldName, String operator, String value) {
        if (StringUtils.isEmpty((Object)fieldName) || StringUtils.isEmpty((Object)value)) {
            return null;
        }
        try {
            EsOperator esOperator = EsOperator.fromName(operator);
            switch (esOperator) {
                case GTE: {
                    return String.format("{\"range\":{\"%s\":{\"gte\":\"%s\"}}}", fieldName, value);
                }
                case LTE: {
                    return String.format("{\"range\":{\"%s\":{\"lte\":\"%s\"}}}", fieldName, value);
                }
                case GT: {
                    return String.format("{\"range\":{\"%s\":{\"gt\":\"%s\"}}}", fieldName, value);
                }
                case LT: {
                    return String.format("{\"range\":{\"%s\":{\"lt\":\"%s\"}}}", fieldName, value);
                }
                case EQ: {
                    return String.format("{\"term\":{\"%s\":\"%s\"}}", fieldName, value);
                }
                case NE: {
                    return String.format("{\"bool\":{\"must_not\":{\"term\":{\"%s\":\"%s\"}}}}", fieldName, value);
                }
                case RANGE: {
                    String[] parts = value.split(",");
                    if (parts.length != 2) break;
                    return String.format("{\"range\":{\"%s\":{\"gte\":\"%s\",\"lte\":\"%s\"}}}", fieldName, parts[0].trim(), parts[1].trim());
                }
                case EXISTS: {
                    return String.format("{\"exists\":{\"field\":\"%s\"}}", fieldName);
                }
                case MATCH: {
                    return String.format("{\"match\":{\"%s\":\"%s\"}}", fieldName, value);
                }
            }
        }
        catch (Exception e) {
            logger.warn("\u6784\u5efaES\u6761\u4ef6\u5931\u8d25: operator={}, field={}, value={}, error={}", new Object[]{operator, fieldName, value, e.getMessage()});
        }
        return null;
    }

    public static String mergeEsQuery(String originalQuery, String additionalCondition) {
        if (StringUtils.isEmpty((Object)additionalCondition)) {
            return originalQuery;
        }
        if (StringUtils.isEmpty((Object)originalQuery)) {
            return additionalCondition;
        }
        return String.format("{\"bool\":{\"must\":[%s,%s]}}", originalQuery, additionalCondition);
    }

    public static boolean shouldIntercept(String indexName) {
        if (esInterceptor == null) {
            return false;
        }
        SapServiceContextProvider contextProvider = SapEsQueryHelper.getContextProvider();
        if (contextProvider == null) {
            return false;
        }
        String sapFlag = (String)contextProvider.getAttachment("sap-flag");
        if (StringUtils.isEmpty((Object)sapFlag)) {
            return false;
        }
        String[] parts = sapFlag.split("\\.");
        if (parts.length != 2) {
            return false;
        }
        String targetIndex = parts[0];
        return SapEsQueryHelper.matchesIndex(indexName, targetIndex);
    }

    private static boolean matchesIndex(String indexName, String targetIndex) {
        if (indexName == null || targetIndex == null) {
            return false;
        }
        if (targetIndex.contains("*")) {
            String regex = targetIndex.replace("*", ".*");
            return indexName.matches(regex);
        }
        return indexName.equals(targetIndex);
    }

    public static String getCurrentSapFlag() {
        SapServiceContextProvider contextProvider = SapEsQueryHelper.getContextProvider();
        if (contextProvider != null) {
            return (String)contextProvider.getAttachment("sap-flag");
        }
        return null;
    }

    public static void setSapFlag(String indexName, String fieldName) {
        SapServiceContextProvider contextProvider = SapEsQueryHelper.getContextProvider();
        if (contextProvider != null) {
            contextProvider.setAttachment("sap-flag", indexName + "." + fieldName);
        }
    }

    public static void clearSapFlag() {
        SapServiceContextProvider contextProvider = SapEsQueryHelper.getContextProvider();
        if (contextProvider != null) {
            contextProvider.removeAttachment("sap-flag");
        }
    }

    private static SapServiceContextProvider getContextProvider() {
        if (applicationContext == null) {
            return null;
        }
        try {
            return (SapServiceContextProvider)applicationContext.getBean(SapServiceContextProvider.class);
        }
        catch (Exception e) {
            logger.debug("\u83b7\u53d6SapServiceContextProvider\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static void refreshConfig() {
        if (esInterceptor != null) {
            esInterceptor.refreshIndexMappingCache();
            logger.info("ES\u62e6\u622a\u5668\u914d\u7f6e\u5df2\u5237\u65b0");
        }
    }

    public static class UsageExamples {
        public static void example1() {
            String indexName = "user_logs";
            String originalQuery = "{\"match_all\":{}}";
            Object enhancedQuery = SapEsQueryHelper.interceptQuery(indexName, originalQuery);
            logger.info("\u589e\u5f3a\u540e\u7684ES\u67e5\u8be2: {}", enhancedQuery);
        }

        public static void example2() {
            String indexName = "user_logs";
            String fieldName = "create_time";
            String originalQuery = "{\"term\":{\"status\":\"active\"}}";
            Object enhancedQuery = SapEsQueryHelper.interceptQuery(indexName, fieldName, originalQuery);
            logger.info("\u589e\u5f3a\u540e\u7684ES\u67e5\u8be2: {}", enhancedQuery);
        }

        public static void example3() {
            String fieldName = "create_time";
            String operator = "gte";
            String value = "2024-01-01";
            String condition = SapEsQueryHelper.buildEsConditionJson(fieldName, operator, value);
            String originalQuery = "{\"term\":{\"status\":\"active\"}}";
            String mergedQuery = SapEsQueryHelper.mergeEsQuery(originalQuery, condition);
            logger.info("\u5408\u5e76\u540e\u7684ES\u67e5\u8be2: {}", (Object)mergedQuery);
        }

        public static void example4() {
            String indexName = "user_logs";
            if (SapEsQueryHelper.shouldIntercept(indexName)) {
                logger.info("\u7d22\u5f15 {} \u9700\u8981\u8fdb\u884cSAP\u62e6\u622a", (Object)indexName);
            } else {
                logger.info("\u7d22\u5f15 {} \u4e0d\u9700\u8981\u8fdb\u884cSAP\u62e6\u622a", (Object)indexName);
            }
        }
    }
}

