/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.elasticsearch.SapEsInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@ConditionalOnClass(name={"org.aspectj.lang.annotation.Aspect"})
@ConditionalOnProperty(name={"sap.enabled"}, havingValue="true", matchIfMissing=true)
public class SapElasticsearchAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SapElasticsearchAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"sap.elasticsearch.enabled"}, havingValue="true", matchIfMissing=true)
    public SapEsInterceptor sapEsInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider sapGlobalConfigProvider) {
        logger.info("\u6b63\u5728\u521d\u59cb\u5316SAP Elasticsearch\u5207\u9762\u62e6\u622a\u5668...");
        SapEsInterceptor interceptor = new SapEsInterceptor(sapConfigProperties, serviceContextProvider, sapGlobalConfigProvider);
        logger.info("SAP Elasticsearch\u5207\u9762\u62e6\u622a\u5668\u521d\u59cb\u5316\u5b8c\u6210");
        logger.debug("ES\u62e6\u622a\u5668\u914d\u7f6e: {}", (Object)sapConfigProperties.getElasticsearch());
        return interceptor;
    }
}

