/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.util;

import org.springframework.util.StringUtils;

public class FieldNameConverter {
    public static String underscoreToCamelCase(String underscoreName) {
        if (StringUtils.isEmpty((Object)underscoreName)) {
            return underscoreName;
        }
        StringBuilder result = new StringBuilder();
        boolean nextUpper = false;
        for (int i = 0; i < underscoreName.length(); ++i) {
            char c = underscoreName.charAt(i);
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                result.append(Character.toUpperCase(c));
                nextUpper = false;
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String camelCaseToUnderscore(String camelCaseName) {
        if (StringUtils.isEmpty((Object)camelCaseName)) {
            return camelCaseName;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCaseName.length(); ++i) {
            char c = camelCaseName.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String convertFieldName(String fieldName, FieldFormat targetFormat) {
        if (StringUtils.isEmpty((Object)fieldName)) {
            return fieldName;
        }
        switch (targetFormat) {
            case CAMEL_CASE: {
                return FieldNameConverter.underscoreToCamelCase(fieldName);
            }
            case UNDERSCORE: {
                return FieldNameConverter.camelCaseToUnderscore(fieldName);
            }
            case AUTO: {
                return FieldNameConverter.autoDetectAndConvert(fieldName);
            }
        }
        return fieldName;
    }

    public static String autoDetectAndConvert(String fieldName) {
        if (StringUtils.isEmpty((Object)fieldName)) {
            return fieldName;
        }
        if (fieldName.contains("_")) {
            return FieldNameConverter.underscoreToCamelCase(fieldName);
        }
        if (fieldName.length() > 1 && FieldNameConverter.hasUpperCaseAfterFirst(fieldName)) {
            return FieldNameConverter.camelCaseToUnderscore(fieldName);
        }
        return fieldName;
    }

    private static boolean hasUpperCaseAfterFirst(String str) {
        for (int i = 1; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String[] convertFieldNames(String[] fieldNames, FieldFormat targetFormat) {
        if (fieldNames == null || fieldNames.length == 0) {
            return fieldNames;
        }
        String[] result = new String[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = FieldNameConverter.convertFieldName(fieldNames[i], targetFormat);
        }
        return result;
    }

    public static boolean isCamelCase(String fieldName) {
        if (StringUtils.isEmpty((Object)fieldName)) {
            return false;
        }
        return !fieldName.contains("_") && FieldNameConverter.hasUpperCaseAfterFirst(fieldName);
    }

    public static boolean isUnderscore(String fieldName) {
        if (StringUtils.isEmpty((Object)fieldName)) {
            return false;
        }
        return fieldName.contains("_");
    }

    public static FieldFormat detectFieldFormat(String fieldName) {
        if (FieldNameConverter.isUnderscore(fieldName)) {
            return FieldFormat.UNDERSCORE;
        }
        if (FieldNameConverter.isCamelCase(fieldName)) {
            return FieldFormat.CAMEL_CASE;
        }
        return FieldFormat.AUTO;
    }

    public static enum FieldFormat {
        CAMEL_CASE,
        UNDERSCORE,
        AUTO;

    }
}

