/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.mybatis;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.context.ServiceContextProvider;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
@RefreshScope
public class SapLimitInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(SapLimitInterceptor.class);
    private final SapConfigProperties sapConfigProperties;
    private final ServiceContextProvider serviceContextProvider;

    public SapLimitInterceptor(SapConfigProperties sapConfigProperties, ServiceContextProvider serviceContextProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        String sapFlag;
        if (!this.isGloballyEnabled()) {
            logger.debug("SAP\u5168\u5c40\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7SQL\u62e6\u622a\u5668\u5904\u7406");
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        String sqlType = mappedStatement.getSqlCommandType().toString();
        if (sqlType.equals(SqlCommandType.SELECT.toString()) && !StringUtils.isEmpty((Object)(sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag")))) {
            logger.debug("\u68c0\u6d4b\u5230sap-flag: {}", (Object)sapFlag);
            String[] parts = sapFlag.split("\\.");
            if (parts.length == 2) {
                String tableName = parts[0];
                String fieldName = parts[1];
                this.processSqlIntercept(statementHandler, tableName, fieldName);
            } else {
                logger.warn("sap-flag\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3atable.field\u683c\u5f0f: {}", (Object)sapFlag);
            }
        }
        return invocation.proceed();
    }

    private boolean isGloballyEnabled() {
        SapConfigProperties.GlobalConfig globalConfig = this.sapConfigProperties.getGlobal();
        if (globalConfig == null) {
            logger.debug("\u5168\u5c40\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = globalConfig.isEnabled();
        logger.debug("SAP\u5168\u5c40\u5f00\u5173\u72b6\u6001: {}", (Object)enabled);
        return enabled;
    }

    private void processSqlIntercept(StatementHandler statementHandler, String tableName, String fieldName) {
        BoundSql boundSql = statementHandler.getBoundSql();
        String originalSql = boundSql.getSql();
        logger.debug("SAP\u62e6\u622a\u5668\u68c0\u67e5SQL\u4e2d\u662f\u5426\u5305\u542b\u8868 {}: {}", (Object)tableName, (Object)originalSql);
        if (this.containsTable(originalSql, tableName)) {
            logger.debug("SQL\u4e2d\u5305\u542b\u8868 {}, \u51c6\u5907\u62fc\u63a5\u65f6\u95f4\u9650\u5236\u6761\u4ef6", (Object)tableName);
            String timeCondition = this.buildTimeCondition(fieldName);
            if (!StringUtils.isEmpty((Object)timeCondition)) {
                String modifiedSql = this.appendTimeCondition(originalSql, timeCondition);
                this.updateBoundSql(boundSql, modifiedSql);
                logger.debug("SAP\u62e6\u622a\u5668\uff1a\u8868 {} \u6539\u5199\u540e\u7684\u67e5\u8be2: {}", (Object)tableName, (Object)modifiedSql);
            }
        } else {
            logger.debug("SQL\u4e2d\u4e0d\u5305\u542b\u8868 {}, \u8df3\u8fc7\u5904\u7406", (Object)tableName);
        }
    }

    private boolean containsTable(String sql, String tableName) {
        String lowerSql = sql.toLowerCase();
        String lowerTableName = tableName.toLowerCase();
        String regex = "\\b" + Pattern.quote(lowerTableName) + "\\b";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(lowerSql);
        return matcher.find();
    }

    private String buildTimeCondition(String fieldName) {
        String sapLimitTime = this.sapConfigProperties.getLimitTime();
        if (StringUtils.isEmpty((Object)sapLimitTime)) {
            logger.debug("sap.limit-time\u672a\u914d\u7f6e\uff0c\u8df3\u8fc7\u65f6\u95f4\u9650\u5236");
            return null;
        }
        return fieldName + " >= " + sapLimitTime;
    }

    private String appendTimeCondition(String originalSql, String timeCondition) {
        String lowerSql = originalSql.toLowerCase().trim();
        if (lowerSql.endsWith(";")) {
            originalSql = originalSql.substring(0, originalSql.length() - 1).trim();
        }
        if (lowerSql.contains(" where ")) {
            return originalSql + " AND " + timeCondition;
        }
        return originalSql + " WHERE " + timeCondition;
    }

    private void updateBoundSql(BoundSql boundSql, String newSql) {
        try {
            Field field = boundSql.getClass().getDeclaredField("sql");
            field.setAccessible(true);
            field.set(boundSql, newSql);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0BoundSql\u5931\u8d25", (Throwable)e);
        }
    }

    public Object plugin(Object target) {
        return target instanceof StatementHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties properties) {
    }
}

