/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.context.SapDefaultServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.SapTransmittableServiceContextProvider;
import com.dtyunxi.sap.interceptor.feign.IPcpDictExtQueryApi;
import com.dtyunxi.sap.interceptor.feign.SapFeignInterceptor;
import com.dtyunxi.sap.interceptor.mybatis.SapLimitInterceptor;
import com.dtyunxi.sap.interceptor.web.SapHeaderInterceptor;
import com.dtyunxi.sap.interceptor.web.SapPathInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={SapConfigProperties.class})
@ConditionalOnProperty(prefix="ocs.sap", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SapInterceptorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SapInterceptorAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.servlet.HandlerInterceptor"})
    public SapHeaderInterceptor sapHeaderInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider) {
        log.info("sapHeaderInterceptor");
        return new SapHeaderInterceptor(sapConfigProperties, serviceContextProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.servlet.HandlerInterceptor"})
    public SapPathInterceptor sapPathInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider) {
        log.info("sapPathInterceptor");
        return new SapPathInterceptor(sapConfigProperties, serviceContextProvider);
    }

    @Configuration
    public static class SapFeignClientConfiguration {
        private final String serviceName;
        private final String serviceUrl;

        public SapFeignClientConfiguration(@Value(value="${yundt.cube.center.data.api.name:yundt-cube-center-data}") String serviceName, @Value(value="${yundt.cube.center.data.api:}") String serviceUrl) {
            this.serviceName = serviceName;
            this.serviceUrl = serviceUrl;
        }

        @Bean
        public FeignClientBuilder feignClientBuilder(ApplicationContext applicationContext) {
            log.info("sapFeignClientBuilder");
            return new FeignClientBuilder(applicationContext);
        }

        @Bean
        public IPcpDictExtQueryApi pcpDictExtQueryApi(FeignClientBuilder feignClientBuilder) {
            FeignClientBuilder.Builder builder = feignClientBuilder.forType(IPcpDictExtQueryApi.class, this.serviceName);
            if (StringUtils.isNotBlank((CharSequence)this.serviceUrl)) {
                builder.url(this.serviceUrl);
            }
            return (IPcpDictExtQueryApi)builder.build();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"feign.RequestInterceptor"})
    @ConditionalOnProperty(prefix="ocs.sap.feign", name={"enabled"}, havingValue="true")
    public static class SapFeignInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SapFeignInterceptor sapFeignInterceptor(SapServiceContextProvider serviceContextProvider) {
            log.info("sapFeignInterceptor");
            return new SapFeignInterceptor(serviceContextProvider);
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionFactory.class})
    @ConditionalOnProperty(prefix="ocs.sap.mybatis", name={"enabled"}, havingValue="true")
    @AutoConfigureAfter(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
    public static class SapMybatisInterceptorConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SapLimitInterceptor sapLimitInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider) {
            log.info("sapLimitInterceptor");
            return new SapLimitInterceptor(sapConfigProperties, serviceContextProvider);
        }

        @Bean
        public SqlSessionFactoryBeanPostProcessor sapLimitInterceptorRegistration(SapLimitInterceptor sapLimitInterceptor) {
            log.info("sapLimitInterceptorRegistration");
            return new SqlSessionFactoryBeanPostProcessor(sapLimitInterceptor);
        }

        private static class SqlSessionFactoryBeanPostProcessor
        implements BeanPostProcessor {
            private final SapLimitInterceptor sapLimitInterceptor;

            public SqlSessionFactoryBeanPostProcessor(SapLimitInterceptor sapLimitInterceptor) {
                this.sapLimitInterceptor = sapLimitInterceptor;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) {
                if (bean instanceof SqlSessionFactory) {
                    SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)bean;
                    sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)this.sapLimitInterceptor);
                }
                return bean;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.web.servlet.HandlerInterceptor"})
    public static class SapWebInterceptorConfiguration
    implements WebMvcConfigurer {
        private final SapHeaderInterceptor sapHeaderInterceptor;
        private final SapPathInterceptor sapPathInterceptor;

        public SapWebInterceptorConfiguration(SapHeaderInterceptor sapHeaderInterceptor, SapPathInterceptor sapPathInterceptor) {
            this.sapHeaderInterceptor = sapHeaderInterceptor;
            this.sapPathInterceptor = sapPathInterceptor;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.sapHeaderInterceptor).addPathPatterns(new String[]{"/**"});
            registry.addInterceptor((HandlerInterceptor)this.sapPathInterceptor).addPathPatterns(new String[]{"/**"});
        }
    }

    @Configuration
    public static class SapServiceContextConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ocs.sap.context", name={"transmittable"}, havingValue="true")
        public SapServiceContextProvider sapTransmittableServiceContextProvider() {
            return new SapTransmittableServiceContextProvider();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ocs.sap.context", name={"transmittable"}, havingValue="false", matchIfMissing=true)
        public SapServiceContextProvider sapDefaultServiceContextProvider() {
            return new SapDefaultServiceContextProvider();
        }
    }
}

