/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.mybatis;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapGlobalConfigProvider;
import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import com.dtyunxi.sap.interceptor.enums.SqlOperator;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
@RefreshScope
public class SapLimitInterceptor
implements Interceptor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(SapLimitInterceptor.class);
    private final SapConfigProperties sapConfigProperties;
    private final SapServiceContextProvider serviceContextProvider;
    private final SapGlobalConfigProvider globalConfigProvider;

    public SapLimitInterceptor(SapConfigProperties sapConfigProperties, SapServiceContextProvider serviceContextProvider, SapGlobalConfigProvider globalConfigProvider) {
        this.sapConfigProperties = sapConfigProperties;
        this.serviceContextProvider = serviceContextProvider;
        this.globalConfigProvider = globalConfigProvider;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        String sapFlag;
        if (!this.isMybatisEnabled()) {
            logger.debug("SAP MyBatis\u62e6\u622a\u5668\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7SQL\u62e6\u622a\u5668\u5904\u7406");
            return invocation.proceed();
        }
        if (!this.isGloballyEnabled()) {
            logger.debug("SAP\u5168\u5c40\u5f00\u5173\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7SQL\u62e6\u622a\u5668\u5904\u7406");
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        String sqlType = mappedStatement.getSqlCommandType().toString();
        if (sqlType.equals(SqlCommandType.SELECT.toString()) && !StringUtils.isEmpty((Object)(sapFlag = (String)this.serviceContextProvider.getAttachment("sap-flag")))) {
            logger.debug("\u68c0\u6d4b\u5230sap-flag: {}", (Object)sapFlag);
            String[] parts = sapFlag.split("\\.");
            if (parts.length == 2) {
                String tableName = parts[0];
                String fieldName = parts[1];
                this.processSqlIntercept(statementHandler, tableName, fieldName);
            } else {
                logger.warn("sap-flag\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3atable.field\u683c\u5f0f: {}", (Object)sapFlag);
            }
        }
        return invocation.proceed();
    }

    private boolean isMybatisEnabled() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig == null) {
            logger.debug("MyBatis\u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u542f\u7528");
            return true;
        }
        boolean enabled = mybatisConfig.isEnabled();
        logger.debug("SAP MyBatis\u62e6\u622a\u5668\u5f00\u5173\u72b6\u6001: {}", (Object)enabled);
        return enabled;
    }

    private boolean isGloballyEnabled() {
        return this.globalConfigProvider.isGlobalEnabled();
    }

    private void processSqlIntercept(StatementHandler statementHandler, String tableName, String fieldName) {
        BoundSql boundSql = statementHandler.getBoundSql();
        String originalSql = boundSql.getSql();
        logger.debug("SAP\u62e6\u622a\u5668\u68c0\u67e5SQL\u4e2d\u662f\u5426\u5305\u542b\u8868 {}: {}", (Object)tableName, (Object)originalSql);
        if (this.containsTable(originalSql, tableName)) {
            logger.debug("SQL\u4e2d\u5305\u542b\u8868 {}, \u51c6\u5907\u62fc\u63a5\u9650\u5236\u6761\u4ef6", (Object)tableName);
            String condition = this.buildCondition(tableName, fieldName);
            if (!StringUtils.isEmpty((Object)condition)) {
                String modifiedSql = this.appendCondition(originalSql, condition);
                this.updateBoundSql(boundSql, modifiedSql);
                logger.info("SQL\u6539\u5199: table={}, sql={}", (Object)tableName, (Object)modifiedSql);
            }
        } else {
            logger.debug("SQL\u4e2d\u4e0d\u5305\u542b\u8868 {}, \u8df3\u8fc7\u5904\u7406", (Object)tableName);
        }
    }

    private boolean containsTable(String sql, String tableName) {
        String lowerSql = sql.toLowerCase();
        String lowerTableName = tableName.toLowerCase();
        String regex = "\\b" + Pattern.quote(lowerTableName) + "\\b";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(lowerSql);
        return matcher.find();
    }

    private String buildCondition(String tableName, String fieldName) {
        String conditionValue;
        SqlOperator operator;
        SapConfigProperties.PathMapping pathMapping = this.findPathMappingByTable(tableName);
        if (pathMapping != null) {
            if (!StringUtils.isEmpty((Object)pathMapping.getOperator())) {
                operator = SqlOperator.fromName(pathMapping.getOperator());
                logger.debug("\u4f7f\u7528\u8def\u5f84\u6620\u5c04\u64cd\u4f5c\u7b26\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}", (Object)tableName, (Object)operator);
            } else {
                operator = this.getDefaultOperator();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u64cd\u4f5c\u7b26\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}", (Object)tableName, (Object)operator);
            }
            if (!StringUtils.isEmpty((Object)pathMapping.getConditionValue())) {
                conditionValue = pathMapping.getConditionValue();
                logger.debug("\u4f7f\u7528\u8def\u5f84\u6620\u5c04\u6761\u4ef6\u503c\uff1a\u8868 {}, \u6761\u4ef6\u503c {}", (Object)tableName, (Object)conditionValue);
            } else {
                conditionValue = this.getDefaultConditionValue();
                logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u6761\u4ef6\u503c\uff1a\u8868 {}, \u6761\u4ef6\u503c {}", (Object)tableName, (Object)conditionValue);
            }
            logger.debug("\u4f7f\u7528\u8def\u5f84\u6620\u5c04\u914d\u7f6e\uff1a\u8868 {}, \u6700\u7ec8\u64cd\u4f5c\u7b26 {}, \u6700\u7ec8\u6761\u4ef6\u503c {}", new Object[]{tableName, operator, conditionValue});
        } else {
            operator = this.getDefaultOperator();
            conditionValue = this.getDefaultConditionValue();
            logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\uff1a\u8868 {}, \u64cd\u4f5c\u7b26 {}, \u6761\u4ef6\u503c {}", new Object[]{tableName, operator, conditionValue});
        }
        if (StringUtils.isEmpty((Object)conditionValue)) {
            logger.debug("\u6761\u4ef6\u503c\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6761\u4ef6\u6784\u5efa");
            return null;
        }
        String condition = operator.buildCondition(fieldName, conditionValue);
        logger.debug("\u6784\u5efa\u7684SQL\u6761\u4ef6\uff1a{}", (Object)condition);
        return condition;
    }

    private SapConfigProperties.PathMapping findPathMappingByTable(String tableName) {
        List<SapConfigProperties.PathMapping> pathMappings = this.sapConfigProperties.getPathMapping();
        if (pathMappings == null || pathMappings.isEmpty()) {
            return null;
        }
        for (SapConfigProperties.PathMapping mapping : pathMappings) {
            if (!tableName.equals(mapping.getTable()) || !mapping.isEffective(this.sapConfigProperties.getGlobal())) continue;
            return mapping;
        }
        return null;
    }

    private SqlOperator getDefaultOperator() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig != null && !StringUtils.isEmpty((Object)mybatisConfig.getDefaultOperator())) {
            return SqlOperator.fromName(mybatisConfig.getDefaultOperator());
        }
        return SqlOperator.GTE;
    }

    private String getDefaultConditionValue() {
        SapConfigProperties.MybatisConfig mybatisConfig = this.sapConfigProperties.getMybatis();
        if (mybatisConfig != null && !StringUtils.isEmpty((Object)mybatisConfig.getDefaultConditionValue())) {
            return mybatisConfig.getDefaultConditionValue();
        }
        String sapLimitTime = this.sapConfigProperties.getLimitTime();
        if (!StringUtils.isEmpty((Object)sapLimitTime)) {
            return sapLimitTime;
        }
        return null;
    }

    private String appendCondition(String originalSql, String condition) {
        String lowerSql;
        if (StringUtils.isEmpty((Object)condition)) {
            return originalSql;
        }
        String sql = originalSql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        if ((lowerSql = sql.toLowerCase()).contains(" where ")) {
            return this.insertConditionAfterWhere(sql, condition);
        }
        return this.insertWhereClause(sql, condition);
    }

    private String insertConditionAfterWhere(String sql, String condition) {
        String lowerSql = sql.toLowerCase();
        int whereIndex = lowerSql.indexOf(" where ");
        if (whereIndex == -1) {
            return sql + " AND " + condition;
        }
        int nextClauseIndex = this.findNextClauseIndex(lowerSql, whereIndex + 7);
        if (nextClauseIndex == -1) {
            return sql + " AND " + condition;
        }
        String beforeNextClause = sql.substring(0, nextClauseIndex).trim();
        String afterNextClause = sql.substring(nextClauseIndex);
        if (beforeNextClause.endsWith("WHERE") || beforeNextClause.endsWith("where")) {
            return beforeNextClause + " " + condition + " " + afterNextClause;
        }
        return beforeNextClause + " AND " + condition + " " + afterNextClause;
    }

    private String insertWhereClause(String sql, String condition) {
        String lowerSql = sql.toLowerCase();
        int firstClauseIndex = this.findFirstClauseIndex(lowerSql);
        if (firstClauseIndex == -1) {
            return sql + " WHERE " + condition;
        }
        String beforeClause = sql.substring(0, firstClauseIndex).trim();
        String afterClause = sql.substring(firstClauseIndex);
        return beforeClause + " WHERE " + condition + " " + afterClause;
    }

    private int findNextClauseIndex(String lowerSql, int startIndex) {
        String[] clauses = new String[]{" group by ", " having ", " order by ", " limit ", " union ", " for update "};
        int minIndex = Integer.MAX_VALUE;
        for (String clause : clauses) {
            int index = lowerSql.indexOf(clause, startIndex);
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        return minIndex == Integer.MAX_VALUE ? -1 : minIndex;
    }

    private int findFirstClauseIndex(String lowerSql) {
        String[] clauses = new String[]{" where ", " group by ", " having ", " order by ", " limit ", " union ", " for update "};
        int minIndex = Integer.MAX_VALUE;
        for (String clause : clauses) {
            int index = lowerSql.indexOf(clause);
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        return minIndex == Integer.MAX_VALUE ? -1 : minIndex;
    }

    private void updateBoundSql(BoundSql boundSql, String newSql) {
        try {
            Field field = boundSql.getClass().getDeclaredField("sql");
            field.setAccessible(true);
            field.set(boundSql, newSql);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0BoundSql\u5931\u8d25", (Throwable)e);
        }
    }

    public Object plugin(Object target) {
        return target instanceof StatementHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties properties) {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

