/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.config;

import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="ocs.sap")
public class SapConfigProperties {
    private boolean enabled = true;
    @NestedConfigurationProperty
    private GlobalConfig global = new GlobalConfig();
    private List<PathMapping> pathMapping;
    private String limitTime;
    @NestedConfigurationProperty
    private HeaderConfig header = new HeaderConfig();
    @NestedConfigurationProperty
    private PathConfig path = new PathConfig();
    @NestedConfigurationProperty
    private MybatisConfig mybatis = new MybatisConfig();
    @NestedConfigurationProperty
    private FeignConfig feign = new FeignConfig();
    @NestedConfigurationProperty
    private ContextConfig context = new ContextConfig();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public GlobalConfig getGlobal() {
        return this.global;
    }

    public void setGlobal(GlobalConfig global) {
        this.global = global;
    }

    public List<PathMapping> getPathMapping() {
        return this.pathMapping;
    }

    public void setPathMapping(List<PathMapping> pathMapping) {
        this.pathMapping = pathMapping;
    }

    public String getLimitTime() {
        return this.limitTime;
    }

    public void setLimitTime(String limitTime) {
        this.limitTime = limitTime;
    }

    public HeaderConfig getHeader() {
        return this.header;
    }

    public void setHeader(HeaderConfig header) {
        this.header = header;
    }

    public PathConfig getPath() {
        return this.path;
    }

    public void setPath(PathConfig path) {
        this.path = path;
    }

    public MybatisConfig getMybatis() {
        return this.mybatis;
    }

    public void setMybatis(MybatisConfig mybatis) {
        this.mybatis = mybatis;
    }

    public FeignConfig getFeign() {
        return this.feign;
    }

    public void setFeign(FeignConfig feign) {
        this.feign = feign;
    }

    public ContextConfig getContext() {
        return this.context;
    }

    public void setContext(ContextConfig context) {
        this.context = context;
    }

    public static class ContextConfig {
        private boolean transmittable = false;

        public boolean isTransmittable() {
            return this.transmittable;
        }

        public void setTransmittable(boolean transmittable) {
            this.transmittable = transmittable;
        }
    }

    public static class FeignConfig {
        private boolean enabled = true;
        private String headerName = "X-SAP-Flag";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public void setHeaderName(String headerName) {
            this.headerName = headerName;
        }
    }

    public static class MybatisConfig {
        private boolean enabled = true;
        private String defaultOperator = "GTE";
        private String defaultConditionValue;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getDefaultOperator() {
            return this.defaultOperator;
        }

        public void setDefaultOperator(String defaultOperator) {
            this.defaultOperator = defaultOperator;
        }

        public String getDefaultConditionValue() {
            return this.defaultConditionValue;
        }

        public void setDefaultConditionValue(String defaultConditionValue) {
            this.defaultConditionValue = defaultConditionValue;
        }

        public String toString() {
            return "MybatisConfig{enabled=" + this.enabled + ", defaultOperator='" + this.defaultOperator + '\'' + ", defaultConditionValue='" + this.defaultConditionValue + '\'' + '}';
        }
    }

    public static class PathConfig {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class HeaderConfig {
        private boolean enabled = false;
        private String name = "X-SAP-Flag";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class PathMapping {
        private String path;
        private String table;
        private String field;
        private boolean enabled = true;
        private boolean ignoreGlobal = false;
        private String operator = "GTE";
        private String conditionValue;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isIgnoreGlobal() {
            return this.ignoreGlobal;
        }

        public void setIgnoreGlobal(boolean ignoreGlobal) {
            this.ignoreGlobal = ignoreGlobal;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getConditionValue() {
            return this.conditionValue;
        }

        public void setConditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
        }

        public String getTableField() {
            return this.table + "." + this.field;
        }

        public boolean isEffective(GlobalConfig globalConfig) {
            if (!this.enabled) {
                return false;
            }
            if (globalConfig == null) {
                return true;
            }
            if (globalConfig.isForceMode()) {
                return globalConfig.isEnabled();
            }
            if (this.ignoreGlobal) {
                return true;
            }
            return globalConfig.isEnabled();
        }

        public String toString() {
            return "PathMapping{path='" + this.path + '\'' + ", table='" + this.table + '\'' + ", field='" + this.field + '\'' + ", enabled=" + this.enabled + ", ignoreGlobal=" + this.ignoreGlobal + ", operator='" + this.operator + '\'' + ", conditionValue='" + this.conditionValue + '\'' + '}';
        }
    }

    public static class GlobalConfig {
        private boolean enabled = true;
        private boolean forceMode = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isForceMode() {
            return this.forceMode;
        }

        public void setForceMode(boolean forceMode) {
            this.forceMode = forceMode;
        }

        public String toString() {
            return "GlobalConfig{enabled=" + this.enabled + ", forceMode=" + this.forceMode + '}';
        }
    }
}

