/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.context;

import com.dtyunxi.sap.interceptor.context.SapServiceContextProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransmittableServiceContextProvider
implements SapServiceContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(SapTransmittableServiceContextProvider.class);
    private static final InheritableThreadLocal<Map<String, Object>> CONTEXT_HOLDER = new InheritableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>();
        }

        @Override
        protected Map<String, Object> childValue(Map<String, Object> parentValue) {
            return new ConcurrentHashMap<String, Object>(parentValue);
        }
    };

    @Override
    public void setAttachment(String key, Object value) {
        if (key == null) {
            logger.warn("\u5c1d\u8bd5\u8bbe\u7f6enull key\u7684attachment");
            return;
        }
        Map context = (Map)CONTEXT_HOLDER.get();
        if (value == null) {
            context.remove(key);
            logger.debug("\u79fb\u9664attachment: {}", (Object)key);
        } else {
            context.put(key, value);
            logger.debug("\u8bbe\u7f6eattachment: {} = {}", (Object)key, value);
        }
    }

    @Override
    public <T> T getAttachment(String key) {
        if (key == null) {
            return null;
        }
        Map context = (Map)CONTEXT_HOLDER.get();
        Object value = context.get(key);
        if (value != null) {
            logger.debug("\u83b7\u53d6attachment: {} = {}", (Object)key, value);
        }
        return (T)value;
    }

    @Override
    public void removeAttachment(String key) {
        if (key == null) {
            return;
        }
        Map context = (Map)CONTEXT_HOLDER.get();
        Object removed = context.remove(key);
        if (removed != null) {
            logger.debug("\u79fb\u9664attachment: {} = {}", (Object)key, removed);
        }
    }

    @Override
    public boolean hasAttachment(String key) {
        if (key == null) {
            return false;
        }
        Map context = (Map)CONTEXT_HOLDER.get();
        return context.containsKey(key);
    }

    @Override
    public Map<String, Object> getAttachments() {
        Map context = (Map)CONTEXT_HOLDER.get();
        return new HashMap<String, Object>(context);
    }

    @Override
    public void setAttachments(Map<String, Object> attachments) {
        Map context = (Map)CONTEXT_HOLDER.get();
        context.clear();
        if (attachments != null) {
            context.putAll(attachments);
            logger.debug("\u6279\u91cf\u8bbe\u7f6eattachments: {}", attachments);
        }
    }

    @Override
    public void clear() {
        Map context = (Map)CONTEXT_HOLDER.get();
        context.clear();
        logger.debug("\u6e05\u7a7a\u5f53\u524d\u7ebf\u7a0b\u7684ServiceContext");
    }

    public static void remove() {
        CONTEXT_HOLDER.remove();
    }

    public static Map<String, Object> getCurrentContext() {
        return (Map)CONTEXT_HOLDER.get();
    }

    public static void setCurrentContext(Map<String, Object> context) {
        if (context == null) {
            CONTEXT_HOLDER.remove();
        } else {
            CONTEXT_HOLDER.set(new ConcurrentHashMap<String, Object>(context));
        }
    }
}

