/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.context;

import com.dtyunxi.sap.interceptor.context.ServiceContextProvider;
import com.dtyunxi.sap.interceptor.context.TransmittableServiceContextProvider;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapContextExecutorWrapper
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(SapContextExecutorWrapper.class);
    private final Executor delegate;
    private final ServiceContextProvider serviceContextProvider;

    public SapContextExecutorWrapper(Executor delegate, ServiceContextProvider serviceContextProvider) {
        this.delegate = delegate;
        this.serviceContextProvider = serviceContextProvider;
    }

    @Override
    public void execute(Runnable command) {
        Map<String, Object> currentContext = this.serviceContextProvider.getAttachments();
        this.delegate.execute(() -> {
            if (currentContext != null && !currentContext.isEmpty()) {
                this.serviceContextProvider.setAttachments(currentContext);
                logger.debug("\u5728\u65b0\u7ebf\u7a0b\u4e2d\u6062\u590dSAP\u4e0a\u4e0b\u6587: {}", (Object)currentContext);
            }
            try {
                command.run();
            }
            finally {
                this.serviceContextProvider.clear();
                if (this.serviceContextProvider instanceof TransmittableServiceContextProvider) {
                    TransmittableServiceContextProvider.remove();
                }
            }
        });
    }

    public static SapContextExecutorWrapper wrap(Executor executor, ServiceContextProvider serviceContextProvider) {
        if (executor instanceof SapContextExecutorWrapper) {
            return (SapContextExecutorWrapper)executor;
        }
        return new SapContextExecutorWrapper(executor, serviceContextProvider);
    }
}

