/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerLevelDomain;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerLevelReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerLevelRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerLevelEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerExtService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerLevelService;
import com.yunxi.dg.base.center.customer.utils.MybatisPlusUtils;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="dgCustomerLevelService")
public class DgCustomerLevelServiceImpl
implements IDgCustomerLevelService {
    @Resource
    private IDgCustomerLevelDomain iDgCustomerLevelDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource(name="dgCustomerV2Service")
    private IDgCustomerExtService iDgCustomerExtService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(DgCustomerLevelReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        reqDto.setId(null);
        this.validCustomerLevelName(reqDto);
        DgCustomerLevelEo dgCustomerLevelEo = new DgCustomerLevelEo();
        this.initCustomerLevelEo(reqDto, dgCustomerLevelEo);
        dgCustomerLevelEo.setOrgInfoId(this.iDgCustomerExtService.getCurrentUserOrgId());
        this.iDgCustomerLevelDomain.insert((BaseEo)dgCustomerLevelEo);
        return dgCustomerLevelEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DgCustomerLevelReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        Assert.notNull((Object)reqDto.getId(), (String)DgCustomerExceptionCode.PK_ID_NULL.getMsg());
        DgCustomerLevelEo queryEo = (DgCustomerLevelEo)this.iDgCustomerLevelDomain.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)DgCustomerExceptionCode.CUSTOMER_LEVEL_NON_EXIST.getMsg());
        reqDto.setType(queryEo.getType());
        this.validCustomerLevelName(reqDto);
        queryEo.setName(reqDto.getName());
        this.iDgCustomerLevelDomain.updateSelective((BaseEo)queryEo);
    }

    @Override
    public void delete(Long id) {
        DgCustomerEo queryEo = new DgCustomerEo();
        queryEo.setLevelId(id);
        MybatisPlusUtils.checkUnique(this.iDgCustomerDomain, queryEo, DgCustomerExceptionCode.CUSTOMER_LEVEL_EXISTS_CUSTOMER.getCode(), DgCustomerExceptionCode.CUSTOMER_LEVEL_EXISTS_CUSTOMER.getMsg());
        this.iDgCustomerLevelDomain.logicDeleteById(id);
    }

    @Override
    public DgCustomerLevelRespDto queryById(Long id) {
        DgCustomerLevelEo dgCustomerLevelEo = (DgCustomerLevelEo)this.iDgCustomerLevelDomain.selectByPrimaryKey(id);
        Assert.notNull((Object)dgCustomerLevelEo, (String)DgCustomerExceptionCode.CUSTOMER_LEVEL_NON_EXIST.getMsg());
        DgCustomerLevelRespDto dgCustomerLevelRespDto = new DgCustomerLevelRespDto();
        DtoHelper.eo2Dto((BaseEo)dgCustomerLevelEo, (BaseVo)dgCustomerLevelRespDto);
        return dgCustomerLevelRespDto;
    }

    @Override
    public PageInfo<DgCustomerLevelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgCustomerLevelEo dgCustomerLevelEo = new DgCustomerLevelEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            DgCustomerLevelReqDto dgCustomerLevelReqDto = (DgCustomerLevelReqDto)JSONObject.parseObject((String)filter, DgCustomerLevelReqDto.class);
            DtoHelper.dto2Eo((BaseVo)dgCustomerLevelReqDto, (BaseEo)dgCustomerLevelEo);
        }
        Assert.notNull((Object)dgCustomerLevelEo.getType(), (String)DgCustomerExceptionCode.CUSTOMER_LEVEL_TYPE_NULL.getMsg());
        dgCustomerLevelEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        dgCustomerLevelEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        LambdaQueryWrapper<DgCustomerLevelEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(dgCustomerLevelEo);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageInfo<DgCustomerLevelRespDto> respDtoPageInfo = MybatisPlusUtils.selectPage(this.iDgCustomerLevelDomain, queryWrapper, DgCustomerLevelRespDto.class, pageNum, pageSize);
        return respDtoPageInfo;
    }

    @Override
    public List<DgCustomerLevelRespDto> queryByList(String filter) {
        DgCustomerLevelEo dgCustomerLevelEo = new DgCustomerLevelEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            DgCustomerLevelReqDto dgCustomerLevelReqDto = (DgCustomerLevelReqDto)JSONObject.parseObject((String)filter, DgCustomerLevelReqDto.class);
            DtoHelper.dto2Eo((BaseVo)dgCustomerLevelReqDto, (BaseEo)dgCustomerLevelEo);
        }
        dgCustomerLevelEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        dgCustomerLevelEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        dgCustomerLevelEo.setType(Integer.valueOf(1));
        Assert.notNull((Object)dgCustomerLevelEo.getType(), (String)DgCustomerExceptionCode.CUSTOMER_LEVEL_TYPE_NULL.getMsg());
        dgCustomerLevelEo.setDr(CommonConstants.Dr.NO);
        List customerLevelEoList = this.iDgCustomerLevelDomain.selectList((BaseEo)dgCustomerLevelEo);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerLevelEoList, (Collection)respDtoList, DgCustomerLevelRespDto.class);
        return respDtoList;
    }

    private void validCustomerLevelName(DgCustomerLevelReqDto reqDto) {
        Assert.hasText((String)reqDto.getName(), (String)DgCustomerExceptionCode.NAME_NULL.getMsg());
        Assert.notNull((Object)reqDto.getType(), (String)DgCustomerExceptionCode.CUSTOMER_LEVEL_TYPE_NULL.getMsg());
        DgCustomerLevelEo eo = new DgCustomerLevelEo();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        eo.setId(reqDto.getId());
        eo.setTenantId(reqDto.getTenantId());
        eo.setType(reqDto.getType());
        MybatisPlusUtils.checkUnique(this.iDgCustomerLevelDomain, eo, DgCustomerExceptionCode.CUSTOMER_LEVEL_NAME_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_LEVEL_NAME_EXISTS.getMsg());
    }

    private void initCustomerLevelEo(DgCustomerLevelReqDto reqDto, DgCustomerLevelEo dgCustomerLevelEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)dgCustomerLevelEo);
    }
}

