/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.domain.IDgBillInfoDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgInvoiceInfoDomain;
import com.yunxi.dg.base.center.customer.dto.request.DgBillInfoAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgBillInfoModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgBillInfoQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgInvoiceInfoAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgInvoiceInfoModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgBillInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgInvoiceInfoRespDto;
import com.yunxi.dg.base.center.customer.eo.DgBillInfoEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgInvoiceInfoEo;
import com.yunxi.dg.base.center.customer.service.IDgBillInfoService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DgBillInfoServiceImpl
implements IDgBillInfoService {
    @Resource
    private IDgBillInfoDomain iDgBillInfoDomain;
    @Resource
    private IDgInvoiceInfoDomain iDgInvoiceInfoDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillInfo(DgBillInfoAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgBillInfoEo billInfoEo = new DgBillInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
        this.iDgBillInfoDomain.insert((BaseEo)billInfoEo);
        if (null != reqDto.getIsDefault() && reqDto.getIsDefault() == 1) {
            this.iDgBillInfoDomain.updateStatusByOrgInfoId(billInfoEo.getOrgInfoId(), billInfoEo.getId());
        }
        return billInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillInfo(DgBillInfoModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgBillInfoEo billInfoEo = new DgBillInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
        this.iDgBillInfoDomain.updateSelective((BaseEo)billInfoEo);
        if (null != reqDto.getIsDefault() && reqDto.getIsDefault() == 1) {
            this.iDgBillInfoDomain.updateStatusByOrgInfoId(billInfoEo.getOrgInfoId(), billInfoEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillInfo(Long id) {
        this.iDgBillInfoDomain.deleteById(id);
    }

    @Override
    public DgBillInfoRespDto queryBillInfoById(Long id) {
        DgBillInfoEo billInfoEo = (DgBillInfoEo)this.iDgBillInfoDomain.selectByPrimaryKey(id);
        if (billInfoEo == null) {
            return null;
        }
        DgBillInfoRespDto billInfoRespDto = new DgBillInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)billInfoEo, (BaseVo)billInfoRespDto);
        return billInfoRespDto;
    }

    @Override
    public PageInfo<DgBillInfoRespDto> queryBillInfoByPage(DgBillInfoQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        DgBillInfoEo billInfoEo = new DgBillInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
        PageInfo eoPageInfo = this.iDgBillInfoDomain.selectPage((BaseEo)billInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgBillInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addInvoiceInfo(DgInvoiceInfoAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"orgInfoId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgInvoiceInfoEo queryEo = new DgInvoiceInfoEo();
        queryEo.setOrgInfoId(reqDto.getOrgInfoId());
        queryEo.setDr(CommonConstants.Dr.NO);
        List invoiceInfoEos = this.iDgInvoiceInfoDomain.selectList((BaseEo)queryEo);
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoEos)) {
            this.iDgInvoiceInfoDomain.getMapper().delete((Wrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId()));
        }
        DgInvoiceInfoEo invoiceInfoEo = new DgInvoiceInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)invoiceInfoEo);
        this.iDgInvoiceInfoDomain.insert((BaseEo)invoiceInfoEo);
        return invoiceInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyInvoiceInfo(DgInvoiceInfoModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DgInvoiceInfoEo invoiceInfoEo = new DgInvoiceInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)invoiceInfoEo);
        this.iDgInvoiceInfoDomain.updateSelective((BaseEo)invoiceInfoEo);
    }

    @Override
    public DgInvoiceInfoRespDto queryInvoiceInfoByOrgInfoId(Long orgInfoId) {
        DgInvoiceInfoEo invoiceInfoEo = new DgInvoiceInfoEo();
        invoiceInfoEo.setOrgInfoId(orgInfoId);
        invoiceInfoEo.setDr(CommonConstants.Dr.NO);
        List invoiceInfoEos = this.iDgInvoiceInfoDomain.selectList((BaseEo)invoiceInfoEo);
        if (CollectionUtils.isEmpty((Collection)invoiceInfoEos)) {
            return null;
        }
        DgInvoiceInfoRespDto invoiceInfoRespDto = new DgInvoiceInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)invoiceInfoEos.get(0)), (BaseVo)invoiceInfoRespDto);
        return invoiceInfoRespDto;
    }

    @Override
    public List<DgBillInfoRespDto> queryBillInfoListByOrgInfoId(Long orgInfoId) {
        DgBillInfoEo billInfoEo = new DgBillInfoEo();
        billInfoEo.setOrgInfoId(orgInfoId);
        billInfoEo.setDr(CommonConstants.Dr.NO);
        List billInfoEoList = this.iDgBillInfoDomain.selectList((BaseEo)billInfoEo);
        ArrayList<DgBillInfoRespDto> billInfoDtoList = new ArrayList<DgBillInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)billInfoEoList, billInfoDtoList, DgBillInfoRespDto.class);
        return billInfoDtoList;
    }

    @Override
    public DgBillInfoRespDto queryBillInfoByOrgInfoId(Integer type, Long orgInfoId) {
        DgBillInfoRespDto respDto = null;
        DgBillInfoEo billInfoEo = new DgBillInfoEo();
        billInfoEo.setOrgInfoId(orgInfoId);
        billInfoEo.setAccountType(type);
        billInfoEo.setIsDefault(Integer.valueOf(1));
        billInfoEo.setDr(CommonConstants.Dr.NO);
        List billInfoEoList = this.iDgBillInfoDomain.selectList((BaseEo)billInfoEo);
        ArrayList billInfoDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)billInfoEoList, billInfoDtoList, DgBillInfoRespDto.class);
        if (CollectionUtil.isNotEmpty(billInfoDtoList)) {
            respDto = (DgBillInfoRespDto)billInfoDtoList.get(0);
        }
        return respDto;
    }

    @Override
    public void batchAddBillInfo(List<DgBillInfoAddReqDto> billInfoAddReqDtoList) {
        if (CollectionUtil.isNotEmpty(billInfoAddReqDtoList)) {
            ArrayList<DgBillInfoEo> infoEoList = new ArrayList<DgBillInfoEo>();
            for (DgBillInfoAddReqDto reqDto : billInfoAddReqDtoList) {
                DgBillInfoEo billInfoEo = new DgBillInfoEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
                infoEoList.add(billInfoEo);
            }
            if (CollectionUtil.isNotEmpty(infoEoList)) {
                this.iDgBillInfoDomain.insertBatch(infoEoList);
            }
        }
    }

    @Override
    public void batchUpdateBillInfo(List<DgBillInfoAddReqDto> billInfoAddReqDtoList) {
        if (CollectionUtil.isNotEmpty(billInfoAddReqDtoList)) {
            for (DgBillInfoAddReqDto reqDto : billInfoAddReqDtoList) {
                DgBillInfoEo queryEo = new DgBillInfoEo();
                queryEo.setCustomerId(reqDto.getCustomerId());
                List dgBillInfoEoList = this.iDgBillInfoDomain.selectList((BaseEo)queryEo);
                if (!CollectionUtil.isNotEmpty((Collection)dgBillInfoEoList)) continue;
                DgBillInfoEo dgBillInfoEo = new DgBillInfoEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)dgBillInfoEo);
                dgBillInfoEo.setId(((DgBillInfoEo)dgBillInfoEoList.get(0)).getId());
                this.iDgBillInfoDomain.updateSelective((BaseEo)dgBillInfoEo);
            }
        }
    }

    @Override
    public List<DgBillInfoRespDto> queryBillInfoByCustomerId(Long customerId) {
        if (null == customerId) {
            return null;
        }
        DgBillInfoEo queryEo = new DgBillInfoEo();
        queryEo.setCustomerId(customerId);
        queryEo.setDr(CommonConstants.Dr.NO);
        List dgBillInfoEoList = this.iDgBillInfoDomain.selectList((BaseEo)queryEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dgBillInfoEoList)) {
            ArrayList<DgBillInfoRespDto> billInfoDtoList = new ArrayList<DgBillInfoRespDto>();
            DtoHelper.eoList2DtoList((Collection)dgBillInfoEoList, billInfoDtoList, DgBillInfoRespDto.class);
            return billInfoDtoList;
        }
        return null;
    }

    @Override
    public List<DgBillInfoRespDto> queryBillInfoByCustomerCode(String customerCode) {
        DgCustomerEo customerEo = new DgCustomerEo();
        customerEo.setCode(customerCode);
        DgCustomerEo dgCustomerEo = (DgCustomerEo)this.iDgCustomerDomain.selectOne((BaseEo)customerEo);
        if (null != dgCustomerEo && null != dgCustomerEo.getId()) {
            return this.queryBillInfoByCustomerId(dgCustomerEo.getId());
        }
        return null;
    }
}

