/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.BaseReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaInfoReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaListReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaSubTreeReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaTreeReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgParentAreCodeReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerAreaRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerAreaTreeRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerAreaEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerAreaService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerExtService;
import com.yunxi.dg.base.center.customer.utils.MybatisPlusUtils;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerAreaServiceImpl
implements IDgCustomerAreaService {
    private Logger logger = LoggerFactory.getLogger(DgCustomerAreaServiceImpl.class);
    public static final String DEFAULT_CODE = "0";
    @Resource
    private IContext context;
    @Resource
    private IDgCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource(name="dgCustomerV2Service")
    private IDgCustomerExtService customerExtService;

    private <DTO extends BaseReqDto> void setCommon(DgCustomerAreaEo customerAreaEo, DTO dto) {
        customerAreaEo.setTenantId(Objects.nonNull(dto.getTenantId()) ? dto.getTenantId() : this.context.tenantId());
        customerAreaEo.setInstanceId(Objects.nonNull(dto.getInstanceId()) ? dto.getInstanceId() : this.context.instanceId());
    }

    private Long getOrgId(Long orgId) {
        if (Objects.nonNull(orgId)) {
            return orgId;
        }
        return this.customerExtService.getCurrentUserOrgId();
    }

    @Override
    public Long saveCustomerArea(DgCustomerAreaReqDto customerAreaReqDto) {
        String name = customerAreaReqDto.getName();
        String parentCode = customerAreaReqDto.getParentCode();
        String code = IdUtil.fastSimpleUUID();
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        customerAreaEo.setCode(code);
        customerAreaEo.setName(name);
        customerAreaEo.setAreaCode(customerAreaReqDto.getAreaCode());
        this.setCommon(customerAreaEo, customerAreaReqDto);
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaReqDto.getOrgInfoId()));
        this.checkCustomerAreaName(customerAreaEo.getOrgInfoId(), customerAreaReqDto);
        if (StrUtil.isNotBlank((CharSequence)parentCode)) {
            DgCustomerAreaEo parentCustomerAreaEo = this.checkCustomerAreaCode(customerAreaEo.getOrgInfoId(), parentCode);
            customerAreaEo.setLevel(Integer.valueOf(parentCustomerAreaEo.getLevel() + 1));
            customerAreaEo.setParentCode(parentCode);
            customerAreaEo.setTopId(parentCustomerAreaEo.getTopId());
        } else {
            customerAreaEo.setLevel(Integer.valueOf(1));
            customerAreaEo.setParentCode(DEFAULT_CODE);
            customerAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            customerAreaEo.setTopId(customerAreaEo.getId());
        }
        customerAreaEo.setSort(Integer.valueOf(1));
        this.iDgCustomerAreaDomain.insert((BaseEo)customerAreaEo);
        return customerAreaEo.getId();
    }

    @Override
    public void removeByCondition(DgCustomerAreaInfoReqDto customerAreaInfoReqDto) {
        Integer count;
        String code = customerAreaInfoReqDto.getCode();
        Long id = customerAreaInfoReqDto.getId();
        if (Objects.isNull(id) && StrUtil.isBlank((CharSequence)code)) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.INSUFFICIENT_PARAMETERS);
        }
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        customerAreaEo.setCode(code);
        customerAreaEo.setId(id);
        customerAreaEo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            return;
        }
        DgCustomerAreaEo customerArea = new DgCustomerAreaEo();
        customerArea.setParentCode(code);
        List customerAreaEos = this.iDgCustomerAreaDomain.selectList((BaseEo)customerArea);
        if (CollUtil.isNotEmpty((Collection)customerAreaEos)) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.REGION_EXISTS_CHILD);
        }
        if ((count = this.iDgCustomerAreaDomain.isExistCustomer(customerAreaEo)) > 0) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.REGION_EXISTS_CUSTOMER);
        }
        this.iDgCustomerAreaDomain.logicDeleteById(customerAreaEo.getId());
    }

    @Override
    public void modifyCustomerArea(Long id, DgCustomerAreaReqDto customerAreaReqDto) {
        DgCustomerAreaEo customerAreaEo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectByPrimaryKey(id);
        if (Objects.isNull(customerAreaEo)) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.INVALID_ZONE_ID);
        }
        Long orgId = customerAreaEo.getOrgInfoId();
        customerAreaReqDto.setId(id);
        this.checkCustomerAreaName(orgId, customerAreaReqDto);
        customerAreaEo.setName(customerAreaReqDto.getName());
        if (StrUtil.isNotBlank((CharSequence)customerAreaReqDto.getAreaCode())) {
            customerAreaEo.setAreaCode(customerAreaReqDto.getAreaCode());
        }
        this.iDgCustomerAreaDomain.update((BaseEo)customerAreaEo);
    }

    @Override
    public PageInfo<DgCustomerAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgCustomerAreaEo customerAreaEo = (DgCustomerAreaEo)JSON.parseObject((String)filter, DgCustomerAreaEo.class);
        if (Objects.isNull(customerAreaEo.getInstanceId())) {
            customerAreaEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(customerAreaEo.getTenantId())) {
            customerAreaEo.setTenantId(this.context.tenantId());
        }
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaEo.getOrgInfoId()));
        PageInfo pageInfo = this.iDgCustomerAreaDomain.selectPage((BaseEo)customerAreaEo, pageNum, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList list = new ArrayList(pageInfo.getList().size());
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), list, DgCustomerAreaRespDto.class);
            pageInfo.setList(list);
        }
        return pageInfo;
    }

    @Override
    public List<DgCustomerAreaTreeRespDto> queryForTree(DgCustomerAreaTreeReqDto customerAreaTreeReqDto) {
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaTreeReqDto.getOrgInfoId()));
        customerAreaEo.setDr(CommonConstants.Dr.NO);
        this.setCommon(customerAreaEo, customerAreaTreeReqDto);
        List areaList = this.iDgCustomerAreaDomain.selectList((BaseEo)customerAreaEo);
        if (CollUtil.isEmpty((Collection)areaList)) {
            return ListUtil.empty();
        }
        return this.getTreeList(areaList, DEFAULT_CODE);
    }

    private List<DgCustomerAreaTreeRespDto> getTreeList(List<DgCustomerAreaEo> areaList, String parentCode) {
        ArrayList<DgCustomerAreaTreeRespDto> areaTreeRespDtoList = new ArrayList<DgCustomerAreaTreeRespDto>();
        Map<String, List<DgCustomerAreaEo>> areaMap = areaList.stream().sorted(Comparator.comparing(DgCustomerAreaEo::getSort)).collect(Collectors.groupingBy(DgCustomerAreaEo::getParentCode));
        DtoHelper.eoList2DtoList((Collection)areaMap.get(parentCode), areaTreeRespDtoList, DgCustomerAreaTreeRespDto.class);
        areaMap.remove(parentCode);
        this.getChildArea(areaTreeRespDtoList, areaMap);
        return areaTreeRespDtoList;
    }

    @Override
    public List<DgCustomerAreaRespDto> queryForList(DgCustomerAreaListReqDto customerAreaListReqDto) {
        List ids;
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaListReqDto, (BaseEo)customerAreaEo);
        this.setCommon(customerAreaEo, customerAreaListReqDto);
        LambdaQueryWrapper<DgCustomerAreaEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerAreaEo);
        List codes = customerAreaListReqDto.getCodes();
        if (CollUtil.isNotEmpty((Collection)codes)) {
            queryWrapper.in(DgCustomerAreaEo::getCode, (Collection)codes);
        }
        if (CollUtil.isNotEmpty((Collection)(ids = customerAreaListReqDto.getIds()))) {
            queryWrapper.in(BaseEo::getId, (Collection)ids);
        }
        queryWrapper.orderByAsc(DgCustomerAreaEo::getSort);
        List list = this.iDgCustomerAreaDomain.getMapper().selectList(queryWrapper);
        return list.stream().map(item -> (DgCustomerAreaRespDto)item.toDto(DgCustomerAreaRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public DgCustomerAreaTreeRespDto queryForSubTree(DgCustomerAreaSubTreeReqDto customerAreaSubTreeReqDto) {
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaSubTreeReqDto, (BaseEo)customerAreaEo);
        customerAreaEo.setOrgInfoId(this.getOrgId(customerAreaEo.getOrgInfoId()));
        this.setCommon(customerAreaEo, customerAreaSubTreeReqDto);
        customerAreaEo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            return null;
        }
        DgCustomerAreaTreeRespDto customerAreaTreeRespDto = (DgCustomerAreaTreeRespDto)customerAreaEo.toDto(DgCustomerAreaTreeRespDto.class);
        List<DgCustomerAreaEo> list = this.getCustomerArea(customerAreaEo.getTopId(), customerAreaEo.getLevel());
        customerAreaTreeRespDto.setChildren(this.getTreeList(list, customerAreaTreeRespDto.getCode()));
        return customerAreaTreeRespDto;
    }

    @Override
    public List<String> querySubCodeAll(DgCustomerAreaListReqDto customerAreaListReqDto) {
        HashSet<String> codeSet = new HashSet<String>();
        List<DgCustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        for (DgCustomerAreaRespDto item : customerAreaRespDtos) {
            codeSet.add(item.getCode());
            List<DgCustomerAreaEo> list = this.getCustomerArea(item.getTopId(), item.getLevel());
            if (CollUtil.isEmpty(list)) continue;
            Integer level = item.getLevel();
            Map<Integer, List<DgCustomerAreaEo>> levelMap = list.stream().collect(Collectors.groupingBy(DgCustomerAreaEo::getLevel));
            this.setCode(levelMap, codeSet, level, item.getCode());
        }
        return ListUtil.toList(codeSet);
    }

    @Override
    public List<String> queryAllParentCode(DgParentAreCodeReqDto reqDto) {
        List codes = reqDto.getCodes();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)codes));
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        customerAreaEo.setSqlFilters(sqlFilters);
        List customerAreaEoList = this.iDgCustomerAreaDomain.selectList((BaseEo)customerAreaEo);
        ArrayList<String> allCodes = new ArrayList<String>();
        for (DgCustomerAreaEo customerEo : customerAreaEoList) {
            allCodes.add(customerEo.getCode());
            this.selectParentCode(allCodes, customerEo.getCode());
        }
        return allCodes;
    }

    private void selectParentCode(List<String> codes, String code) {
        DgCustomerAreaEo condition = new DgCustomerAreaEo();
        condition.setCode(code);
        DgCustomerAreaEo eo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectOne((BaseEo)condition);
        if (Objects.isNull(eo)) {
            return;
        }
        if (DEFAULT_CODE.equals(eo.getParentCode())) {
            codes.add(eo.getCode());
            return;
        }
        condition.setCode(eo.getParentCode());
        DgCustomerAreaEo parentEo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectOne((BaseEo)condition);
        if (Objects.nonNull(parentEo)) {
            codes.add(parentEo.getCode());
            if (!DEFAULT_CODE.equals(parentEo.getParentCode())) {
                this.selectParentCode(codes, parentEo.getParentCode());
            }
        }
    }

    @Override
    public String queryAreaNameByCode(List<String> areaCodeList) {
        DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(areaCodeList);
        List<DgCustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        if (CollUtil.isEmpty(customerAreaRespDtos)) {
            return null;
        }
        return customerAreaRespDtos.stream().map(DgCustomerAreaRespDto::getName).collect(Collectors.joining(","));
    }

    @Override
    public Map<String, String> queryAreaNameMapByCode(List<String> areaCodeList) {
        DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(areaCodeList);
        List<DgCustomerAreaRespDto> customerAreaRespDtos = this.queryForList(customerAreaListReqDto);
        if (CollUtil.isEmpty(customerAreaRespDtos)) {
            return MapUtil.empty();
        }
        Map<String, String> areaNameMap = customerAreaRespDtos.stream().collect(Collectors.toMap(DgCustomerAreaRespDto::getCode, DgCustomerAreaRespDto::getName, (o1, o2) -> o2));
        return areaNameMap;
    }

    private void setCode(Map<Integer, List<DgCustomerAreaEo>> levelMap, Set<String> codeSet, Integer level, String code) {
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level + 1);
        if (levelMap.containsKey(level)) {
            List<DgCustomerAreaEo> customerAreaEos = levelMap.get(level);
            customerAreaEos.forEach(item -> {
                if (Objects.equals(code, item.getParentCode())) {
                    codeSet.add(item.getCode());
                    this.setCode(levelMap, codeSet, item.getLevel(), item.getCode());
                }
            });
        }
    }

    private List<DgCustomerAreaEo> getCustomerArea(Long topId, Integer level) {
        DgCustomerAreaEo subCustomerAreaEo = new DgCustomerAreaEo();
        subCustomerAreaEo.setDr(0);
        subCustomerAreaEo.setTopId(topId);
        QueryWrapper queryWrapper = new QueryWrapper((Object)subCustomerAreaEo);
        queryWrapper.gt((Object)"level", (Object)level);
        queryWrapper.orderByAsc((Object)"sort");
        List list = this.iDgCustomerAreaDomain.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    private void getChildArea(List<DgCustomerAreaTreeRespDto> areaGroupTreeRespDtoList, Map<String, List<DgCustomerAreaEo>> areaGroupMap) {
        areaGroupTreeRespDtoList.forEach(areaGroupTreeDto -> {
            List areaGroupEoList = (List)areaGroupMap.get(areaGroupTreeDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)areaGroupEoList)) {
                List<DgCustomerAreaTreeRespDto> areaGroupChildrenDtoList = areaGroupEoList.stream().sorted(Comparator.comparing(DgCustomerAreaEo::getSort)).map(item -> (DgCustomerAreaTreeRespDto)item.toDto(DgCustomerAreaTreeRespDto.class)).collect(Collectors.toList());
                areaGroupTreeDto.setChildren(areaGroupChildrenDtoList);
                areaGroupMap.remove(areaGroupTreeDto.getCode());
                this.getChildArea(areaGroupChildrenDtoList, areaGroupMap);
            }
        });
    }

    private void checkCustomerAreaName(Long orgId, DgCustomerAreaReqDto customerAreaReqDto) {
        Long id = customerAreaReqDto.getId();
        String name = customerAreaReqDto.getName();
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        customerAreaEo.setOrgInfoId(orgId);
        customerAreaEo.setDr(0);
        QueryWrapper queryWrapper = new QueryWrapper((Object)customerAreaEo);
        if (Objects.nonNull(id)) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        customerAreaEo.setName(name);
        queryWrapper.setEntity((Object)customerAreaEo);
        Integer count = this.iDgCustomerAreaDomain.getMapper().selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.AREA_NAME_ALREADY_EXISTS);
        }
    }

    private DgCustomerAreaEo checkCustomerAreaCode(Long orgId, String code) {
        DgCustomerAreaEo customerAreaEo = new DgCustomerAreaEo();
        customerAreaEo.setCode(code);
        customerAreaEo.setOrgInfoId(orgId);
        customerAreaEo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            BizExceptionHelper.throwBizException((IExceptionCode)DgCustomerExceptionCode.INVALID_AREA_CODE);
        }
        return customerAreaEo;
    }
}

