/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.constants.OssConstant;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dao.mapper.DgCustomerMapper;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerExportRecordDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerGroupDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerLevelDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerStatusDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerTypeDomain;
import com.yunxi.dg.base.center.customer.domain.IDgRCustomerRegionDomain;
import com.yunxi.dg.base.center.customer.domain.IDgRCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.dto.enums.AuditStatusEnum;
import com.yunxi.dg.base.center.customer.dto.enums.CsGenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.customer.dto.enums.CustomerTypeEnum;
import com.yunxi.dg.base.center.customer.dto.enums.StatusEnum;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerBusinessRuntimeException;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerAreaListReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerInfoReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchBaseReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchPageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgExportRecordReqDto;
import com.yunxi.dg.base.center.customer.dto.response.BaseRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgBillInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgContactsInfoRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerAreaRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerNameSimpleRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerExportRecordEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerGroupEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerLevelEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerStatusEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerTypeEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerRegionEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.service.IDgBillInfoService;
import com.yunxi.dg.base.center.customer.service.IDgContactsInfoService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerAreaService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerExtService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerService;
import com.yunxi.dg.base.center.customer.utils.GenerateCodeUtils;
import com.yunxi.dg.base.center.customer.vo.CustomerExportVo;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service(value="dgCustomerService")
public class DgCustomerServiceImpl
implements IDgCustomerService {
    private Logger logger = LoggerFactory.getLogger(DgCustomerServiceImpl.class);
    @Resource(name="dgCustomerV2Service")
    private IDgCustomerExtService iCustomerExtService;
    @Resource
    private IContext iContext;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource
    private IDgCustomerTypeDomain iDgCustomerTypeDomain;
    @Resource
    private IDgCustomerExportRecordDomain iDgCustomerExportRecordDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgCustomerStatusDomain iDgCustomerStatusDomain;
    @Resource
    private IDgCustomerSalesmanDomain iDgCustomerSalesmanDomain;
    @Resource
    private IDgRCustomerSalesmanDomain iDgRCustomerSalesmanDomain;
    @Resource
    private IDgCustomerGroupDomain iDgCustomerGroupDomain;
    @Resource
    private IDgRCustomerRegionDomain iDgRCustomerRegionDomain;
    @Resource
    private IDgCustomerLevelDomain iDgCustomerLevelDomain;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private IDgCustomerAreaService customerAreaService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDgBillInfoService billInfoService;
    @Resource
    private IDgContactsInfoService contactsInfoService;

    @Override
    public Long add(DgCustomerReqDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        reqDto.setId(null);
        if (StringUtils.isEmpty((CharSequence)reqDto.getCode())) {
            reqDto.setCode(GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.CUSTOMER.getCode()).getCode());
        }
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        if (null == reqDto.getStatusId()) {
            DgCustomerStatusEo statusReqDto = new DgCustomerStatusEo();
            statusReqDto.setCode("0");
            DgCustomerStatusEo statusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectOne((BaseEo)statusReqDto);
            reqDto.setStatusId(null != statusEo ? statusEo.getId() : null);
        }
        DgCustomerEo customerEo = new DgCustomerEo();
        this.initCustomerEo(reqDto, customerEo);
        RestResponse listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getOrgInfoId()}));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)listRestResponse.getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        Long id = this.iDgCustomerDomain.insertById(customerEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<DgRCustomerRegionEo> customerRegionEos = new ArrayList<DgRCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                DgRCustomerRegionEo customerRegionEo = new DgRCustomerRegionEo();
                customerRegionEo.setCustomerId(id);
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.iDgRCustomerRegionDomain.insertBatch(customerRegionEos);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getBillInfoDtoList())) {
            reqDto.getBillInfoDtoList().forEach(bill -> bill.setCustomerId(id));
            this.billInfoService.batchAddBillInfo(reqDto.getBillInfoDtoList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getContactsInfoAddReqDtoList())) {
            reqDto.getContactsInfoAddReqDtoList().forEach(contactsInfo -> contactsInfo.setCustomerId(id));
            this.contactsInfoService.batchAddContactsInfo(reqDto.getContactsInfoAddReqDtoList());
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DgCustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getId(), (String)DgCustomerExceptionCode.PK_ID_NULL.getMsg());
        DgCustomerEo queryEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        if (Objects.isNull(queryEo.getIfCertification())) {
            reqDto.setIfCertification(Integer.valueOf(0));
        }
        DgCustomerEo customerEo = new DgCustomerEo();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setCode(queryEo.getCode());
        this.iDgCustomerDomain.updateSelective((BaseEo)customerEo);
        DgRCustomerRegionEo deleteEo = new DgRCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.iDgRCustomerRegionDomain.delete((BaseEo)deleteEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<DgRCustomerRegionEo> customerRegionEos = new ArrayList<DgRCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                DgRCustomerRegionEo customerRegionEo = new DgRCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.iDgRCustomerRegionDomain.insertBatch(customerRegionEos);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)customerEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getBillInfoDtoList())) {
            reqDto.getBillInfoDtoList().forEach(bill -> bill.setCustomerId(reqDto.getId()));
            this.billInfoService.batchUpdateBillInfo(reqDto.getBillInfoDtoList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqDto.getContactsInfoAddReqDtoList())) {
            reqDto.getContactsInfoAddReqDtoList().forEach(contactsInfo -> contactsInfo.setCustomerId(reqDto.getId()));
            this.contactsInfoService.batchUpdateContactsInfo(reqDto.getContactsInfoAddReqDtoList());
        }
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    @Override
    public void sendMq(DgCustomerEo customerEo, String regionNames, String regionCodes) {
        DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                DgCustomerStatusEo customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
    }

    @Override
    public List<DgCustomerNameSimpleRespDto> queryByListParent(Long customerId) {
        ArrayList<Long> customerIds = new ArrayList<Long>();
        customerIds.add(customerId);
        List customerNameSimpleRespDtos = this.iDgCustomerDomain.queryListByParentIds(customerIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(DgCustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        List collect = customerNameSimpleRespDtos.stream().map(DgCustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        collect.add(customerId);
        return this.iDgCustomerDomain.queryListByNotIds(this.iContext.instanceId(), this.iContext.tenantId(), collect, null, null);
    }

    @Override
    public List<Long> queryIdsBySingleFilter(DgCustomerSearchBaseReqDto customerSearchReqDto) {
        List ids = this.iDgCustomerDomain.queryIdsBySingleFilter(customerSearchReqDto);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryExcelDownloadUrl() {
        String fileNameTemplate = "\u5ba2\u6237\u5bfc\u5165\u6a21\u677f_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
        Workbook workbook = null;
        ExportParams params = new ExportParams(null, "sheet1");
        ByteArrayOutputStream fos = null;
        String filePath = null;
        try {
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, CustomerExportVo.class, new ArrayList());
            ExcelExportUtil.closeExportBigExcel();
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            filePath = this.objectStorageService.put(OssConstant.BUCKET_NAME, fileNameTemplate, (InputStream)byteArrayInputStream);
            this.logger.info("Excel\u6587\u4ef6\uff1a{}\u5df2\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)(OssConstant.OSS_DOWNLOAD_URL + "/" + fileNameTemplate));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException var13) {
                this.logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return filePath;
    }

    @Override
    public PageInfo<DgCustomerRespDto> queryByExcel(MultipartFile file) {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List customerImportVoList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), CustomerExportVo.class, (ImportParams)importParams);
            customerImportVoList = result.getList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(customerImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        DgCustomerSearchReqDto searchReqDto = new DgCustomerSearchReqDto();
        ArrayList codeInList = new ArrayList();
        customerImportVoList.forEach(customerExportVo -> codeInList.add(customerExportVo.getCode()));
        searchReqDto.setCodeInList(codeInList);
        return this.queryByPage(JSON.toJSONString((Object)searchReqDto), 1, Integer.MAX_VALUE);
    }

    @Override
    public List<DgCustomerRespDto> queryPostByList(DgCustomerSearchReqDto searchReqDto) {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", (Object)StringUtils.join((Iterable)searchReqDto.getRegionCodes(), (String)",")));
            selectEo.setSqlFilters(sqlFilters);
            selectEo.setDr(CommonConstants.Dr.NO);
            List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        List customerList = this.iDgCustomerDomain.queryListBySearchCon(searchReqDto);
        return customerList;
    }

    @Override
    public void modifyCustomerUserIdByThirdPartyId(List<DgCustomerReqDto> reqDtos) {
        this.iDgCustomerDomain.modifyCustomerUserIdByThirdPartyId(reqDtos);
    }

    @Override
    public void batchAdd(List<DgCustomerReqDto> reqDtoList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(reqDtoList)) {
            for (DgCustomerReqDto reqDto : reqDtoList) {
                this.add(reqDto);
            }
        }
    }

    @Override
    public PageInfo<DgCustomerRespDto> queryDataByPage(DgCustomerSearchPageReqDto searchReqDto) {
        PageInfo respDtoPageInfo = this.iDgCustomerDomain.queryPageBySearchCon(searchReqDto);
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            List respDtoList = respDtoPageInfo.getList();
            List idList = respDtoList.stream().map(DgCustomerRespDto::getStatusId).collect(Collectors.toList());
            List customerStatusEoList = this.iDgCustomerStatusDomain.selectByIds(idList);
            Map<Object, Object> customerStatusEoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)customerStatusEoList)) {
                customerStatusEoMap = customerStatusEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (c1, c2) -> c2));
            }
            for (DgCustomerRespDto respDto : respDtoList) {
                if (!Objects.nonNull(customerStatusEoMap.get(respDto.getStatusId()))) continue;
                respDto.setStatusName(((DgCustomerStatusEo)customerStatusEoMap.get(respDto.getStatusId())).getName());
            }
        }
        return respDtoPageInfo;
    }

    @Override
    public void batchUpdateStatus(DgCustomerInfoReqDto customerInfoReqDto) {
        if (CollectionUtils.isEmpty((Collection)customerInfoReqDto.getIdList()) && CollectionUtils.isEmpty((Collection)customerInfoReqDto.getCodeList())) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_ID_NULL.getCode(), DgCustomerExceptionCode.CUSTOMER_ID_NULL.getMsg());
        }
        DgCustomerSearchPageReqDto reqDto = new DgCustomerSearchPageReqDto();
        if (CollectionUtils.isNotEmpty((Collection)customerInfoReqDto.getIdList())) {
            reqDto.setIdList(customerInfoReqDto.getIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)customerInfoReqDto.getCodeList())) {
            reqDto.setCodeInList(customerInfoReqDto.getCodeList());
        }
        List customerRespDtoList = this.iDgCustomerDomain.queryDataPageBySearch(reqDto);
        ArrayList<DgCustomerEo> customerEoList = new ArrayList<DgCustomerEo>();
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtoList)) {
            for (DgCustomerRespDto customerRespDto : customerRespDtoList) {
                DgCustomerEo customerEo = new DgCustomerEo();
                customerEo.setId(customerRespDto.getId());
                customerEo.setStatusId(customerInfoReqDto.getStatusId());
                customerEoList.add(customerEo);
            }
        }
        if (CollectionUtils.isNotEmpty(customerEoList)) {
            this.iDgCustomerDomain.updateStatusBatch(customerEoList);
        }
    }

    private List<DgCustomerNameSimpleRespDto> getCustomerRespDtos(List<Long> parentIds) {
        List customerNameSimpleRespDtos = this.iDgCustomerDomain.queryListByParentIds(parentIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(DgCustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        return customerNameSimpleRespDtos;
    }

    @Override
    public DgCustomerRespDto queryById(Long id) {
        List<DgContactsInfoRespDto> contactsInfoRespDtoList;
        List<DgBillInfoRespDto> billRespDtoList;
        DgCustomerStatusEo customerStatusEo;
        DgCustomerLevelEo customerLevelEo;
        DgCustomerEo customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(id);
        Assert.notNull((Object)customerEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        if (customerEo.getParentCustomerId() != null) {
            DgCustomerEo customerEo1 = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerEo.getParentCustomerId());
            customerEo1 = customerEo1 == null ? new DgCustomerEo() : customerEo1;
            customerRespDto.setParentCustomerName(customerEo1.getName());
        }
        if (null != customerEo.getCustomerTypeId()) {
            DgCustomerTypeEo customerTypeEo = (DgCustomerTypeEo)this.iDgCustomerTypeDomain.selectByPrimaryKey(customerEo.getCustomerTypeId());
            Assert.notNull((Object)customerTypeEo, (String)DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
            customerRespDto.setCustomerTypeName(customerTypeEo.getName());
        }
        DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
        selectEo.setCustomerId(id);
        selectEo.setDr(CommonConstants.Dr.NO);
        List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
        List regionCodeList = customerRegionEos.stream().map(DgRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
        customerRespDto.setRegionCodeList(regionCodeList);
        if (Objects.nonNull(customerEo.getLevelId()) && Objects.nonNull(customerLevelEo = (DgCustomerLevelEo)this.iDgCustomerLevelDomain.selectByPrimaryKey(customerEo.getLevelId()))) {
            customerRespDto.setLevelName(customerLevelEo.getName());
        }
        if (Objects.nonNull(customerEo.getStatusId()) && Objects.nonNull(customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(customerEo.getStatusId()))) {
            customerRespDto.setStatusName(customerStatusEo.getName());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billRespDtoList = this.billInfoService.queryBillInfoByCustomerId(customerRespDto.getId()))) {
            customerRespDto.setBillInfoRespDtoList(billRespDtoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contactsInfoRespDtoList = this.contactsInfoService.queryContactsInfoListByCustomerId(customerRespDto.getId()))) {
            customerRespDto.setContactsInfoRespDtoList(contactsInfoRespDtoList);
        }
        return customerRespDto;
    }

    @Override
    public DgCustomerRespDto queryByCode(String code) {
        List<DgContactsInfoRespDto> contactsInfoRespDtoList;
        DgCustomerEo selectItemCustomer = new DgCustomerEo();
        selectItemCustomer.setCode(code);
        List customerEos = this.iDgCustomerDomain.selectList((BaseEo)selectItemCustomer);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            return null;
        }
        DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)customerEos.get(0)), (BaseVo)customerRespDto);
        List<DgBillInfoRespDto> billRespDtoList = this.billInfoService.queryBillInfoByCustomerId(customerRespDto.getId());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billRespDtoList)) {
            customerRespDto.setBillInfoRespDtoList(billRespDtoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contactsInfoRespDtoList = this.contactsInfoService.queryContactsInfoListByCustomerId(customerRespDto.getId()))) {
            customerRespDto.setContactsInfoRespDtoList(contactsInfoRespDtoList);
        }
        return customerRespDto;
    }

    @Override
    public PageInfo<DgCustomerRespDto> queryByPageOnPost(DgCustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        return this.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
    }

    @Override
    public PageInfo<DgCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        DgCustomerSearchReqDto searchReqDto = new DgCustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (DgCustomerSearchReqDto)JSONObject.parseObject((String)filter, DgCustomerSearchReqDto.class);
        }
        List<Object> idList = new ArrayList();
        if (searchReqDto.getIsFilterDownstreamCustomersByCurrentUser().booleanValue()) {
            idList = this.getDownstreamCustomerIdsByCurrentUser();
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getIdList())) {
                idList.retainAll(searchReqDto.getIdList());
            }
        } else if (CollUtil.isNotEmpty((Collection)searchReqDto.getIdList())) {
            idList = searchReqDto.getIdList();
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List<String> regionCodeList = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            selectEo.setDr(CommonConstants.Dr.NO);
            List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
            List customerIdList = customerRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).distinct().collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            if (CollUtil.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.equals(searchReqDto.getOrgFilter(), 1)) {
            Long currentUserOrgId = this.iCustomerExtService.getCurrentUserOrgId();
            if (Objects.isNull(currentUserOrgId)) {
                return new PageInfo();
            }
            Integer adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", this.iContext.userId() + "", Integer.class);
            this.setMerchantIds(searchReqDto, currentUserOrgId);
            if (Objects.isNull(adminFlag)) {
                searchReqDto.setSalesmanUserId(this.iContext.userId());
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanUserId())) {
            List<Long> customerIdList = this.getCurrentUserOrOrgCustomer(searchReqDto.getSalesmanUserId(), null, false);
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            eo.setDr(CommonConstants.Dr.NO);
            List eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            List customerIdList = eos.stream().map(DgRCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getCustomerGroupIds())) {
            ArrayList<Long> allCustomerGroupIds = new ArrayList<Long>();
            for (Long groupId : searchReqDto.getCustomerGroupIds()) {
                allCustomerGroupIds.add(groupId);
                this.iDgCustomerGroupDomain.getChildCustomerGroupId(groupId, allCustomerGroupIds);
            }
            searchReqDto.setCustomerGroupIds(allCustomerGroupIds);
        }
        List idNotInList = searchReqDto.getIdNotInList();
        if (CollUtil.isNotEmpty(idList) && CollUtil.isNotEmpty((Collection)idNotInList)) {
            idList.removeAll(idNotInList);
            if (CollUtil.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdNotInList(null);
        }
        searchReqDto.setIdList(idList);
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        if (Objects.nonNull(pageInfo = this.iDgCustomerDomain.queryPageBySearchCon(pageNum, pageSize, searchReqDto)) && !org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List rCustomerRegionEos = this.iDgRCustomerRegionDomain.selectCodeByCusList(pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            Map<Object, Object> idRegionCodeMap = new HashMap(0);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerRegionEos)) {
                idRegionCodeMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(DgRCustomerRegionEo::getCustomerId, Collectors.mapping(DgRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List regionCodes = rCustomerRegionEos.stream().map(DgRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.iDgCustomerTypeDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, DgCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(DgCustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, DgCustomerTypeEo::getName)));
            CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.iDgCustomerStatusDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(DgCustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
            CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.iDgCustomerLevelDomain.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, DgCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(DgCustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, DgCustomerLevelEo::getName)));
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)regionCodes)) {
                    return new HashMap(0);
                }
                DgCustomerAreaListReqDto customerAreaListReqDto = new DgCustomerAreaListReqDto();
                customerAreaListReqDto.setCodes(regionCodes);
                return this.customerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(DgCustomerAreaRespDto::getCode, DgCustomerAreaRespDto::getName, (o, o1) -> o));
            });
            CompletableFuture<Map> customerNameMapFuture = CompletableFuture.supplyAsync(() -> Optional.of(pageInfo.getList().stream().map(DgCustomerRespDto::getParentCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).map(parentIds -> this.iDgCustomerDomain.queryListByIds(parentIds).stream().collect(Collectors.toMap(DgCustomerNameSimpleRespDto::getId, DgCustomerNameSimpleRespDto::getName))).orElse(new HashMap(0)));
            CompletableFuture<Map> groupNameMapFuture = CompletableFuture.supplyAsync(() -> {
                List groupIds = pageInfo.getList().stream().map(DgCustomerRespDto::getCustomerGroupId).distinct().collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(groupIds)) {
                    return new HashMap(0);
                }
                return this.iDgCustomerGroupDomain.selectByIds(groupIds).stream().collect(Collectors.toMap(BaseEo::getId, DgCustomerGroupEo::getGroupName));
            });
            CompletableFuture.allOf(customerNameMapFuture, levelMapFuture, statusMapFuture, typeMapFuture, groupNameMapFuture, regionNameMapFuture);
            Map customerNameMap = new HashMap(0);
            Map groupNameMap = new HashMap(0);
            Map regionNameMap = new HashMap(0);
            Map levelMap = new HashMap(0);
            Map statusMap = new HashMap(0);
            Map typeMap = new HashMap(0);
            try {
                regionNameMap = regionNameMapFuture.get();
                customerNameMap = customerNameMapFuture.get();
                groupNameMap = groupNameMapFuture.get();
                levelMap = levelMapFuture.get();
                statusMap = statusMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (DgCustomerRespDto customerRespDto : pageInfo.getList()) {
                DgCustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new DgCustomerStatusEo());
                customerRespDto.setAccountStatus(statusEo.getAccountStatus());
                customerRespDto.setRecordStatus(statusEo.getRecordStatus());
                customerRespDto.setStatusName(statusEo.getName());
                customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
                customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
                customerRespDto.setRegionCodes((String)idRegionCodeMap.get(customerRespDto.getId()));
                if (customerRespDto.getParentCustomerId() != null) {
                    customerRespDto.setParentCustomerName(customerNameMap.getOrDefault(customerRespDto.getParentCustomerId(), ""));
                }
                if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
                    customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
                } else {
                    customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
                }
                if (null != customerRespDto.getCustomerGroupId()) {
                    customerRespDto.setCustomerGroupName(groupNameMap.getOrDefault(customerRespDto.getCustomerGroupId(), ""));
                }
                if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) continue;
                ArrayList regionNameList = new ArrayList();
                for (String code : customerRespDto.getRegionCodes().split(",")) {
                    regionNameList.add(regionNameMap.get(code));
                }
                customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
            }
        }
        return pageInfo;
    }

    private void setMerchantIds(DgCustomerSearchReqDto searchReqDto, Long currentUserOrgId) {
        if (Objects.nonNull(searchReqDto.getChannel())) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.iDgCustomerDomain.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(DgCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        } else {
            searchReqDto.setMerchantIds((List)Lists.newArrayList((Object[])new Long[]{currentUserOrgId}));
        }
    }

    @Override
    public List<Long> getCurrentUserOrOrgCustomer(Long userId, Long orgId, boolean filterOrg) {
        if (filterOrg && Objects.isNull(orgId)) {
            orgId = this.iCustomerExtService.getCurrentUserOrgId();
        }
        if (Objects.isNull(orgId) && Objects.isNull(userId)) {
            return Lists.newArrayList();
        }
        Set realSalesmanIds = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgCustomerSalesmanDomain.filter().select(new String[]{"id"}).eq((Object)"status", (Object)1)).eq(Objects.nonNull(userId), (Object)"user_id", (Object)userId)).eq(Objects.nonNull(orgId), (Object)"org_info_id", (Object)orgId)).list().stream().map(BaseEo::getId).collect(Collectors.toSet());
        if (org.springframework.util.CollectionUtils.isEmpty(realSalesmanIds)) {
            return Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgRCustomerSalesmanDomain.filter().select(new String[]{"customer_id"}).in((Object)"salesman_id", realSalesmanIds)).eq(Objects.nonNull(orgId), (Object)"org_id", (Object)orgId)).list().stream().map(DgRCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
    }

    private List<Long> getDownstreamCustomerIdsByCurrentUser() {
        Long currentUserOrgId = this.iCustomerExtService.getCurrentUserOrgId();
        List<Long> longs = this.iCustomerExtService.queryDownstreamCustomerIdsByOrgIds(Collections.singletonList(currentUserOrgId));
        return new ArrayList<Long>(longs);
    }

    @Override
    public List<DgCustomerRespDto> queryByList(String filter) {
        DgCustomerSearchReqDto searchReqDto = new DgCustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (DgCustomerSearchReqDto)JSONObject.parseObject((String)filter, DgCustomerSearchReqDto.class);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            DgRCustomerRegionEo selectEo = new DgRCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", (Object)StringUtils.join((Iterable)searchReqDto.getRegionCodes(), (String)",")));
            selectEo.setSqlFilters(sqlFilters);
            selectEo.setDr(CommonConstants.Dr.NO);
            List customerRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        List customerList = this.iDgCustomerDomain.queryListBySearchCon(searchReqDto);
        return customerList;
    }

    @Override
    public void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        DgRCustomerRegionEo sourceSelectEo = new DgRCustomerRegionEo();
        sourceSelectEo.setRegionCode(sourceRegionCode);
        sourceSelectEo.setDr(CommonConstants.Dr.NO);
        List sourceRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)sourceSelectEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)sourceRegionEos)) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getCode(), DgCustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getMsg());
        }
        DgRCustomerRegionEo targetSelectEo = new DgRCustomerRegionEo();
        targetSelectEo.setRegionCode(targetRegionCode);
        targetSelectEo.setDr(CommonConstants.Dr.NO);
        List targetRegionEos = this.iDgRCustomerRegionDomain.selectList((BaseEo)targetSelectEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)targetRegionEos)) {
            this.iDgCustomerDomain.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
        } else {
            List sourceCustomerIds = sourceRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            List targetCustomerIds = targetRegionEos.stream().map(DgRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            sourceCustomerIds.retainAll(targetCustomerIds);
            if (org.springframework.util.CollectionUtils.isEmpty(sourceCustomerIds)) {
                this.iDgCustomerDomain.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
            } else {
                this.iDgCustomerDomain.updateByRegionCodeAndOutCustomerId(sourceRegionCode, targetRegionCode, sourceCustomerIds);
                DgRCustomerRegionEo deleteEo = new DgRCustomerRegionEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)StringUtils.join(sourceCustomerIds, (String)",")));
                deleteEo.setSqlFilters(sqlFilters);
                deleteEo.setRegionCode(sourceRegionCode);
                this.iDgRCustomerRegionDomain.delete((BaseEo)deleteEo);
            }
        }
    }

    private void validCustomerName(DgCustomerReqDto reqDto) {
        Assert.hasText((String)reqDto.getName(), (String)DgCustomerExceptionCode.NAME_NULL.getMsg());
        DgCustomerEo eo = new DgCustomerEo();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        eo.setDr(CommonConstants.Dr.NO);
        List customerEos = this.iDgCustomerDomain.selectList((BaseEo)eo);
        if (reqDto.getId() == null && !org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (reqDto.getId() != null && !org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos) && !((DgCustomerEo)customerEos.get(0)).getId().equals(reqDto.getId())) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
    }

    private void initCustomerEo(DgCustomerReqDto reqDto, DgCustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
    }

    private void validCustomerCode(DgCustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.hasText((String)reqDto.getCode(), (String)DgCustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg());
            DgCustomerEo customerEo = new DgCustomerEo();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        } else {
            Assert.hasText((String)reqDto.getCode(), (String)DgCustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg());
            Assert.hasText((String)reqDto.getName(), (String)DgCustomerExceptionCode.CUSTOMER_NAME_NULL.getMsg());
        }
    }

    @Override
    public Integer countByCustomerTypeId(Long customerTypeId) {
        return this.iDgCustomerDomain.countByCustomerTypeId(customerTypeId);
    }

    @Override
    public void updateCustomerTypeId(Long originCustomerTypeId, Long finalCustomerTypeId) {
        DgCustomerMapper mapper = (DgCustomerMapper)this.iDgCustomerDomain.getMapper();
        mapper.updateCustomerTypeId(originCustomerTypeId, finalCustomerTypeId);
    }

    @Override
    public PageInfo<DgCustomerTypeEo> queryCustomerTypeByPage(Integer pageNum, Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        DgCustomerTypeEo customerTypeEo = new DgCustomerTypeEo();
        customerTypeEo.setOrderBy("sort");
        return this.iDgCustomerTypeDomain.selectPage((BaseEo)customerTypeEo, pageNum, pageSize);
    }

    @Override
    @Transactional
    public void updateAccountStatus(DgCustomerReqDto DgCustomerReqDto2) {
        DgCustomerEo customerEo = new DgCustomerEo();
        if (null != DgCustomerReqDto2.getId()) {
            customerEo.setId(DgCustomerReqDto2.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)DgCustomerReqDto2.getCode())) {
            customerEo.setCode(DgCustomerReqDto2.getCode());
        }
        customerEo.setDr(CommonConstants.Dr.NO);
        List customerEos = this.iDgCustomerDomain.selectList((BaseEo)customerEo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), DgCustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        }
        DgCustomerEo newCustomerEo = (DgCustomerEo)customerEos.get(0);
        newCustomerEo.setStatusId(DgCustomerReqDto2.getStatusId());
        newCustomerEo.setUserId(null != DgCustomerReqDto2.getUserId() ? DgCustomerReqDto2.getUserId() : newCustomerEo.getUserId());
        this.iDgCustomerDomain.update((BaseEo)newCustomerEo);
        this.sendMq(newCustomerEo, "", "");
    }

    @Override
    public void saveCustomerExportRecord(DgExportRecordReqDto reqDto) {
        Assert.isTrue((reqDto != null ? 1 : 0) != 0, (String)"\u5ba2\u5546\u5bfc\u51fa\u8bb0\u5f55\u4e3a\u7a7a");
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        DgCustomerExportRecordEo exportRecordEo = new DgCustomerExportRecordEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)exportRecordEo);
        this.iDgCustomerExportRecordDomain.insert((BaseEo)exportRecordEo);
    }

    @Override
    public List<DgCustomerNameSimpleRespDto> queryListByIds(List<Long> ids) {
        return this.iDgCustomerDomain.queryListByIds(ids);
    }
}

