/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerStatusDomain;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerBusinessRuntimeException;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerStatusReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerStatusRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerStatusEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerStatusService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="dgCustomerStatusService")
public class DgCustomerStatusServiceImpl
implements IDgCustomerStatusService {
    @Resource
    private IDgCustomerStatusDomain iDgCustomerStatusDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(DgCustomerStatusReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        reqDto.setId(null);
        if (reqDto.getRecordStatus() == null) {
            reqDto.setRecordStatus(Integer.valueOf(1));
        }
        this.validCustomerStatusName(reqDto);
        this.validCustomerStatusCode(reqDto, reqDto.getTenantId());
        DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
        this.initCustomerStatusEo(reqDto, customerStatusEo);
        this.iDgCustomerStatusDomain.insert((BaseEo)customerStatusEo);
        return customerStatusEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRecordStatus(Long id, Integer recordStatus) {
        DgCustomerStatusEo queryEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(id);
        Assert.notNull((Object)queryEo, (String)DgCustomerExceptionCode.CUSTOMER_STATUS_NON_EXIST.getMsg());
        DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
        customerStatusEo.setId(id);
        customerStatusEo.setRecordStatus(recordStatus);
        this.iDgCustomerStatusDomain.updateSelective((BaseEo)customerStatusEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DgCustomerStatusReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        Assert.notNull((Object)reqDto.getId(), (String)DgCustomerExceptionCode.PK_ID_NULL.getMsg());
        DgCustomerStatusEo queryEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)DgCustomerExceptionCode.CUSTOMER_STATUS_NON_EXIST.getMsg());
        this.validCustomerStatusName(reqDto);
        this.validCustomerStatusCode(reqDto, reqDto.getTenantId());
        DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
        this.initCustomerStatusEo(reqDto, customerStatusEo);
        this.iDgCustomerStatusDomain.updateSelective((BaseEo)customerStatusEo);
    }

    @Override
    public DgCustomerStatusRespDto queryById(Long id) {
        DgCustomerStatusEo customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(id);
        Assert.notNull((Object)customerStatusEo, (String)DgCustomerExceptionCode.CUSTOMER_STATUS_NON_EXIST.getMsg());
        DgCustomerStatusRespDto DgCustomerStatusRespDto2 = new DgCustomerStatusRespDto();
        DtoHelper.eo2Dto((BaseEo)customerStatusEo, (BaseVo)DgCustomerStatusRespDto2);
        return DgCustomerStatusRespDto2;
    }

    @Override
    public PageInfo<DgCustomerStatusRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            DgCustomerStatusReqDto customerStatusReqDto = (DgCustomerStatusReqDto)JSONObject.parseObject((String)filter, DgCustomerStatusReqDto.class);
            DtoHelper.dto2Eo((BaseVo)customerStatusReqDto, (BaseEo)customerStatusEo);
        }
        customerStatusEo.setDr(CommonConstants.Dr.NO);
        customerStatusEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageInfo pageInfo = this.iDgCustomerStatusDomain.selectPage((BaseEo)customerStatusEo, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)respDtoList, DgCustomerStatusRespDto.class);
        respDtoPageInfo.setList((List)respDtoList);
        return respDtoPageInfo;
    }

    @Override
    public List<DgCustomerStatusRespDto> queryByList(String filter) {
        DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            DgCustomerStatusReqDto customerStatusReqDto = (DgCustomerStatusReqDto)JSONObject.parseObject((String)filter, DgCustomerStatusReqDto.class);
            DtoHelper.dto2Eo((BaseVo)customerStatusReqDto, (BaseEo)customerStatusEo);
        }
        customerStatusEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        customerStatusEo.setDr(CommonConstants.Dr.NO);
        List customerStatusEoList = this.iDgCustomerStatusDomain.selectList((BaseEo)customerStatusEo);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerStatusEoList, (Collection)respDtoList, DgCustomerStatusRespDto.class);
        return respDtoList;
    }

    @Override
    public List<DgCustomerStatusRespDto> queryByParams(DgCustomerStatusReqDto reqDto) {
        DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
        if (null != reqDto) {
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerStatusEo);
        }
        customerStatusEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        customerStatusEo.setDr(CommonConstants.Dr.NO);
        List customerStatusEoList = this.iDgCustomerStatusDomain.selectList((BaseEo)customerStatusEo);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerStatusEoList, (Collection)respDtoList, DgCustomerStatusRespDto.class);
        return respDtoList;
    }

    private void validCustomerStatusName(DgCustomerStatusReqDto reqDto) {
        Assert.hasText((String)reqDto.getName(), (String)DgCustomerExceptionCode.NAME_NULL.getMsg());
        DgCustomerStatusEo eo = new DgCustomerStatusEo();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        eo.setDr(CommonConstants.Dr.NO);
        if (reqDto.getId() == null) {
            if (this.iDgCustomerStatusDomain.count((BaseEo)eo) > 0) {
                throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
            }
        } else {
            Long supplierId = reqDto.getId();
            List customerStatusEos = this.iDgCustomerStatusDomain.selectList((BaseEo)eo);
            if (!CollectionUtils.isEmpty((Collection)customerStatusEos)) {
                if (customerStatusEos.size() == 1) {
                    if (!((DgCustomerStatusEo)customerStatusEos.get(0)).getId().equals(supplierId)) {
                        throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
                    }
                } else {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.NAME_EXISTS.getCode(), DgCustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
                }
            }
        }
    }

    private void initCustomerStatusEo(DgCustomerStatusReqDto reqDto, DgCustomerStatusEo customerStatusEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerStatusEo);
    }

    private void validCustomerStatusCode(DgCustomerStatusReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.hasText((String)reqDto.getCode(), (String)DgCustomerExceptionCode.CUSTOMER_STATUS_CODE_NULL.getMsg());
            DgCustomerStatusEo customerStatusEo = new DgCustomerStatusEo();
            customerStatusEo.setTenantId(tenantId);
            customerStatusEo.setCode(reqDto.getCode());
            customerStatusEo.setDr(CommonConstants.Dr.NO);
            customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectOne((BaseEo)customerStatusEo);
            if (customerStatusEo != null) {
                if (reqDto.getId() == null) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_STATUS_CODE_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerStatusEo.getId().equals(reqDto.getId())) {
                    throw new DgCustomerBusinessRuntimeException(DgCustomerExceptionCode.CUSTOMER_STATUS_CODE_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }
}

