/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.das.ComBaseDas;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MybatisPlusUtils {
    private static final Integer DR_0 = 0;

    public static <DTO extends BaseVo, EO extends BaseEo> LambdaQueryWrapper<EO> newLambdaQueryWrapper(DTO dto, Class<EO> eoClass) {
        BaseEo eo = null;
        try {
            eo = (BaseEo)eoClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DtoHelper.dto2Eo(dto, (BaseEo)eo);
        return MybatisPlusUtils.newLambdaQueryWrapper(eo);
    }

    public static <EO extends BaseEo> LambdaQueryWrapper<EO> newLambdaQueryWrapper(EO eo) {
        if (Objects.nonNull(eo)) {
            eo.setDr(DR_0);
        }
        return Wrappers.lambdaQuery(eo);
    }

    public static <T extends BaseEo> LambdaQueryWrapper<T> lambdaQuery(Class<T> t) {
        return (LambdaQueryWrapper)Wrappers.lambdaQuery(t).eq(BaseEo::getDr, (Object)CommonConstants.Dr.NO);
    }

    public static <T extends BaseEo> LambdaUpdateWrapper<T> lambdaUpdate(Class<T> t) {
        return Wrappers.lambdaUpdate(t);
    }

    public static <DAS extends ComBaseDas, EO extends BaseEo> boolean checkUnique(DAS das, EO eo) {
        Integer count;
        eo.setDr(DR_0);
        LambdaQueryWrapper<EO> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(eo);
        if (Objects.nonNull(eo.getId())) {
            queryWrapper.ne(BaseEo::getId, (Object)eo.getId());
            eo.setId(null);
        }
        return !Objects.nonNull(count = das.getMapper().selectCount(queryWrapper)) || count <= 0;
    }

    public static <Domain extends IBaseDomain, EO extends BaseEo> boolean checkUnique(Domain domain, EO eo) {
        Integer count;
        eo.setDr(DR_0);
        LambdaQueryWrapper<EO> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(eo);
        if (Objects.nonNull(eo.getId())) {
            queryWrapper.ne(BaseEo::getId, (Object)eo.getId());
            eo.setId(null);
        }
        return !Objects.nonNull(count = domain.getMapper().selectCount(queryWrapper)) || count <= 0;
    }

    public static <Domain extends IBaseDomain, EO extends BaseEo> void checkUnique(Domain domain, EO eo, IExceptionCode exp) {
        if (!MybatisPlusUtils.checkUnique(domain, eo)) {
            BizExceptionHelper.throwBizException((IExceptionCode)exp);
        }
    }

    public static <DAS extends ComBaseDas, EO extends BaseEo> void checkUnique(DAS das, EO eo, IExceptionCode exp) {
        if (!MybatisPlusUtils.checkUnique(das, eo)) {
            BizExceptionHelper.throwBizException((IExceptionCode)exp);
        }
    }

    public static <DAS extends ComBaseDas, EO extends BaseEo> void checkUnique(DAS das, EO eo, String code, String msg) {
        if (!MybatisPlusUtils.checkUnique(das, eo)) {
            BizExceptionHelper.throwBizException((String)code, (String)msg);
        }
    }

    public static <DOMAIN extends IBaseDomain, EO extends BaseEo> void checkUnique(DOMAIN domain, EO eo, String code, String msg) {
        if (!MybatisPlusUtils.checkUnique(domain, eo)) {
            BizExceptionHelper.throwBizException((String)code, (String)msg);
        }
    }

    public static <DAS extends ComBaseDas, EO extends BaseEo> void checkUnique(DAS das, EO eo, BizException bizException) {
        if (!MybatisPlusUtils.checkUnique(das, eo)) {
            if (Objects.isNull(bizException)) {
                BizExceptionHelper.throwBizException((String)"20001", (String)"\u975e\u552f\u4e00\u6027");
            }
            BizExceptionHelper.throwBizException((String)bizException.getCode(), (String)bizException.getMessage());
        }
    }

    public static <DAS extends ComBaseDas, EO extends BaseEo, VO extends BaseVo> PageInfo<VO> selectPage(DAS das, EO eo, Class<VO> voClass, Integer pageNum, Integer pageSize) {
        pageNum = Objects.isNull(pageNum) || pageNum <= 0 ? 1 : pageNum;
        pageSize = Objects.isNull(pageSize) || pageSize <= 0 ? 10 : pageSize;
        PageInfo pageInfo = das.selectPage(eo, pageNum, pageSize);
        ArrayList list = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), list, voClass);
        pageInfo.setList(list);
        return pageInfo;
    }

    public static <Domain extends IBaseDomain, EO extends BaseEo, VO extends BaseVo> PageInfo<VO> selectPage(Domain domain, EO eo, Class<VO> voClass, Integer pageNum, Integer pageSize) {
        pageNum = Objects.isNull(pageNum) || pageNum <= 0 ? 1 : pageNum;
        pageSize = Objects.isNull(pageSize) || pageSize <= 0 ? 10 : pageSize;
        PageInfo pageInfo = domain.selectPage(eo, pageNum, pageSize);
        ArrayList list = new ArrayList(pageInfo.getList().size());
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), list, voClass);
        pageInfo.setList(list);
        return pageInfo;
    }

    public static <Domain extends IBaseDomain, EO extends BaseEo, VO extends BaseVo> PageInfo<VO> selectPage(Domain domain, Wrapper<EO> queryWrapper, Class<VO> voClass, Integer pageNum, Integer pageSize) {
        pageNum = Objects.isNull(pageNum) || pageNum <= 0 ? 1 : pageNum;
        pageSize = Objects.isNull(pageSize) || pageSize <= 0 ? 10 : pageSize;
        IPage page = domain.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), queryWrapper);
        List records = page.getRecords();
        ArrayList list = new ArrayList(records.size());
        DtoHelper.eoList2DtoList((Collection)records, list, voClass);
        PageInfo pageInfo = new PageInfo(list);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        return pageInfo;
    }

    public static <DAS extends ComBaseDas, EO extends BaseEo, VO extends BaseVo> PageInfo<VO> selectPage(DAS das, Wrapper<EO> queryWrapper, Class<VO> voClass, Integer pageNum, Integer pageSize) {
        pageNum = Objects.isNull(pageNum) || pageNum <= 0 ? 1 : pageNum;
        pageSize = Objects.isNull(pageSize) || pageSize <= 0 ? 10 : pageSize;
        IPage page = das.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), queryWrapper);
        List records = page.getRecords();
        ArrayList list = new ArrayList(records.size());
        DtoHelper.eoList2DtoList((Collection)records, list, voClass);
        PageInfo pageInfo = new PageInfo(list);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        return pageInfo;
    }

    public static <EO extends BaseEo> void setCommonInfo(EO eo) {
        if (Objects.isNull(eo.getDr())) {
            eo.setDr(DR_0);
        }
        if (Objects.isNull(eo.getTenantId())) {
            eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        if (Objects.isNull(eo.getInstanceId())) {
            eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        }
    }
}

