/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.api.IDgCustomerDataApi;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerImportLogDomain;
import com.yunxi.dg.base.center.customer.dto.enums.ImportStatusEnum;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerImportLogSearchReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerImportSaveReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgImportUpdateReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerImportLogRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerImportLogEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerImportLogQueryService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DgCustomerDataApiImpl
implements IDgCustomerDataApi {
    private static final Logger logger = LoggerFactory.getLogger(DgCustomerDataApiImpl.class);
    @Autowired
    private IDgCustomerImportLogDomain iDgCustomerImportLogDomain;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private IDgCustomerImportLogQueryService iDgCustomerImportLogQueryService;

    public RestResponse<Long> saveCustomerInfoImport(DgCustomerImportSaveReqDto customerImportSaveReqDto) {
        if (null == customerImportSaveReqDto.getUrl() || null == customerImportSaveReqDto.getImportType()) {
            return new RestResponse("100000", "url\u8def\u5f84\u6216\u5bfc\u5165\u7c7b\u578b\u4e3a\u7a7a");
        }
        DgCustomerImportLogEo customerImportLogEo = new DgCustomerImportLogEo();
        customerImportLogEo.setImportFileName(customerImportSaveReqDto.getFileName());
        customerImportLogEo.setStatus(ImportStatusEnum.LOADING.getCode());
        customerImportLogEo.setImportType(customerImportSaveReqDto.getImportType());
        customerImportLogEo.setCreatePerson(customerImportSaveReqDto.getOperator());
        customerImportLogEo.setRemark("\u5bfc\u5165\u7684url" + customerImportSaveReqDto.getUrl());
        DtoHelper.dto2Eo((BaseVo)customerImportSaveReqDto, (BaseEo)customerImportLogEo);
        this.iDgCustomerImportLogDomain.insert((BaseEo)customerImportLogEo);
        return new RestResponse((Object)customerImportLogEo.getId());
    }

    public RestResponse<Void> update(DgImportUpdateReqDto sourceCustomerImportSaveReqDto) {
        if (null == sourceCustomerImportSaveReqDto.getId()) {
            return new RestResponse("100000", "\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DgCustomerImportLogEo newCustomerImportLogEo = new DgCustomerImportLogEo();
        newCustomerImportLogEo.setId(sourceCustomerImportSaveReqDto.getId());
        DgCustomerImportLogEo oldCustomerImportLogEo = (DgCustomerImportLogEo)this.iDgCustomerImportLogDomain.selectOne((BaseEo)newCustomerImportLogEo);
        if (oldCustomerImportLogEo == null) {
            throw new BizException("\u4e3b\u952eID\u627e\u4e0d\u5230\u5bfc\u5165\u8bb0\u5f55");
        }
        DtoHelper.dto2Eo((BaseVo)sourceCustomerImportSaveReqDto, (BaseEo)oldCustomerImportLogEo);
        this.iDgCustomerImportLogDomain.updateSelective((BaseEo)oldCustomerImportLogEo);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<DgCustomerImportLogRespDto>> queryCustomerImportLogPage(DgCustomerImportLogSearchReqDto customerImportLogSearchReqDto) {
        RestResponse pageInfoRestResponse = new RestResponse(this.iDgCustomerImportLogQueryService.queryMemberImportLogPage(customerImportLogSearchReqDto));
        List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
        for (DgCustomerImportLogRespDto customerImportLogRespDto : list) {
            customerImportLogRespDto.setImportStatusName(ImportStatusEnum.toName((Integer)customerImportLogRespDto.getStatus()));
        }
        return pageInfoRestResponse;
    }
}

