/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryTotalDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.LogicSupplyInventoryVo;
import com.yunxi.dg.base.center.inventory.dto.response.InventoryStatisticNumVo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicInventoryTotalDomainImpl
extends BaseDomainImpl<LogicInventoryTotalEo>
implements ILogicInventoryTotalDomain {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryTotalDomainImpl.class);
    @Autowired
    ILogicInventoryTotalDas das;
    @Autowired
    DataSource dataSource;
    @Autowired
    ICacheService cacheService;

    public ICommonDas<LogicInventoryTotalEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicInventoryTotalEo> queryByWarehouseCodesAndSkuCodes(List<String> warehouseCodes, List<String> skuCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).in(LogicInventoryTotalEo::getWarehouseCode, warehouseCodes)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryTotalEo::getSkuCode, skuCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        log.info("updateInventory-voList:{}", (Object)JSON.toJSONString(voList));
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        try {
            this.das.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic total updateInventory exception:{}", (Object)JSON.toJSONString((Object)e));
            throw new WarehouseAbleException("logic total updateInventory exception...", new Object[0]);
        }
    }

    @Override
    public int batchIgnoreInsert(List<LogicInventoryTotalEo> eoList) {
        try {
            return this.das.batchIgnoreInsert(eoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic total insert exception...");
            throw new WarehouseAbleException("logic total insert exception...", new Object[0]);
        }
    }

    @Override
    public List<LogicInventoryTotalEo> batchIgnoreInsertNew(List<LogicInventoryTotalEo> eoList) {
        Map inventoryEoMap = eoList.stream().collect(Collectors.toMap(this::getTotalKey, Function.identity(), (o, o1) -> o));
        List<LogicInventoryTotalEo> inventoryEos = inventoryEoMap.entrySet().stream().filter(r -> {
            String key = (String)r.getKey();
            if (this.cacheService.setIfAbsent(LogicInventoryTotalDomainImpl.getFilterCacheKey() + key, (Object)((LogicInventoryTotalEo)r.getValue()).getId()).booleanValue()) {
                this.cacheService.setCache(LogicInventoryTotalDomainImpl.getWaitProcessKey() + key, (Object)JSONObject.toJSONString(r.getValue()));
                return true;
            }
            return false;
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inventoryEos)) {
            return inventoryEos;
        }
        log.info("\u8fdb\u5165\u4fdd\u5b58:{}", (Object)JSONObject.toJSONString(inventoryEos));
        this.doBatchInsert(inventoryEos);
        return inventoryEos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchInsert(List<LogicInventoryTotalEo> inventoryEos) {
        try {
            connection.setAutoCommit(false);
            try (Connection connection = this.dataSource.getConnection();){
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("INSERT INTO cs_logic_inventory_total (").append("`id`, `warehouse_id`, `warehouse_code`, `warehouse_name`, ").append("`sku_code`, `sku_name`, ").append("`balance`, `preempt`, `allocate`, `activity_allocate`, `intransit`, `transfer`, `completed`, `future_in`, `future_retreat`, `available`, `lock_inventory`, ").append("`remark`, ").append("`tenant_id`, `instance_id`, `extension`, `create_person`, `create_time`, `update_person`, `update_time`, `dr`").append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, -1, -1, null, ?, now(), ?, now(), 0)");
                int i = this.executeInsert(inventoryEos, connection, sqlBuilder);
                log.debug("\u5904\u7406\u6210\u529f\u6570\u91cf" + i);
                connection.commit();
                inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryTotalDomainImpl.getWaitProcessKey() + LogicInventoryTotalDomainImpl.getFilterCacheKey() + this.getTotalKey((LogicInventoryTotalEo)r)));
            }
        }
        catch (SQLException e) {
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryTotalDomainImpl.getFilterCacheKey() + this.getTotalKey((LogicInventoryTotalEo)r)));
            throw new BizException(e.getMessage());
        }
    }

    @NotNull
    private String getTotalKey(LogicInventoryTotalEo r) {
        return String.join((CharSequence)"__", r.getWarehouseCode(), r.getSkuCode());
    }

    private int executeInsert(List<LogicInventoryTotalEo> eoList, Connection connection, StringBuilder sqlBuilder) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sqlBuilder.toString());
        for (LogicInventoryTotalEo eo : eoList) {
            int index = 1;
            preparedStatement.setLong(index++, eo.getId());
            preparedStatement.setLong(index++, eo.getWarehouseId());
            preparedStatement.setString(index++, eo.getWarehouseCode());
            preparedStatement.setString(index++, eo.getWarehouseName());
            preparedStatement.setString(index++, eo.getSkuCode());
            preparedStatement.setString(index++, eo.getSkuName());
            preparedStatement.setBigDecimal(index++, eo.getBalance());
            preparedStatement.setBigDecimal(index++, eo.getPreempt());
            preparedStatement.setBigDecimal(index++, eo.getAllocate());
            preparedStatement.setBigDecimal(index++, eo.getActivityAllocate());
            preparedStatement.setBigDecimal(index++, eo.getIntransit());
            preparedStatement.setBigDecimal(index++, eo.getTransfer());
            preparedStatement.setBigDecimal(index++, eo.getCompleted());
            preparedStatement.setBigDecimal(index++, eo.getFutureIn());
            preparedStatement.setBigDecimal(index++, eo.getFutureRetreat());
            preparedStatement.setBigDecimal(index++, eo.getAvailable());
            preparedStatement.setBigDecimal(index++, eo.getLockInventory());
            preparedStatement.setString(index++, eo.getRemark());
            preparedStatement.setString(index++, eo.getCreatePerson());
            preparedStatement.setString(index, eo.getUpdatePerson());
            preparedStatement.addBatch();
        }
        int[] ints = preparedStatement.executeBatch();
        return Arrays.stream(ints).reduce(0, Integer::sum);
    }

    @NotNull
    private static String getWaitProcessKey() {
        return "waitTotalInit:";
    }

    @NotNull
    private static String getFilterCacheKey() {
        return "batchTotalIgnoreInsertNew:";
    }

    @Override
    public List<InventoryStatisticNumVo> queryLogicInventoryTotalBalance() {
        return this.das.queryLogicInventoryTotalBalance();
    }

    @Override
    public List<InventoryStatisticNumVo> queryInventoryTotalPreempt() {
        return this.das.queryInventoryTotalPreempt();
    }

    @Override
    public List<LogicSupplyInventoryVo> queryLogicSupplyInventory(List<String> warehouseCodes, List<String> cargoCodes) {
        return this.das.queryLogicSupplyInventory(warehouseCodes, cargoCodes);
    }

    @Override
    public void updateWarehouseNameByWarehouseCode(String warehouseCode, String warehouseName) {
        AssertUtils.notBlank((String)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)warehouseName, (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.das.updateWarehouseNameByWarehouseCode(warehouseCode, warehouseName);
    }

    private /* synthetic */ void lambda$doBatchInsert$3(LogicInventoryTotalEo r) {
        this.cacheService.delCache(LogicInventoryTotalDomainImpl.getFilterCacheKey() + this.getTotalKey(r));
    }
}

