/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryDas;
import com.yunxi.dg.base.center.inventory.dao.vo.InventoryWarehouseVo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicInventoryDomainImpl
extends BaseDomainImpl<LogicInventoryEo>
implements ILogicInventoryDomain {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryDomainImpl.class);
    @Autowired
    ILogicInventoryDas das;
    @Autowired
    DataSource dataSource;
    @Autowired
    ICacheService cacheService;

    public ICommonDas<LogicInventoryEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicInventoryEo> queryByWarehouseCodesAndSkuCodesAndBatches(List<String> warehouseCodes, List<String> skuCodes, List<String> batches) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseCode, warehouseCodes)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryEo::getSkuCode, skuCodes)).in(CollectionUtil.isNotEmpty(batches), LogicInventoryEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByAsc(LogicInventoryEo::getBatch));
    }

    @Override
    public List<LogicInventoryDto> queryInventoryList(LogicInventoryDto queryDto) {
        return this.das.queryInventoryList(queryDto);
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        try {
            voList = voList.stream().sorted(Comparator.comparing(CalcUpdateInventoryDto::getInventoryId)).collect(Collectors.toList());
            this.das.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic updateInventory exception...");
            throw new WarehouseAbleException("logic updateInventory exception...", new Object[0]);
        }
    }

    @Override
    public List<LogicInventoryEo> batchIgnoreInsertNew(List<LogicInventoryEo> eoList) {
        Map inventoryEoMap = eoList.stream().collect(Collectors.toMap(LogicInventoryDomainImpl::getBatchKey, Function.identity(), (o, o1) -> o));
        List<LogicInventoryEo> inventoryEos = inventoryEoMap.entrySet().stream().filter(r -> {
            String key = (String)r.getKey();
            if (this.cacheService.setIfAbsent(LogicInventoryDomainImpl.getFilterCacheKey() + key, (Object)((LogicInventoryEo)r.getValue()).getId()).booleanValue()) {
                this.cacheService.setCache(LogicInventoryDomainImpl.getWaitProcessKey() + key, (Object)JSONObject.toJSONString(r.getValue()));
                return true;
            }
            return false;
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inventoryEos)) {
            return inventoryEos;
        }
        log.info("\u8fdb\u5165\u4fdd\u5b58:{}", (Object)JSONObject.toJSONString(inventoryEos));
        this.doBatchInsert(inventoryEos);
        return inventoryEos;
    }

    @NotNull
    private static String getWaitProcessKey() {
        return "waitInit:";
    }

    @NotNull
    private static String getFilterCacheKey() {
        return "batchIgnoreInsertNew:";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchInsert(List<LogicInventoryEo> inventoryEos) {
        try {
            connection.setAutoCommit(false);
            try (Connection connection = this.dataSource.getConnection();){
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("INSERT INTO cs_logic_inventory (").append("`id`, `warehouse_id`, `warehouse_code`, `warehouse_name`, ").append("`sku_code`, `sku_name`, `batch`, `batch_type`, ").append("`balance`, `preempt`, `allocate`, `activity_allocate`, `intransit`, `transfer`, `completed`, `future_in`, `future_retreat`, `available`, `lock_inventory`, ").append("`remark`, `expire_time`, `produce_time`, ").append("`tenant_id`, `instance_id`, `extension`, `create_person`, `create_time`, `update_person`, `update_time`, `dr`").append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, -1, -1, null, ?, now(), ?, now(), 0)");
                int i = this.executeInsest(inventoryEos, connection, sqlBuilder);
                log.debug("\u5904\u7406\u6210\u529f\u6570\u91cf" + i);
                connection.commit();
                inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryDomainImpl.getWaitProcessKey() + LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r)));
            }
        }
        catch (SQLException e) {
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r)));
            throw new BizException(e.getMessage());
        }
    }

    @NotNull
    private static String getBatchKey(LogicInventoryEo r) {
        return r.getWarehouseCode() + "__" + r.getSkuCode() + "__" + r.getBatch();
    }

    private int executeInsest(List<LogicInventoryEo> eoList, Connection connection, StringBuilder sqlBuilder) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sqlBuilder.toString());
        for (LogicInventoryEo eo : eoList) {
            int index = 1;
            preparedStatement.setLong(index++, eo.getId());
            preparedStatement.setLong(index++, eo.getWarehouseId());
            preparedStatement.setString(index++, eo.getWarehouseCode());
            preparedStatement.setString(index++, eo.getWarehouseName());
            preparedStatement.setString(index++, eo.getSkuCode());
            preparedStatement.setString(index++, eo.getSkuName());
            preparedStatement.setString(index++, eo.getBatch());
            preparedStatement.setString(index++, eo.getBatchType());
            preparedStatement.setBigDecimal(index++, eo.getBalance());
            preparedStatement.setBigDecimal(index++, eo.getPreempt());
            preparedStatement.setBigDecimal(index++, eo.getAllocate());
            preparedStatement.setBigDecimal(index++, eo.getActivityAllocate());
            preparedStatement.setBigDecimal(index++, eo.getIntransit());
            preparedStatement.setBigDecimal(index++, eo.getTransfer());
            preparedStatement.setBigDecimal(index++, eo.getCompleted());
            preparedStatement.setBigDecimal(index++, eo.getFutureIn());
            preparedStatement.setBigDecimal(index++, eo.getFutureRetreat());
            preparedStatement.setBigDecimal(index++, eo.getAvailable());
            preparedStatement.setBigDecimal(index++, eo.getLockInventory());
            preparedStatement.setString(index++, eo.getRemark());
            preparedStatement.setTimestamp(index++, Optional.ofNullable(eo.getExpireTime()).map(r -> new Timestamp(eo.getExpireTime().getTime())).orElse(null));
            preparedStatement.setTimestamp(index++, Optional.ofNullable(eo.getProduceTime()).map(r -> new Timestamp(eo.getProduceTime().getTime())).orElse(null));
            preparedStatement.setString(index++, eo.getCreatePerson());
            preparedStatement.setString(index++, eo.getUpdatePerson());
            preparedStatement.addBatch();
        }
        int[] ints = preparedStatement.executeBatch();
        return Arrays.stream(ints).reduce(0, Integer::sum);
    }

    @Override
    public int batchIgnoreInsert(List<LogicInventoryEo> eoList) {
        if (CollectionUtils.isEmpty(eoList)) {
            return 0;
        }
        List skuCodeList = eoList.stream().filter(o -> null == o.getExpireTime() || null == o.getProduceTime()).map(LogicInventoryEo::getSkuCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            List batchList = eoList.stream().map(LogicInventoryEo::getBatch).distinct().collect(Collectors.toList());
            List logicInventoryEos = this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getSkuCode, skuCodeList)).in(LogicInventoryEo::getBatch, batchList)).isNotNull(LogicInventoryEo::getExpireTime)).isNotNull(LogicInventoryEo::getProduceTime)).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByDesc(BaseEo::getId));
            if (null == logicInventoryEos) {
                logicInventoryEos = Lists.newArrayList();
            }
            for (LogicInventoryEo logicInventoryEo : eoList) {
                LogicInventoryEo dbLogicInventoryEo = logicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)logicInventoryEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)logicInventoryEo.getBatch())).findFirst().orElse(null);
                if (null == dbLogicInventoryEo) continue;
                if (null == logicInventoryEo.getExpireTime()) {
                    logicInventoryEo.setExpireTime(dbLogicInventoryEo.getExpireTime());
                }
                if (null != logicInventoryEo.getProduceTime()) continue;
                logicInventoryEo.setProduceTime(dbLogicInventoryEo.getProduceTime());
            }
        }
        try {
            return this.das.batchIgnoreInsert(eoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic insert exception...");
            throw new WarehouseAbleException("logic insert exception...", new Object[0]);
        }
    }

    @Override
    public List<InventoryWarehouseVo> queryQualifiedCargoInventory(InventoryWarehouseVo vo) {
        return this.das.queryQualifiedCargoInventory(vo);
    }

    @Override
    public void updateWarehouseNameByWarehouseCode(String warehouseCode, String warehouseName) {
        AssertUtils.notBlank((String)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)warehouseName, (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.das.updateWarehouseNameByWarehouseCode(warehouseCode, warehouseName);
    }

    private /* synthetic */ void lambda$doBatchInsert$3(LogicInventoryEo r) {
        this.cacheService.delCache(LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r));
    }
}

