/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.proxy.item.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.api.proxy.AbstractApiProxyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemSkuQueryApiProxyImpl
extends AbstractApiProxyImpl<IItemSkuQueryApi, IItemSkuQueryApiProxy>
implements IItemSkuQueryApiProxy {
    private static final Logger log = LoggerFactory.getLogger(ItemSkuQueryApiProxyImpl.class);
    @Autowired
    IPcpItemQueryApi pcpItemQueryApi;

    @Override
    public List<ItemSkuDto> queryBySkuCodes(List<String> skuCodes) {
        ArrayList list = Lists.newArrayList();
        if (null != this.proxy()) {
            return ((IItemSkuQueryApiProxy)this.proxy()).queryBySkuCodes(skuCodes);
        }
        List itemSkuRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(skuCodes));
        log.info("\u901a\u8fc7sku\u67e5\u8be2\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemSkuRespDtoList));
        if (CollectionUtil.isEmpty((Collection)itemSkuRespDtoList)) {
            throw new BizException(StrUtil.format((CharSequence)"\u901a\u8fc7SKU Code \u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728: %s", (Object[])new Object[]{StrUtil.join((CharSequence)",", skuCodes)}));
        }
        for (PcpItemRespDto itemSkuRespDto : itemSkuRespDtoList) {
            ItemSkuDto dto = new ItemSkuDto();
            dto.setSkuCode(itemSkuRespDto.getItemCode());
            dto.setSkuName(itemSkuRespDto.getName());
            dto.setWeight(itemSkuRespDto.getQuantity());
            dto.setVolume(itemSkuRespDto.getVolume());
            list.add(dto);
        }
        return list;
    }
}

