/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.dao.das.IInventoryPreemptionDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryPreemptionDomainImpl
extends BaseDomainImpl<InventoryPreemptionEo>
implements IInventoryPreemptionDomain {
    @Autowired
    IInventoryPreemptionDas das;
    @Autowired
    IContext context;

    public ICommonDas<InventoryPreemptionEo> commonDas() {
        return this.das;
    }

    @Override
    public List<InventoryPreemptionEo> queryBySourceNo(String sourceNo) {
        if (StrUtil.isBlank((CharSequence)sourceNo)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).eq(InventoryPreemptionEo::getSourceNo, (Object)sourceNo)).eq(InventoryPreemptionEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(InventoryPreemptionEo::getDisplay, (Object)1)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public List<InventoryPreemptionEo> queryBySourceNos(List<String> sourceNos) {
        if (CollectionUtil.isEmpty(sourceNos)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryPreemptionEo.class).in(InventoryPreemptionEo::getSourceNo, sourceNos)).eq(InventoryPreemptionEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public void updatePreempt(List<InventoryPreemptionEo> eoList) {
        if (CollectionUtil.isEmpty(eoList)) {
            return;
        }
        this.das.updatePreempt(eoList);
    }

    @Override
    public void allRelease(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        String updatePerson = StrUtil.isBlank((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        this.das.allRelease(ids, updatePerson);
    }

    @Override
    public List<InventoryPreemptionEo> queryBySourceNo(String sourceNo, String valid) {
        return this.das.queryBySourceNo(sourceNo, valid);
    }

    @Override
    public Integer searchCountForLessNum(String sourceNo) {
        return this.das.searchCountForLessNum(sourceNo);
    }

    @Override
    public Integer updateActivePreempt(InventoryPreemptionEo inventoryPreemptionEo) {
        return this.das.updateActivePreempt(inventoryPreemptionEo);
    }
}

