/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.utils;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DataExtractUtils {
    public static <T> T ifNullElse(T v1, T v2) {
        return (T)Optional.ofNullable(v1).filter(v -> {
            if (v instanceof String) {
                return StringUtils.isNotBlank((CharSequence)((String)v));
            }
            return true;
        }).orElse(v2);
    }

    public static BigDecimal ifLtZeroSetZero(BigDecimal v1) {
        return Optional.ofNullable(v1).filter(BigDecimalUtils::geZero).orElse(BigDecimal.ZERO);
    }

    public static <T> T getBatch(T v1, T v2) {
        return (T)Optional.ofNullable(v1).filter(v -> {
            if (v instanceof String) {
                return StringUtils.isNotBlank((CharSequence)((String)v));
            }
            return true;
        }).orElse(v2);
    }

    public static List<String> strToList(String v1, String split) {
        return Optional.ofNullable(v1).filter(StringUtils::isNotBlank).map(d -> Arrays.stream(d.split(split)).collect(Collectors.toList())).orElse(null);
    }

    public static <T> List<T> jsonStrToList(String v1, Class<T> claaz) {
        return Optional.ofNullable(v1).filter(StringUtils::isNotBlank).map(d -> JSONArray.parseArray((String)d, (Class)claaz)).orElse(Lists.newArrayList());
    }

    public static List<String> ifNull(String v1, String split) {
        return Optional.ofNullable(v1).filter(StringUtils::isNotBlank).map(d -> Arrays.stream(d.split(split)).collect(Collectors.toList())).orElse(null);
    }

    public static <T> T ifNullElse(T v1, Function<T, T> v2) {
        return (T)Optional.ofNullable(v1).filter(v -> {
            if (v instanceof String) {
                return StringUtils.isNotBlank((CharSequence)((String)v));
            }
            return true;
        }).orElseGet(() -> v2.apply(null));
    }
}

