/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcAble;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcExecuteManager;
import com.yunxi.dg.base.center.inventory.service.commons.LuaExecutor;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RdsCalcExecuteManager
extends BaseAble
implements ICalcExecuteManager,
MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RdsCalcExecuteManager.class);
    @Resource
    private ICalcAble calcAble;
    @Resource
    private LuaExecutor luaExecutor;
    @Value(value="${inventory.config.waitReleaseTime:20}")
    private Long waitReleaseTime;
    static final Map<String, Integer> BARRIER_MAP = new ConcurrentHashMap<String, Integer>(16);
    ThreadLocal<CalcExecuteBo> calcBatchExecuteLocal = new ThreadLocal();
    ThreadLocal<CalcExecuteBo> calcTotalExecuteLocal = new ThreadLocal();
    ThreadLocal<Boolean> registerFlag = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final String redisSetKey = "{inventory}:calc:set:key";
    private final String acquireScript = this.getTextByPath("/lua/acquire.lua");
    private final String releaseScript = this.getTextByPath("/lua/release.lua");

    @Override
    public synchronized void register(CalcExecuteBo calcExecuteBo) {
        CalcExecuteBo localCalc;
        if (!this.registerFlag.get().booleanValue()) {
            this.registerEvent();
        }
        if (calcExecuteBo.isUpdateModel()) {
            localCalc = this.calcBatchExecuteLocal.get();
            if (Objects.isNull(localCalc)) {
                this.calcBatchExecuteLocal.set(calcExecuteBo);
                return;
            }
        } else {
            localCalc = this.calcTotalExecuteLocal.get();
            if (Objects.isNull(localCalc)) {
                this.calcTotalExecuteLocal.set(calcExecuteBo);
                return;
            }
        }
        this.mergeExecuteBo(localCalc, calcExecuteBo);
    }

    private void registerEvent() {
        log.info("\u6ce8\u518c\u4e8b\u4ef6");
        this.registerFlag.set(true);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void beforeCommit(boolean readOnly) {
                log.info("\u6267\u884c\u5e95\u5c42\u66f4\u65b0:{},{}", (Object)Thread.currentThread().getName(), (Object)readOnly);
                RdsCalcExecuteManager.this.execute();
            }

            public int getOrder() {
                return Integer.MAX_VALUE;
            }
        });
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCompletion(int status) {
                if (status == 1) {
                    log.info("\u6e05\u7406\u66f4\u65b0\u903b\u8f911:{},{}", (Object)Thread.currentThread().getName(), (Object)status);
                    RdsCalcExecuteManager.this.registerFlag.set(false);
                    RdsCalcExecuteManager.this.calcTotalExecuteLocal.remove();
                    RdsCalcExecuteManager.this.calcBatchExecuteLocal.remove();
                } else if (status == 2 && RdsCalcExecuteManager.this.registerFlag.get().booleanValue()) {
                    log.info("\u6e05\u7406\u66f4\u65b0\u903b\u8f912:{},{}", (Object)Thread.currentThread().getName(), (Object)status);
                    RdsCalcExecuteManager.this.registerFlag.set(false);
                    RdsCalcExecuteManager.this.calcTotalExecuteLocal.remove();
                    RdsCalcExecuteManager.this.calcBatchExecuteLocal.remove();
                }
            }

            public void afterCommit() {
                log.info("\u6e05\u7406\u66f4\u65b0\u903b\u8f91:{}", (Object)Thread.currentThread().getName());
                RdsCalcExecuteManager.this.registerFlag.set(false);
                RdsCalcExecuteManager.this.calcTotalExecuteLocal.remove();
                RdsCalcExecuteManager.this.calcBatchExecuteLocal.remove();
            }

            public int getOrder() {
                return Integer.MIN_VALUE;
            }
        });
    }

    @Override
    public void execute() {
        CalcExecuteBo calcExecuteBo = this.calcBatchExecuteLocal.get();
        CalcExecuteBo totalCalcExecuteBo = this.calcTotalExecuteLocal.get();
        if (Objects.isNull(calcExecuteBo) && Objects.isNull(totalCalcExecuteBo)) {
            return;
        }
        CalcExecuteBo curCalcExecuteBo = Objects.isNull(calcExecuteBo) ? totalCalcExecuteBo : calcExecuteBo;
        Set<String> handlerKeys = curCalcExecuteBo.getCalcDto().stream().flatMap(d -> d.getDetails().stream().map(re -> this.getBatchKey(re.getWarehouseCode(), re.getSkuCode(), (String)DataExtractUtils.ifNullElse((Object)re.getBatch(), (Object)"")))).collect(Collectors.toSet());
        if (Objects.nonNull(totalCalcExecuteBo)) {
            handlerKeys.addAll(totalCalcExecuteBo.getCalcDto().stream().flatMap(d -> d.getDetails().stream().map(re -> this.getBatchKey(re.getWarehouseCode(), re.getSkuCode(), ""))).collect(Collectors.toSet()));
        }
        long expireTime = System.currentTimeMillis() + 58000L;
        try {
            long count = 11L;
            while (expireTime > System.currentTimeMillis() && !this.tryAcquire(handlerKeys, count)) {
                this.waitRelease(expireTime);
            }
            if (expireTime <= System.currentTimeMillis()) {
                throw new BizException("\u5e93\u5b58\u64cd\u4f5c\u6267\u884c\u8d85\u65f6");
            }
            this.putBarrier(handlerKeys);
            this.doExecute(calcExecuteBo, totalCalcExecuteBo);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.getCommitAfterHandler(handlerKeys));
            if (log.isDebugEnabled()) {
                log.debug("\u5e93\u5b58\u66f4\u65b0\u5904\u7406\u5b8c\u6bd5\u65f6\u95f4:{}", (Object)(System.currentTimeMillis() - expireTime + 58000L));
            }
            this.registerFlag.set(false);
        }
        catch (WarehouseAbleException e) {
            this.release(handlerKeys);
            throw new WarehouseAbleException(String.join((CharSequence)",", handlerKeys), new Object[0]);
        }
        catch (Exception e) {
            this.release(handlerKeys);
            throw e;
        }
        finally {
            this.calcTotalExecuteLocal.remove();
            this.calcBatchExecuteLocal.remove();
            this.registerFlag.set(false);
        }
    }

    private void waitRelease(long expireTime) {
        try {
            Thread.sleep(this.waitReleaseTime);
        }
        catch (InterruptedException e) {
            log.info("\u4e2d\u65ad\u5f02\u5e38" + expireTime);
        }
    }

    private void putBarrier(Collection<String> handlerKeys) {
        handlerKeys.forEach(k -> BARRIER_MAP.put((String)k, 1));
    }

    @NotNull
    private TransactionSynchronization getCommitAfterHandler(final Set<String> handlerKeys) {
        return new TransactionSynchronization(){

            public void afterCommit() {
                log.info("\u5e93\u5b58\u66f4\u65b0\u5904\u7406\u5b8c\u6bd5, \u91ca\u653e\u5c4f\u969c");
                RdsCalcExecuteManager.this.release(handlerKeys);
            }

            public int getOrder() {
                return 1;
            }
        };
    }

    private void release(Set<String> handlerKeys) {
        this.luaExecutor.executeLua(this.releaseScript, Lists.newArrayList((Object[])new String[]{"{inventory}:calc:set:key"}), new ArrayList<String>(handlerKeys));
        this.removeBarrier(handlerKeys);
    }

    private void removeBarrier(Set<String> handlerKeys) {
        handlerKeys.forEach(BARRIER_MAP::remove);
    }

    private boolean tryAcquire(Set<String> handlerKeys, long count) {
        if (this.barrier(handlerKeys, count)) {
            return false;
        }
        List<String> s = this.luaExecutor.executeLuaList(this.acquireScript, Lists.newArrayList((Object[])new String[]{"{inventory}:calc:set:key"}), new ArrayList<String>(handlerKeys));
        if (s instanceof List) {
            List<String> s1 = s.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(s1)) {
                return true;
            }
            this.putBarrier(s1);
            return false;
        }
        if (s instanceof String) {
            String s1 = (String)((Object)s);
            if (StringUtils.isBlank((CharSequence)s1)) {
                return true;
            }
            this.putBarrier(Lists.newArrayList((Object[])new String[]{s1}));
            return false;
        }
        return true;
    }

    private boolean barrier(Set<String> handlerKeys, long count) {
        int temp = 10;
        if (count % (long)temp == 0L) {
            return false;
        }
        return BARRIER_MAP.keySet().stream().anyMatch(handlerKeys::contains);
    }

    private void doExecute(CalcExecuteBo calcExecuteBo, CalcExecuteBo totalCalcExecuteBo) {
        CalcInventoryDto calcInventoryDto;
        CalcExecuteBo executeBo = Objects.isNull(calcExecuteBo) ? totalCalcExecuteBo : calcExecuteBo;
        ArrayList<LogicWarehouseEo> logicWarehouseEos = new ArrayList<LogicWarehouseEo>(executeBo.getLogicWarehouseEos().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (o, o1) -> o)).values());
        List<CalcInventoryDetailDto> details = executeBo.getCalcDto().stream().flatMap(d -> d.getDetails().stream()).collect(Collectors.toList());
        Result result = this.findAllInventory(calcExecuteBo, totalCalcExecuteBo, details, executeBo, logicWarehouseEos);
        this.handlerLog(new CalcLogSaveBo(calcExecuteBo, totalCalcExecuteBo, details, logicWarehouseEos, Objects.nonNull(calcExecuteBo), JSONArray.parseArray((String)JSONObject.toJSONString(result.logicInventoryEos), LogicInventoryEo.class), JSONArray.parseArray((String)JSONObject.toJSONString(result.logicInventoryTotalEos), LogicInventoryTotalEo.class)));
        if (Objects.nonNull(calcExecuteBo)) {
            calcInventoryDto = this.mergeCalcInventoryDto(calcExecuteBo.getCalcDto());
            this.calcAble.calcLogic(calcInventoryDto, logicWarehouseEos, result.logicInventoryEos);
        }
        calcInventoryDto = this.mergeCalcInventoryDto(totalCalcExecuteBo.getCalcDto());
        this.calcAble.calcLogicTotal(calcInventoryDto, new ArrayList<LogicWarehouseEo>(totalCalcExecuteBo.getLogicWarehouseEos()), result.logicInventoryTotalEos);
    }

    private Result findAllInventory(CalcExecuteBo calcExecuteBo, CalcExecuteBo totalCalcExecuteBo, List<CalcInventoryDetailDto> details, CalcExecuteBo executeBo, List<LogicWarehouseEo> logicWarehouseEos) {
        Set skuCodes = details.stream().map(CalcInventoryDetailDto::getSkuCode).collect(Collectors.toSet());
        if (Objects.nonNull(calcExecuteBo)) {
            skuCodes.addAll(totalCalcExecuteBo.getCalcDto().stream().flatMap(d -> d.getDetails().stream().map(CalcInventoryDetailDto::getSkuCode)).collect(Collectors.toList()));
            executeBo.getLogicWarehouseEos().addAll(totalCalcExecuteBo.getLogicWarehouseEos());
        }
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(new ArrayList<String>(skuCodes));
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        List<LogicInventoryEo> logicInventoryEos = null;
        if (Objects.nonNull(calcExecuteBo)) {
            List batches = Optional.of(calcExecuteBo).map(r -> r.getCalcDto().stream().flatMap(c -> c.getDetails().stream()).collect(Collectors.toList())).map(curDetails -> curDetails.stream().map(CalcInventoryDetailDto::getBatch).distinct().collect(Collectors.toList())).orElse(new ArrayList());
            Set<String> filterKeys = Optional.of(calcExecuteBo).map(r -> r.getCalcDto().stream().flatMap(c -> c.getDetails().stream()).collect(Collectors.toList())).orElse(Lists.newArrayList()).stream().map(r -> r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch()).collect(Collectors.toSet());
            logicInventoryEos = this.queryLogicInventoryEos(skuDtoList, logicWarehouseEos, batches, filterKeys);
            AssertUtils.notEmpty(logicInventoryEos, (String)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        }
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(skuDtoList, logicWarehouseEos);
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u903b\u8f91\u603b\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        return new Result(logicInventoryEos, logicInventoryTotalEos);
    }

    private void handlerLog(CalcLogSaveBo calcLogSaveBo) {
        log.info("\u64cd\u4f5c\u6d41\u6c34\u65e5\u5fd7\uff1a{}", (Object)JSONObject.toJSONString((Object)calcLogSaveBo));
        ArrayList operateLogEos = Lists.newArrayList();
        ArrayList logEos = Lists.newArrayList();
        if (calcLogSaveBo.isHasBatch()) {
            Map<String, Long> batchMap = calcLogSaveBo.getLogicInventoryEos().stream().collect(Collectors.toMap(l -> this.getBatchKey(l.getSkuCode(), l.getWarehouseCode(), l.getBatch()), BaseEo::getId, (o, o1) -> o));
            calcLogSaveBo.getDetails().forEach(re -> re.setInventoryId((Long)batchMap.get(this.getBatchKey(re.getSkuCode(), re.getWarehouseCode(), re.getBatch()))));
            log.info("\u64cd\u4f5c\u6d41\u6c34\u8be6\u60c5\u8bbe\u7f6e\u503c\u65e5\u5fd7\uff1a{}", (Object)JSONObject.toJSONString(calcLogSaveBo.getDetails()));
            calcLogSaveBo.getCalcExecuteBo().getCalcDto().forEach(re -> this.calcAble.createLogicLogs((CalcInventoryDto)re, calcLogSaveBo.getLogicWarehouseEos(), calcLogSaveBo.getLogicInventoryEos(), operateLogEos, logEos));
            Map<String, Long> totalMap = calcLogSaveBo.getLogicInventoryTotalEos().stream().collect(Collectors.toMap(l -> this.getTotalKey(l.getWarehouseCode(), l.getSkuCode()), BaseEo::getId, (o, o1) -> o));
            calcLogSaveBo.getTotalCalcExecuteBo().getCalcDto().forEach(re -> re.getDetails().forEach(r -> r.setInventoryId((Long)totalMap.get(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode())))));
        } else {
            Map<String, Long> totalMap = calcLogSaveBo.getLogicInventoryTotalEos().stream().collect(Collectors.toMap(l -> this.getTotalKey(l.getWarehouseCode(), l.getSkuCode()), BaseEo::getId, (o, o1) -> o));
            calcLogSaveBo.getDetails().forEach(r -> r.setInventoryId((Long)totalMap.get(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode()))));
        }
        log.info("\u64cd\u4f5c\u5e93\u5b58\u603b\u8868\u6d41\u6c34\u8be6\u60c5\u8bbe\u7f6e\u503c\u65e5\u5fd7\uff1a{}", (Object)JSONObject.toJSONString(calcLogSaveBo.getTotalCalcExecuteBo().getCalcDto()));
        calcLogSaveBo.getTotalCalcExecuteBo().getCalcDto().forEach(re -> this.calcAble.createLogicTotalLogs((CalcInventoryDto)re, calcLogSaveBo.getLogicWarehouseEos(), calcLogSaveBo.getLogicInventoryTotalEos(), operateLogEos, logEos));
        this.saveLog(operateLogEos, logEos);
    }

    @NotNull
    private String getBatchKey(String skuCode, String warehouseCode, String batch) {
        return skuCode + InventoryConfig.getCommonSeparate() + warehouseCode + InventoryConfig.getCommonSeparate() + InventoryConfig.getCommonSeparate() + batch;
    }

    private void mergeExecuteBo(CalcExecuteBo o, CalcExecuteBo o1) {
        List<CalcInventoryDto> calcDto = o.getCalcDto();
        calcDto.addAll(o1.getCalcDto());
        o.getLogicWarehouseEos().addAll(o1.getLogicWarehouseEos());
    }

    private CalcInventoryDto mergeCalcInventoryDto(List<CalcInventoryDto> calcDtoList) {
        CalcInventoryDto calcDto = calcDtoList.get(0);
        for (int i = 1; i < calcDtoList.size(); ++i) {
            CalcInventoryDto curCalc = calcDtoList.get(i);
            calcDto.setValidNegative(Boolean.valueOf(curCalc.getValidNegative() != false || calcDto.getValidNegative() != false));
            calcDto.getDetails().addAll(curCalc.getDetails());
        }
        return calcDto;
    }

    public void onMessage(@NotNull Message message, byte[] bytes) {
        String messageBody = new String(message.getBody(), StandardCharsets.UTF_8);
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u6536\u5230\u53d8\u66f4\u6d88\u606f:{}, {}", (Object)messageBody, (Object)new String(message.getChannel(), StandardCharsets.UTF_8));
        }
        Set<String> removeList = Arrays.stream(messageBody.replaceAll("\"", "").split(",")).collect(Collectors.toSet());
        this.removeBarrier(removeList);
        this.notify(message, messageBody);
    }

    private void notify(Message message, String messageBody) {
    }

    private String getTextByPath(String path) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(path);
        assert (resourceAsStream != null);
        return new BufferedReader(new InputStreamReader(resourceAsStream)).lines().collect(Collectors.joining("\n"));
    }

    private static class CalcLogSaveBo {
        private final CalcExecuteBo calcExecuteBo;
        private final CalcExecuteBo totalCalcExecuteBo;
        private final List<CalcInventoryDetailDto> details;
        private final List<LogicWarehouseEo> logicWarehouseEos;
        private final boolean hasBatch;
        private final List<LogicInventoryEo> logicInventoryEos;
        private final List<LogicInventoryTotalEo> logicInventoryTotalEos;

        private CalcLogSaveBo(CalcExecuteBo calcExecuteBo, CalcExecuteBo totalCalcExecuteBo, List<CalcInventoryDetailDto> details, List<LogicWarehouseEo> logicWarehouseEos, boolean hasBatch, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
            this.calcExecuteBo = calcExecuteBo;
            this.totalCalcExecuteBo = totalCalcExecuteBo;
            this.details = details;
            this.logicWarehouseEos = logicWarehouseEos;
            this.hasBatch = hasBatch;
            this.logicInventoryEos = logicInventoryEos;
            this.logicInventoryTotalEos = logicInventoryTotalEos;
        }

        public CalcExecuteBo getCalcExecuteBo() {
            return this.calcExecuteBo;
        }

        public CalcExecuteBo getTotalCalcExecuteBo() {
            return this.totalCalcExecuteBo;
        }

        public List<CalcInventoryDetailDto> getDetails() {
            return this.details;
        }

        public List<LogicWarehouseEo> getLogicWarehouseEos() {
            return this.logicWarehouseEos;
        }

        public boolean isHasBatch() {
            return this.hasBatch;
        }

        public List<LogicInventoryEo> getLogicInventoryEos() {
            return this.logicInventoryEos;
        }

        public List<LogicInventoryTotalEo> getLogicInventoryTotalEos() {
            return this.logicInventoryTotalEos;
        }
    }

    private static class Result {
        public final List<LogicInventoryEo> logicInventoryEos;
        public final List<LogicInventoryTotalEo> logicInventoryTotalEos;

        public Result(List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
            this.logicInventoryEos = logicInventoryEos;
            this.logicInventoryTotalEos = logicInventoryTotalEos;
        }
    }
}

